/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build.site;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.build.IPDEBuildConstants;
import org.eclipse.pde.internal.build.Messages;
import org.eclipse.pde.internal.build.PDEUIStateWrapper;
import org.eclipse.pde.internal.build.Utils;
import org.eclipse.pde.internal.build.site.BuildTimeSite;
import org.eclipse.pde.internal.build.site.BuildTimeSiteContentProvider;
import org.eclipse.pde.internal.build.site.PluginPathFinder;
import org.eclipse.pde.internal.build.site.compatibility.FeatureReference;

public class BuildTimeSiteFactory
implements IPDEBuildConstants {
    private BuildTimeSite site = null;
    private boolean urlsChanged = false;
    private List<File> sitePaths;
    private String[] eeSources;
    private static String installedBaseLocation = null;
    private boolean reportResolutionErrors;
    private PDEUIStateWrapper pdeUIState;
    private List<String> rootFeaturesForFilter;
    private List<String> rootPluginsForFilter;
    private boolean filterState;
    private boolean filterP2Base = false;

    public BuildTimeSite createSite() throws CoreException {
        if (this.site != null && !this.urlsChanged) {
            return this.site;
        }
        this.urlsChanged = false;
        this.site = this.createSiteMapModel();
        Collection<File> featureXMLs = this.findFeatureXMLs();
        String installedBaseURL = null;
        if (installedBaseLocation != null && !installedBaseLocation.equals("")) {
            if (!new File(installedBaseLocation).exists()) {
                String message = NLS.bind((String)Messages.error_incorrectDirectoryEntry, (Object)installedBaseLocation);
                installedBaseLocation = null;
                throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 6, message, null));
            }
            installedBaseURL = installedBaseLocation;
            Collection<File> installedFeatures = Utils.findFiles(new File(installedBaseLocation), "features", "feature.xml");
            if (installedFeatures != null) {
                featureXMLs.addAll(installedFeatures);
            }
            List<File> featureDirectories = PluginPathFinder.getFeaturePaths(installedBaseURL);
            for (File element : featureDirectories) {
                File featureXML = new File(element, "feature.xml");
                if (!featureXML.exists()) continue;
                featureXMLs.add(featureXML);
            }
        }
        for (File featureXML : featureXMLs) {
            if (!featureXML.exists()) continue;
            FeatureReference featureRef = this.createFeatureReferenceModel();
            featureRef.setSiteModel(this.site);
            featureRef.setPath(featureXML.toPath().toAbsolutePath());
            this.site.addFeatureReferenceModel(featureRef);
        }
        BuildTimeSiteContentProvider contentProvider = new BuildTimeSiteContentProvider(this.sitePaths, installedBaseURL, this.pdeUIState);
        contentProvider.setFilterP2Base(this.filterP2Base);
        this.site.setSiteContentProvider(contentProvider);
        contentProvider.setSite(this.site);
        return this.site;
    }

    public BuildTimeSite createSiteMapModel() {
        BuildTimeSite model = new BuildTimeSite();
        model.setReportResolutionErrors(this.reportResolutionErrors);
        model.setFilter(this.filterState);
        model.setRootFeaturesForFilter(this.rootFeaturesForFilter);
        model.setRootPluginsForFiler(this.rootPluginsForFilter);
        model.setEESources(this.eeSources);
        return model;
    }

    public static void setInstalledBaseSite(String installedBaseSite) {
        installedBaseLocation = installedBaseSite;
    }

    public void setSitePaths(List<File> paths) {
        if (this.sitePaths == null) {
            this.sitePaths = paths;
            this.urlsChanged = true;
            return;
        }
        if (!new HashSet<File>(this.sitePaths).equals(new HashSet<File>(paths))) {
            this.sitePaths = paths;
            this.urlsChanged = true;
        }
    }

    private Collection<File> findFeatureXMLs() {
        ArrayList<File> features = new ArrayList<File>();
        Collection<File> foundFeatures = null;
        for (File sitePath : this.sitePaths) {
            File file = new File(sitePath, "feature.xml");
            if (file.exists()) {
                features.add(file);
                continue;
            }
            foundFeatures = new File(sitePath, "features").exists() ? Utils.findFiles(sitePath, "features", "feature.xml") : Utils.findFiles(sitePath, ".", "feature.xml");
            if (foundFeatures == null) continue;
            features.addAll(foundFeatures);
        }
        return features;
    }

    public void setReportResolutionErrors(boolean value) {
        this.reportResolutionErrors = value;
    }

    public void setInitialState(PDEUIStateWrapper uiState) {
        this.pdeUIState = uiState;
    }

    public void setFilterState(boolean b) {
        this.filterState = b;
    }

    public void setFilterRoots(List<String> featuresForFilterRoots, List<String> pluginsForFilterRoots) {
        this.rootFeaturesForFilter = featuresForFilterRoots;
        this.rootPluginsForFilter = pluginsForFilterRoots;
    }

    public FeatureReference createFeatureReferenceModel() {
        return new FeatureReference();
    }

    public void setFilterP2Base(boolean filterP2Base) {
        this.filterP2Base = filterP2Base;
    }

    public void setEESources(String[] sources) {
        this.eeSources = sources;
    }
}

