/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.gef;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.gef.EditPartListener;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellEditorListener;

public class DirectEditorContainer {
    private DirectEditManager manager;

    public DirectEditorContainer(DirectEditManager mgr) {
        this.manager = mgr;
    }

    public DirectEditManager getManager() {
        return this.manager;
    }

    public void commit() {
        this.callVoidMethod("handleValueChanged");
        this.callVoidMethod("commit");
    }

    public void bringDown() {
        this.callVoidMethod("bringDown");
    }

    private void callVoidMethod(String methodName) {
        try {
            Method method = DirectEditManager.class.getDeclaredMethod(methodName, new Class[0]);
            method.setAccessible(true);
            method.invoke((Object)this.manager, new Object[0]);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public CellEditor getCellEditor() {
        try {
            Method method = DirectEditManager.class.getDeclaredMethod("getCellEditor", new Class[0]);
            method.setAccessible(true);
            CellEditor editor = (CellEditor)method.invoke((Object)this.manager, new Object[0]);
            return editor;
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return null;
    }

    public Object getProperty(String name) {
        try {
            Field field = DirectEditManager.class.getDeclaredField(name);
            field.setAccessible(true);
            return field.get(this.manager);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        return null;
    }

    public void removeListeners() {
        CellEditor cellEditor = this.getCellEditor();
        Object listener = this.getProperty("cellEditorListener");
        Object source = this.getProperty("source");
        Object editPartListener = this.getProperty("editPartListener");
        if (listener != null) {
            cellEditor.removeListener((ICellEditorListener)listener);
        }
        if (source != null && editPartListener != null) {
            ((GraphicalEditPart)source).removeEditPartListener((EditPartListener)editPartListener);
        }
    }
}

