/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.core.persistence;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.BasicExtendedMetaData;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLInfoImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLMapImpl;
import org.eclipse.rcptt.core.persistence.BasePersistenceModel;
import org.eclipse.rcptt.core.persistence.IPersistenceModel;
import org.eclipse.rcptt.core.persistence.IPersistenceModelFactory;
import org.eclipse.rcptt.core.persistence.PersistenceFactoryManager;
import org.eclipse.rcptt.core.persistence.plain.IPlainConstants;
import org.eclipse.rcptt.core.persistence.plain.IPlainTextPersistenceExtension;
import org.eclipse.rcptt.core.persistence.plain.PlainTextPersistenceExtensionManager;
import org.eclipse.rcptt.core.scenario.NamedElement;
import org.eclipse.rcptt.core.scenario.Scenario;
import org.eclipse.rcptt.core.workspace.Q7Utils;
import org.eclipse.rcptt.core.workspace.WorkspaceSynchronizer;
import org.eclipse.rcptt.ecl.core.CoreFactory;
import org.eclipse.rcptt.ecl.core.CorePackage;
import org.eclipse.rcptt.ecl.core.Script;
import org.eclipse.rcptt.internal.core.Q7LazyResource;
import org.eclipse.rcptt.internal.core.RcpttPlugin;
import org.eclipse.rcptt.tesla.core.TeslaSerializationOptions;
import org.eclipse.rcptt.tesla.core.protocol.raw.TeslaScenario;
import org.eclipse.rcptt.tesla.recording.core.ecl.EclRecorder;
import org.eclipse.rcptt.util.FileUtil;

public class PersistenceManager
implements IPlainConstants {
    public static final String CONTENT_ENTRY = ".q7.content";
    public static final String ECL_CONTENT_ENTRY = ".content";
    public static final String DESCRIPTION_ENTRY = ".description";
    public static final String TESLA_CONTENT_ENTRY = ".content.raw";
    private static PersistenceManager persistenceManager;
    private Map<Resource, IPersistenceModel> resourceOnlyModels = Collections.synchronizedMap(new HashMap());
    private static Map<String, String> legacyNamespaces;

    static {
        legacyNamespaces = new HashMap<String, String>();
        legacyNamespaces.put("http://com/xored/q7/scenario.ecore", "http://eclipse.org/rcptt/model/scenario.ecore");
        legacyNamespaces.put("http:///com/xored/q7/scenario.ecore", "http://eclipse.org/rcptt/model/scenario.ecore");
        legacyNamespaces.put("http://com/xored/q7/filesystem.ecore", "http://eclipse.org/rcptt/ctx/filesystem");
        legacyNamespaces.put("http://xored.com/q7/debug", "http://eclipse.org/rcptt/ctx/debug");
        legacyNamespaces.put("http:///com/xored/q7/workspace.ecore", "http://eclipse.org/rcptt/ctx/workspace");
        legacyNamespaces.put("http://com/xored/q7/parameters.ecore", "http://eclipse.org/rcptt/ctx/parameters");
        legacyNamespaces.put("http:///com/xored/q7/preferences.ecore", "http://eclipse.org/rcptt/ctx/preferences");
        legacyNamespaces.put("http:///com/xored/q7/ecl/context.ecore", "http://eclipse.org/rcptt/ctx/ecl");
        legacyNamespaces.put("http://com/xored/q7/verifications/log.ecore", "http://eclipse.org/rcptt/verifications/log");
        legacyNamespaces.put("http://com/xored/q7/verifications/text.ecore", "http://eclipse.org/rcptt/verifications/text");
        legacyNamespaces.put("http://com/xored/q7/verifications/time.ecore", "http://eclipse.org/rcptt/verifications/time");
        legacyNamespaces.put("http://com/xored/q7/verifications/tree.ecore", "http://eclipse.org/rcptt/verifications/tree");
        legacyNamespaces.put("http:///com/xored/tesla/core/protocol/raw.ecore", "http://eclipse.org/rcptt/tesla/rawprotocol");
        legacyNamespaces.put("http:///com/xored/tesla/core/ui.ecore", "http://eclipse.org/rcptt/tesla/widgets");
        legacyNamespaces.put("http:///com/xored/tesla/core/protocol.ecore", "http://eclipse.org/rcptt/tesla/protocol");
        legacyNamespaces.put("http:///com/xored/tesla/core/info.ecore", "http://eclipse.org/rcptt/tesla/info");
        legacyNamespaces.put("http:///com/xored/tesla/core/diagram.ecore", "http://eclipse.org/rcptt/tesla/diagram");
    }

    private PersistenceManager() {
        File root = RcpttPlugin.getDefault().getStateLocation().append("attachments").toFile();
        FileUtil.deleteFiles((File[])root.listFiles());
    }

    public static synchronized PersistenceManager getInstance() {
        if (persistenceManager == null) {
            persistenceManager = new PersistenceManager();
        }
        return persistenceManager;
    }

    public IPersistenceModel getModel(Resource element) {
        IFile file = WorkspaceSynchronizer.getFile(element);
        return this.getModel(this.detectFormatProxy(file), element);
    }

    public synchronized IPersistenceModel getModel(IPersistenceModelFactory factory, Resource element) {
        if (element == null) {
            return null;
        }
        if (element.getURI() == null) {
            return null;
        }
        IPersistenceModel model = this.resourceOnlyModels.get(element);
        if (model == null) {
            model = factory.createModel(element);
            this.replaceModel(element, model);
        }
        return model;
    }

    private void internalRemove(Resource element) {
        IPersistenceModel old = this.resourceOnlyModels.remove(element);
        if (old != null) {
            old.dispose();
        }
    }

    private void replaceModel(Resource element, IPersistenceModel newModel) {
        IPersistenceModel old = this.resourceOnlyModels.put(element, newModel);
        if (old != null) {
            old.dispose();
        }
    }

    public static Map<String, Object> getOptions() {
        HashMap<String, Object> options = new HashMap<String, Object>();
        EAttribute content = CorePackage.eINSTANCE.getScript_Content();
        XMLMapImpl map = new XMLMapImpl();
        XMLInfoImpl x = new XMLInfoImpl();
        x.setXMLRepresentation(0);
        map.add((ENamedElement)content, (XMLResource.XMLInfo)x);
        TeslaSerializationOptions.fillOptions((XMLMapImpl)map);
        options.put("XML_MAP", map);
        options.put("ENCODING", "utf-8");
        options.put("ESCAPE_USING_CDATA", Boolean.TRUE);
        options.put("SKIP_ESCAPE", Boolean.FALSE);
        options.put("EXTENDED_META_DATA", new BasicExtendedMetaData(){

            public EPackage getPackage(String namespace) {
                if (legacyNamespaces.containsKey(namespace)) {
                    namespace = (String)legacyNamespaces.get(namespace);
                }
                return super.getPackage(namespace);
            }
        });
        return options;
    }

    public void saveResource(Resource element) {
        this.saveResource(element, false);
    }

    public void saveResource(Resource element, boolean doConvert) {
        if (element == null) {
            RcpttPlugin.log("Null resources is passed to Q7 resource monitor", null);
            return;
        }
        IPersistenceModel model = this.getModel(element);
        this.updateScenarioContent(element, model);
        HashSet<String> names = new HashSet<String>(Arrays.asList(model.getNames()));
        names.add(CONTENT_ENTRY);
        if (!model.isSupportMultiItems()) {
            model = this.replaceModelWith(element, model);
        }
        try {
            model.extractAll();
            model.updateAttributes();
            if (model.isContentEntryRequired()) {
                OutputStream store = model.store(CONTENT_ENTRY);
                this.saveResourceWithUpdate(element, store);
                store.close();
            } else {
                model.delete(CONTENT_ENTRY);
            }
            File file = model.storeToTemporaty();
            IFile location = Q7Utils.getLocation(element);
            BufferedInputStream stream = new BufferedInputStream(new FileInputStream(file));
            if (location.exists()) {
                location.setContents((InputStream)stream, true, true, (IProgressMonitor)new NullProgressMonitor());
            } else {
                location.create((InputStream)stream, true, (IProgressMonitor)new NullProgressMonitor());
            }
            stream.close();
            file.delete();
            model.setUnmodified();
        }
        catch (Throwable e) {
            RcpttPlugin.log(e);
        }
    }

    public IPersistenceModel replaceModelWith(Resource element, IPersistenceModel model) {
        IPersistenceModelFactory defaultFactory = PersistenceFactoryManager.getInstance().getDefaultFactory();
        IPersistenceModel modelCopy = defaultFactory.createModel(element);
        modelCopy.copyFrom(model);
        model.dispose();
        this.replaceModel(element, modelCopy);
        model = modelCopy;
        return model;
    }

    private void saveResourceWithUpdate(Resource element, OutputStream store) {
        try {
            XMIResourceImpl tempResource = new XMIResourceImpl(element.getURI());
            EList contents = element.getContents();
            Collection copyAll = EcoreUtil.copyAll((Collection)contents);
            tempResource.getContents().addAll(copyAll);
            for (EObject eObject : copyAll) {
                IPlainTextPersistenceExtension[] extensions;
                if (eObject instanceof Scenario) {
                    ((Scenario)eObject).setContent(null);
                    ((Scenario)eObject).setTeslaContent(null);
                }
                if (eObject instanceof NamedElement) {
                    ((NamedElement)eObject).setDescription(null);
                }
                IPlainTextPersistenceExtension[] iPlainTextPersistenceExtensionArray = extensions = PlainTextPersistenceExtensionManager.getInstance().getExtensions();
                int n = extensions.length;
                int n2 = 0;
                while (n2 < n) {
                    IPlainTextPersistenceExtension ext = iPlainTextPersistenceExtensionArray[n2];
                    ext.performObjectPreSaveUpdate(eObject);
                    ++n2;
                }
            }
            tempResource.save(store, PersistenceManager.getOptions());
        }
        catch (IOException e) {
            RcpttPlugin.log(e);
        }
    }

    public void updateScenarioContent(Resource element, IPersistenceModel model) {
        EList contents = element.getContents();
        Scenario sc = null;
        NamedElement ne = null;
        if (contents.size() == 1) {
            EObject val0 = (EObject)contents.get(0);
            if (val0 instanceof Scenario) {
                sc = (Scenario)val0;
            }
            if (val0 instanceof NamedElement) {
                ne = (NamedElement)val0;
            }
        }
        if (ne != null) {
            String description = ne.getDescription();
            if (description != null) {
                this.storeEObjectIn(model.store(DESCRIPTION_ENTRY), description);
            } else {
                model.delete(DESCRIPTION_ENTRY);
            }
        }
        if (sc != null) {
            EObject teslaContent = sc.getTeslaContent();
            EObject content = sc.getContent();
            if (content instanceof TeslaScenario && teslaContent == null) {
                teslaContent = content;
                content = null;
            }
            if (teslaContent instanceof TeslaScenario && content == null) {
                Script script = CoreFactory.eINSTANCE.createScript();
                script.setContent(new EclRecorder().generateCode((TeslaScenario)teslaContent));
                content = script;
            }
            teslaContent = null;
            model.delete(TESLA_CONTENT_ENTRY);
            if (content != null) {
                this.storeEObjectIn(model.store(ECL_CONTENT_ENTRY), content);
            } else {
                model.delete(ECL_CONTENT_ENTRY);
            }
        }
    }

    private void storeEObjectIn(OutputStream store, Object content) {
        if (content instanceof String) {
            String text = (String)content;
            try {
                OutputStreamWriter wr = new OutputStreamWriter(store, "utf-8");
                wr.write(text);
                wr.close();
            }
            catch (IOException e) {
                RcpttPlugin.log(e);
            }
            FileUtil.safeClose((Closeable)store);
            return;
        }
        if (content instanceof Script) {
            String text = ((Script)content).getContent();
            try {
                OutputStreamWriter wr = new OutputStreamWriter(store, "utf-8");
                wr.write(text);
                wr.close();
            }
            catch (IOException e) {
                RcpttPlugin.log(e);
            }
            FileUtil.safeClose((Closeable)store);
            return;
        }
        if (content instanceof EObject) {
            XMIResourceImpl resource = new XMIResourceImpl();
            resource.getContents().add((Object)EcoreUtil.copy((EObject)((EObject)content)));
            try {
                resource.save(store, PersistenceManager.getOptions());
                FileUtil.safeClose((Closeable)store);
            }
            catch (IOException e) {
                RcpttPlugin.log(e);
            }
        }
    }

    public String loadDescription(Q7LazyResource q7LazyResource, EObject self) {
        InputStream stream;
        IPersistenceModel model = this.getModel((Resource)q7LazyResource);
        if (model != null && (stream = model.read(DESCRIPTION_ENTRY)) != null) {
            try {
                String content = new String(FileUtil.getStreamContent((InputStream)stream), "utf-8");
                if (content != null) {
                    return content;
                }
            }
            catch (IOException e) {
                RcpttPlugin.log(e);
            }
        }
        return null;
    }

    public EObject loadECLContent(Q7LazyResource q7LazyResource, EObject self) {
        InputStream stream;
        IPersistenceModel model = this.getModel((Resource)q7LazyResource);
        if (model != null && (stream = model.read(ECL_CONTENT_ENTRY)) != null) {
            try {
                String content = new String(FileUtil.getStreamContent((InputStream)stream), "utf-8");
                if (content != null) {
                    Script script = CoreFactory.eINSTANCE.createScript();
                    script.setContent(content);
                    return script;
                }
            }
            catch (IOException e) {
                RcpttPlugin.log(e);
            }
        }
        return null;
    }

    public EObject loadTeslaContent(Q7LazyResource q7LazyResource, EObject self) {
        IPersistenceModel model = this.getModel((Resource)q7LazyResource);
        if (model != null) {
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try (InputStream stream = model.read(TESLA_CONTENT_ENTRY);){
                    if (stream != null) {
                        XMIResourceImpl res = new XMIResourceImpl();
                        res.load(stream, PersistenceManager.getOptions());
                        if (res.getContents().size() == 1) {
                            return (EObject)res.getContents().get(0);
                        }
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                RcpttPlugin.log(String.format("Error reading content for %s", q7LazyResource.getURI()), e);
            }
        }
        return null;
    }

    public InputStream loadMetadata(IFile file, Resource resource) {
        IPersistenceModel model = this.getModel(this.detectFormatProxy(file), resource);
        return this.loadMetadata(model);
    }

    public InputStream loadMetadata(IPersistenceModel model) {
        return model.read(CONTENT_ENTRY);
    }

    private IPersistenceModelFactory detectFormatProxy(final IFile file) {
        return new IPersistenceModelFactory(){

            @Override
            public IPersistenceModel createModel(Resource resource) {
                return PersistenceManager.this.detectFormat(file, resource).createModel(resource);
            }

            @Override
            public boolean isSupported(InputStream stream) {
                return false;
            }

            @Override
            public boolean isSupported(File file2) {
                return false;
            }
        };
    }

    private IPersistenceModelFactory detectFormat(IFile file, Resource resource) {
        IPersistenceModelFactory[] factories = PersistenceFactoryManager.getInstance().getFactories();
        if (!file.exists() || !file.isSynchronized(2)) {
            return PersistenceFactoryManager.getInstance().getDefaultFactory();
        }
        IPersistenceModelFactory[] iPersistenceModelFactoryArray = factories;
        int n = factories.length;
        int n2 = 0;
        while (n2 < n) {
            IPersistenceModelFactory factory = iPersistenceModelFactoryArray[n2];
            InputStream contents = null;
            try {
                contents = file.getContents();
                IPath loc = file.getLocation();
                if (loc != null && loc.toFile().exists() && factory.isSupported(loc.toFile())) {
                    IPersistenceModelFactory iPersistenceModelFactory = factory;
                    return iPersistenceModelFactory;
                }
                if (factory.isSupported(contents)) {
                    IPersistenceModelFactory iPersistenceModelFactory = factory;
                    return iPersistenceModelFactory;
                }
            }
            catch (CoreException e) {
                RcpttPlugin.log(e);
            }
            finally {
                FileUtil.safeClose((Closeable)contents);
            }
            ++n2;
        }
        return PersistenceFactoryManager.getInstance().getDefaultFactory();
    }

    public IPersistenceModelFactory detectFormat(byte[] file) {
        IPersistenceModelFactory[] factories;
        IPersistenceModelFactory[] iPersistenceModelFactoryArray = factories = PersistenceFactoryManager.getInstance().getFactories();
        int n = factories.length;
        int n2 = 0;
        while (n2 < n) {
            IPersistenceModelFactory factory = iPersistenceModelFactoryArray[n2];
            if (factory.isSupported(new ByteArrayInputStream(file))) {
                return factory;
            }
            ++n2;
        }
        return PersistenceFactoryManager.getInstance().getDefaultFactory();
    }

    public static synchronized void shutdown() {
        if (persistenceManager != null) {
            persistenceManager.shutdownInternal();
            persistenceManager = null;
        }
    }

    private synchronized void shutdownInternal() {
        for (IPersistenceModel model : this.resourceOnlyModels.values()) {
            model.dispose();
        }
    }

    public void remove(Resource resource) {
        this.internalRemove(resource);
    }

    public IPersistenceModel getModel(byte[] content, Resource res) {
        IPersistenceModelFactory format = PersistenceManager.getInstance().detectFormat(content);
        if (format == null) {
            return null;
        }
        IPersistenceModel model = format.createModel(res);
        if (model instanceof BasePersistenceModel) {
            ((BasePersistenceModel)model).setInternalContent(content);
            this.replaceModel(res, model);
            return model;
        }
        return null;
    }

    public int cachedSize(Resource res) {
        IFile file = WorkspaceSynchronizer.getFile(res);
        if (!file.exists() || !file.isSynchronized(2)) {
            return 0;
        }
        File fs = file.getLocation().toFile();
        return (int)Math.min(fs.length(), Integer.MAX_VALUE);
    }
}

