/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.cheatsheets.composite.explorer;

import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.cheatsheets.CheatSheetPlugin;
import org.eclipse.ui.internal.cheatsheets.Messages;
import org.eclipse.ui.internal.cheatsheets.composite.explorer.ConfirmRestartDialog;
import org.eclipse.ui.internal.cheatsheets.composite.explorer.TreeLabelProvider;
import org.eclipse.ui.internal.cheatsheets.composite.model.AbstractTask;
import org.eclipse.ui.internal.cheatsheets.composite.model.CompositeCheatSheetModel;
import org.eclipse.ui.internal.cheatsheets.composite.model.TaskStateUtilities;
import org.eclipse.ui.internal.provisional.cheatsheets.ICompositeCheatSheetTask;

public class ResetTaskAction
extends Action {
    private final AbstractTask task;

    public ResetTaskAction(ICompositeCheatSheetTask task) {
        this.task = (AbstractTask)task;
        this.setText(Messages.COMPOSITE_MENU_RESET);
        IPath path = CheatSheetPlugin.ICONS_PATH.append("elcl16/").append("return_to_start.png");
        ImageDescriptor restartImage = CheatSheetPlugin.createImageDescriptor(CheatSheetPlugin.getPlugin().getBundle(), path);
        this.setImageDescriptor(restartImage);
    }

    public void run() {
        ICompositeCheatSheetTask[] restartTasks = TaskStateUtilities.getRestartTasks(this.task);
        if (restartTasks.length == 0) {
            return;
        }
        TreeLabelProvider labelProvider = new TreeLabelProvider();
        ConfirmRestartDialog dlg = new ConfirmRestartDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (AbstractTask[])restartTasks, labelProvider);
        dlg.open();
        labelProvider.dispose();
        if (dlg.getReturnCode() == 0) {
            CompositeCheatSheetModel model = (CompositeCheatSheetModel)restartTasks[0].getCompositeCheatSheet();
            model.resetTasks(restartTasks);
        }
    }
}

