/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.core.utils;

import java.util.Arrays;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.rcptt.tesla.core.ui.Color;
import org.eclipse.rcptt.tesla.core.ui.StyleRangeEntry;

public class WidgetModels {
    public static String getTextWithoutStyle(Iterable<StyleRangeEntry> entries, String text) {
        if (text == null) {
            return null;
        }
        char[] chars = text.toCharArray();
        boolean[] mask = new boolean[chars.length];
        Arrays.fill(mask, true);
        for (StyleRangeEntry entry : entries) {
            int start = entry.getStart();
            Arrays.fill(mask, start, start + entry.getLength(), false);
        }
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < chars.length) {
            if (mask[i]) {
                result.append(chars[i]);
            }
            ++i;
        }
        return result.toString();
    }

    public static String getStyledText(Iterable<StyleRangeEntry> entries, String text) {
        if (text == null) {
            return null;
        }
        char[] chars = text.toCharArray();
        boolean[] mask = new boolean[chars.length];
        Arrays.fill(mask, false);
        boolean isEmpty = true;
        for (StyleRangeEntry entry : entries) {
            isEmpty = false;
            int start = entry.getStart();
            Arrays.fill(mask, start, start + entry.getLength(), true);
        }
        StringBuilder styledResult = new StringBuilder();
        if (!isEmpty) {
            int i = 0;
            while (i < chars.length) {
                if (mask[i]) {
                    styledResult.append(chars[i]);
                }
                ++i;
            }
        }
        return styledResult.toString();
    }

    public static StyleDiff getDiff(int start, int length, Iterable<StyleRangeEntry> left, Iterable<StyleRangeEntry> right) {
        StyleWithoutPos[] leftStyles = WidgetModels.getStyleArray(start, length, left);
        StyleWithoutPos[] rightStyles = WidgetModels.getStyleArray(start, length, right);
        int i = 0;
        while (i < length) {
            StyleWithoutPos leftStyle = leftStyles[i];
            StyleWithoutPos rightStyle = rightStyles[i];
            if (leftStyle != null || rightStyle != null) {
                if (leftStyle == null && rightStyle != null || leftStyle != null && rightStyle == null) {
                    return new StyleDiff(i + start, leftStyle == null ? null : leftStyle.source, rightStyle == null ? null : rightStyle.source);
                }
                if (!leftStyle.equals(rightStyle)) {
                    return new StyleDiff(i + start, leftStyle.source, rightStyle.source);
                }
            }
            ++i;
        }
        return null;
    }

    private static StyleWithoutPos[] getStyleArray(int start, int length, Iterable<StyleRangeEntry> styles) {
        Object[] result = new StyleWithoutPos[length];
        for (StyleRangeEntry entry : styles) {
            int from = entry.getStart() - start;
            int to = entry.getStart() + entry.getLength() - start;
            if (to < 0 || from >= length) continue;
            from = Math.max(from, 0);
            to = Math.min(to, length);
            Arrays.fill(result, from, to, new StyleWithoutPos(entry));
        }
        return result;
    }

    public static class StyleDiff {
        public final int at;
        public final StyleRangeEntry expected;
        public final StyleRangeEntry actual;

        public StyleDiff(int at, StyleRangeEntry expected, StyleRangeEntry actual) {
            this.at = at;
            this.expected = expected;
            this.actual = actual;
        }
    }

    private static class StyleWithoutPos {
        public final Color backgroundColor;
        public final Color borderColor;
        public final String borderStyle;
        public final String font;
        public final String fontStyle;
        public final Color foregroundColor;
        public final String metrics;
        public final Integer rise;
        public final Boolean strikeout;
        public final String underline;
        public final Color underlineColor;
        public final StyleRangeEntry source;

        public StyleWithoutPos(StyleRangeEntry entry) {
            this.backgroundColor = entry.getBackgroundColor();
            this.borderColor = entry.getBorderColor();
            this.borderStyle = entry.getBorderStyle();
            this.font = entry.getFont();
            this.fontStyle = entry.getFontStyle();
            this.foregroundColor = entry.getForegroundColor();
            this.metrics = entry.getMetrics();
            this.rise = entry.getRise();
            this.strikeout = entry.getStrikeout();
            this.underline = entry.getUnderline();
            this.underlineColor = entry.getUnderlineColor();
            this.source = entry;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.backgroundColor == null ? 0 : this.backgroundColor.hashCode());
            result = 31 * result + (this.borderColor == null ? 0 : this.borderColor.hashCode());
            result = 31 * result + (this.borderStyle == null ? 0 : this.borderStyle.hashCode());
            result = 31 * result + (this.font == null ? 0 : this.font.hashCode());
            result = 31 * result + (this.fontStyle == null ? 0 : this.fontStyle.hashCode());
            result = 31 * result + (this.foregroundColor == null ? 0 : this.foregroundColor.hashCode());
            result = 31 * result + (this.metrics == null ? 0 : this.metrics.hashCode());
            result = 31 * result + (this.rise == null ? 0 : this.rise.hashCode());
            result = 31 * result + (this.strikeout == null ? 0 : this.strikeout.hashCode());
            result = 31 * result + (this.underline == null ? 0 : this.underline.hashCode());
            result = 31 * result + (this.underlineColor == null ? 0 : this.underlineColor.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            StyleWithoutPos other = (StyleWithoutPos)obj;
            if (this.backgroundColor == null ? other.backgroundColor != null : !EcoreUtil.equals((EObject)this.backgroundColor, (EObject)other.backgroundColor)) {
                return false;
            }
            if (this.borderColor == null ? other.borderColor != null : !EcoreUtil.equals((EObject)this.borderColor, (EObject)other.borderColor)) {
                return false;
            }
            if (this.borderStyle == null ? other.borderStyle != null : !this.borderStyle.equals(other.borderStyle)) {
                return false;
            }
            if (this.font == null ? other.font != null : !this.font.equals(other.font)) {
                return false;
            }
            if (this.fontStyle == null ? other.fontStyle != null : !this.fontStyle.equals(other.fontStyle)) {
                return false;
            }
            if (this.foregroundColor == null ? other.foregroundColor != null : !EcoreUtil.equals((EObject)this.foregroundColor, (EObject)other.foregroundColor)) {
                return false;
            }
            if (this.metrics == null ? other.metrics != null : !this.metrics.equals(other.metrics)) {
                return false;
            }
            if (this.rise == null ? other.rise != null : !this.rise.equals(other.rise)) {
                return false;
            }
            if (this.strikeout == null ? other.strikeout != null : !this.strikeout.equals(other.strikeout)) {
                return false;
            }
            if (this.underline == null ? other.underline != null : !this.underline.equals(other.underline)) {
                return false;
            }
            return !(this.underlineColor == null ? other.underlineColor != null : !EcoreUtil.equals((EObject)this.underlineColor, (EObject)other.underlineColor));
        }
    }
}

