/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ctx.filesystem.ui.actions;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.rcptt.filesystem.FSFile;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IStorageEditorInput;

public class FSFileEditorInput
implements IStorageEditorInput {
    private FSFile file;
    private String name;

    public FSFileEditorInput(FSFile file, String name) {
        this.file = file;
        this.name = name;
    }

    public boolean exists() {
        return true;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getName() {
        return new Path(this.name).lastSegment();
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        return this.name;
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.file == null ? 0 : this.file.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FSFileEditorInput other = (FSFileEditorInput)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.file == null ? other.file != null : !this.file.equals(other.file));
    }

    public IStorage getStorage() throws CoreException {
        return new IStorage(){

            public Object getAdapter(Class adapter) {
                return null;
            }

            public boolean isReadOnly() {
                return true;
            }

            public String getName() {
                return FSFileEditorInput.this.name;
            }

            public IPath getFullPath() {
                return new Path(FSFileEditorInput.this.name);
            }

            public InputStream getContents() throws CoreException {
                return new ByteArrayInputStream(FSFileEditorInput.this.file.getData());
            }
        };
    }
}

