/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.nls;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.core.plugin.IPluginAttribute;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginExtensionPoint;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.core.plugin.IPluginParent;
import org.eclipse.pde.core.plugin.ISharedExtensionsModel;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.ICoreConstants;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.WorkspaceModelManager;
import org.eclipse.pde.internal.core.ibundle.IBundle;
import org.eclipse.pde.internal.core.ibundle.IBundlePluginModelBase;
import org.eclipse.pde.internal.core.ibundle.IManifestHeader;
import org.eclipse.pde.internal.core.ischema.ISchema;
import org.eclipse.pde.internal.core.ischema.ISchemaAttribute;
import org.eclipse.pde.internal.core.ischema.ISchemaElement;
import org.eclipse.pde.internal.core.schema.SchemaRegistry;
import org.eclipse.pde.internal.core.text.IDocumentAttributeNode;
import org.eclipse.pde.internal.core.text.IDocumentElementNode;
import org.eclipse.pde.internal.core.text.plugin.PluginExtensionNode;
import org.eclipse.pde.internal.core.text.plugin.PluginExtensionPointNode;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.nls.ModelChangeTable;
import org.eclipse.pde.internal.ui.util.ModelModification;
import org.eclipse.pde.internal.ui.util.PDEModelUtility;

public class GetNonExternalizedStringsOperation
implements IRunnableWithProgress {
    private final ISelection fSelection;
    private ArrayList<Object> fSelectedModels;
    private ModelChangeTable fModelChangeTable;
    private boolean fCanceled;
    private final boolean fExternalizeSelectedPluginsOnly;

    public GetNonExternalizedStringsOperation(ISelection selection, boolean externalizeSelectedPluginsOnly) {
        this.fSelection = selection;
        this.fExternalizeSelectedPluginsOnly = externalizeSelectedPluginsOnly;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        block8: {
            if (!(this.fSelection instanceof IStructuredSelection)) break block8;
            Object[] elems = ((IStructuredSelection)this.fSelection).toArray();
            this.fSelectedModels = new ArrayList(elems.length);
            int i = 0;
            while (i < elems.length) {
                if (elems[i] instanceof IFile) {
                    elems[i] = ((IFile)elems[i]).getProject();
                }
                if (elems[i] instanceof IProject && WorkspaceModelManager.isPluginProject((IProject)((IProject)elems[i])) && !WorkspaceModelManager.isBinaryProject((IProject)((IProject)elems[i]))) {
                    this.fSelectedModels.add(elems[i]);
                }
                ++i;
            }
            this.fModelChangeTable = new ModelChangeTable();
            if (this.fExternalizeSelectedPluginsOnly) {
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)PDEUIMessages.GetNonExternalizedStringsOperation_taskMessage, (int)this.fSelectedModels.size());
                Iterator<Object> iterator = this.fSelectedModels.iterator();
                while (iterator.hasNext() && !this.fCanceled) {
                    IProject project = (IProject)iterator.next();
                    if (WorkspaceModelManager.isBinaryProject((IProject)project)) continue;
                    this.getUnExternalizedStrings(project, (IProgressMonitor)subMonitor.split(1));
                }
            } else {
                IPluginModelBase[] pluginModels = PluginRegistry.getWorkspaceModels();
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)PDEUIMessages.GetNonExternalizedStringsOperation_taskMessage, (int)pluginModels.length);
                int i2 = 0;
                while (i2 < pluginModels.length && !this.fCanceled) {
                    IProject project = pluginModels[i2].getUnderlyingResource().getProject();
                    if (!WorkspaceModelManager.isBinaryProject((IProject)project)) {
                        this.getUnExternalizedStrings(project, (IProgressMonitor)subMonitor.split(1));
                    }
                    ++i2;
                }
            }
        }
    }

    private void getUnExternalizedStrings(IProject project, IProgressMonitor monitor) {
        PDEModelUtility.modifyModel(new ModelModification(project){

            @Override
            protected void modifyModel(IBaseModel model, IProgressMonitor monitor) throws CoreException {
                if (model instanceof IBundlePluginModelBase) {
                    GetNonExternalizedStringsOperation.this.inspectManifest((IBundlePluginModelBase)model, monitor);
                }
                if (monitor.isCanceled()) {
                    GetNonExternalizedStringsOperation.this.fCanceled = true;
                    return;
                }
                if (model instanceof IPluginModelBase) {
                    GetNonExternalizedStringsOperation.this.inspectXML((IPluginModelBase)model, monitor);
                }
                if (monitor.isCanceled()) {
                    GetNonExternalizedStringsOperation.this.fCanceled = true;
                    return;
                }
            }
        }, monitor);
    }

    private void inspectManifest(IBundlePluginModelBase model, IProgressMonitor monitor) {
        IFile manifestFile = (IFile)model.getBundleModel().getUnderlyingResource();
        IBundle bundle = model.getBundleModel().getBundle();
        String[] stringArray = ICoreConstants.TRANSLATABLE_HEADERS;
        int n = ICoreConstants.TRANSLATABLE_HEADERS.length;
        int n2 = 0;
        while (n2 < n) {
            String translatableHeader = stringArray[n2];
            IManifestHeader header = bundle.getManifestHeader(translatableHeader);
            if (header != null && this.isNotTranslated(header.getValue())) {
                this.fModelChangeTable.addToChangeTable((IPluginModelBase)model, manifestFile, header, this.selected(manifestFile));
            }
            ++n2;
        }
    }

    private void inspectXML(IPluginModelBase model, IProgressMonitor monitor) {
        IPluginExtensionPoint[] extensionPoints;
        IPluginExtension[] extensions;
        IFile file;
        if (model instanceof IBundlePluginModelBase) {
            ISharedExtensionsModel extModel = ((IBundlePluginModelBase)model).getExtensionsModel();
            if (extModel == null) {
                return;
            }
            file = (IFile)extModel.getUnderlyingResource();
        } else {
            file = (IFile)model.getUnderlyingResource();
        }
        IPluginBase base = model.getPluginBase();
        if (base instanceof IDocumentElementNode) {
            IDocumentAttributeNode attr = ((IDocumentElementNode)base).getDocumentAttribute("name");
            if (attr != null && this.isNotTranslated(attr.getAttributeValue())) {
                this.fModelChangeTable.addToChangeTable(model, file, attr, this.selected(file));
            }
            if ((attr = ((IDocumentElementNode)base).getDocumentAttribute("provider-name")) != null && this.isNotTranslated(attr.getAttributeValue())) {
                this.fModelChangeTable.addToChangeTable(model, file, attr, this.selected(file));
            }
        }
        SchemaRegistry registry = PDECore.getDefault().getSchemaRegistry();
        IPluginExtension[] iPluginExtensionArray = extensions = model.getPluginBase().getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginExtension extension = iPluginExtensionArray[n2];
            ISchema schema = registry.getSchema(extension.getPoint());
            if (schema != null) {
                this.inspectExtension(schema, (IPluginParent)extension, model, file);
            }
            ++n2;
        }
        IPluginExtensionPoint[] iPluginExtensionPointArray = extensionPoints = model.getPluginBase().getExtensionPoints();
        int n3 = extensionPoints.length;
        n = 0;
        while (n < n3) {
            IPluginExtensionPoint extensionPoint = iPluginExtensionPointArray[n];
            this.inspectExtensionPoint(extensionPoint, model, file);
            ++n;
        }
    }

    private void inspectExtension(ISchema schema, IPluginParent parent, IPluginModelBase memModel, IFile file) {
        IPluginObject[] children;
        int n;
        if (parent instanceof PluginExtensionNode) {
            PluginExtensionNode parentNode = (PluginExtensionNode)parent;
            IDocumentAttributeNode[] attributes = parentNode.getNodeAttributes();
            ISchemaElement schemaElement = schema.findElement(parentNode.getXMLTagName());
            if (schemaElement != null) {
                IDocumentAttributeNode[] iDocumentAttributeNodeArray = attributes;
                int n2 = attributes.length;
                n = 0;
                while (n < n2) {
                    IDocumentAttributeNode attribute = iDocumentAttributeNodeArray[n];
                    IPluginAttribute attr = (IPluginAttribute)attribute;
                    ISchemaAttribute attInfo = schemaElement.getAttribute(attr.getName());
                    if (attInfo != null && attInfo.isTranslatable() && this.isNotTranslated(attr.getValue())) {
                        this.fModelChangeTable.addToChangeTable(memModel, file, attr, this.selected(file));
                    }
                    ++n;
                }
            }
        }
        IPluginObject[] iPluginObjectArray = children = parent.getChildren();
        n = children.length;
        int n3 = 0;
        while (n3 < n) {
            IPluginObject element = iPluginObjectArray[n3];
            IPluginElement child = (IPluginElement)element;
            ISchemaElement schemaElement = schema.findElement(child.getName());
            if (schemaElement != null) {
                IPluginAttribute[] attributes;
                if (schemaElement.hasTranslatableContent() && this.isNotTranslated(child.getText())) {
                    this.fModelChangeTable.addToChangeTable(memModel, file, child, this.selected(file));
                }
                IPluginAttribute[] iPluginAttributeArray = attributes = child.getAttributes();
                int n4 = attributes.length;
                int n5 = 0;
                while (n5 < n4) {
                    IPluginAttribute attr = iPluginAttributeArray[n5];
                    ISchemaAttribute attInfo = schemaElement.getAttribute(attr.getName());
                    if (attInfo != null && attInfo.isTranslatable() && this.isNotTranslated(attr.getValue())) {
                        this.fModelChangeTable.addToChangeTable(memModel, file, attr, this.selected(file));
                    }
                    ++n5;
                }
            }
            this.inspectExtension(schema, (IPluginParent)child, memModel, file);
            ++n3;
        }
    }

    private void inspectExtensionPoint(IPluginExtensionPoint extensionPoint, IPluginModelBase memModel, IFile file) {
        if (extensionPoint instanceof PluginExtensionPointNode && this.isNotTranslated(extensionPoint.getName())) {
            this.fModelChangeTable.addToChangeTable(memModel, file, ((PluginExtensionPointNode)extensionPoint).getNodeAttributesMap().get("name"), this.selected(file));
        }
    }

    private boolean isNotTranslated(String value) {
        if (value == null) {
            return false;
        }
        return value.length() <= 0 || value.charAt(0) != '%';
    }

    protected ModelChangeTable getChangeTable() {
        return this.fModelChangeTable;
    }

    public boolean wasCanceled() {
        return this.fCanceled;
    }

    private boolean selected(IFile file) {
        return this.fSelectedModels.contains(file.getProject());
    }
}

