/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.externaltools.internal.model;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.externaltools.internal.model.ExternalToolsModelMessages;
import org.eclipse.ui.externaltools.internal.model.ExternalToolsPlugin;

public class ImageDescriptorRegistry {
    private final Map<ImageDescriptor, Image> fRegistry = Collections.synchronizedMap(new HashMap(10));
    private final Display fDisplay;

    public ImageDescriptorRegistry() {
        this(ExternalToolsPlugin.getStandardDisplay());
    }

    public ImageDescriptorRegistry(Display display) {
        this.fDisplay = display;
        Assert.isNotNull((Object)this.fDisplay);
        this.hookDisplay();
    }

    public Image get(ImageDescriptor descriptor) {
        Image result = this.fRegistry.get(descriptor != null ? descriptor : ImageDescriptor.getMissingImageDescriptor());
        if (result != null) {
            return result;
        }
        Assert.isTrue((this.fDisplay == ExternalToolsPlugin.getStandardDisplay() ? 1 : 0) != 0, (String)ExternalToolsModelMessages.ImageDescriptorRegistry_Allocating_image_for_wrong_display_1);
        Image image = result = descriptor != null ? descriptor.createImage() : ImageDescriptor.getMissingImageDescriptor().createImage();
        if (result != null) {
            this.fRegistry.put(descriptor, result);
        }
        return result;
    }

    public void dispose() {
        for (Image image : this.fRegistry.values()) {
            image.dispose();
        }
        this.fRegistry.clear();
    }

    private void hookDisplay() {
        this.fDisplay.asyncExec(() -> this.fDisplay.disposeExec(this::dispose));
    }
}

