/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.logging;

import java.io.File;
import java.io.IOException;
import java.util.logging.FileHandler;
import org.eclipse.rcptt.logging.BaseFileQ7Monitor;
import org.eclipse.rcptt.logging.IQ7Monitor;

public class FileQ7Monitor
extends BaseFileQ7Monitor
implements IQ7Monitor {
    private File file;

    public FileQ7Monitor(File file) {
        this.file = file;
        this.reinit();
    }

    @Override
    protected FileHandler getFileHandle() throws IOException {
        return new FileHandler(String.valueOf(this.file.getAbsolutePath()) + "_%g.log", this.getLogFileSize(), this.getLogFileCount(), true);
    }

    @Override
    protected String getFailMessage() {
        return "Failed to write to log:" + this.file.getAbsolutePath();
    }

    @Override
    public File getRootFolder() {
        return this.file;
    }

    @Override
    public String getId() {
        return this.file.getName();
    }

    @Override
    public String getPrefix() {
        return null;
    }

    @Override
    public void putChild(IQ7Monitor result) {
    }

    @Override
    public String getFile() {
        return this.file.getAbsolutePath();
    }
}

