/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.launching;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.junit.launcher.ITestKind;
import org.eclipse.jdt.internal.junit.launcher.JUnitLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMRunner;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.plugin.IFragment;
import org.eclipse.pde.core.plugin.IFragmentModel;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.core.plugin.TargetPlatform;
import org.eclipse.pde.internal.core.ClasspathHelper;
import org.eclipse.pde.internal.core.DependencyManager;
import org.eclipse.pde.internal.core.ICoreConstants;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.TargetPlatformHelper;
import org.eclipse.pde.internal.core.bnd.PdeProjectAnalyzer;
import org.eclipse.pde.internal.core.util.CoreUtility;
import org.eclipse.pde.internal.core.util.VersionUtil;
import org.eclipse.pde.internal.launching.PDELaunchingPlugin;
import org.eclipse.pde.internal.launching.PDEMessages;
import org.eclipse.pde.internal.launching.launcher.BundleLauncherHelper;
import org.eclipse.pde.internal.launching.launcher.EclipsePluginValidationOperation;
import org.eclipse.pde.internal.launching.launcher.LaunchArgumentsHelper;
import org.eclipse.pde.internal.launching.launcher.LaunchConfigurationHelper;
import org.eclipse.pde.internal.launching.launcher.LaunchPluginValidator;
import org.eclipse.pde.internal.launching.launcher.LauncherUtils;
import org.eclipse.pde.internal.launching.launcher.RequirementHelper;
import org.eclipse.pde.internal.launching.launcher.VMHelper;
import org.eclipse.pde.launching.ExtraBundleModel;

public class JUnitLaunchConfigurationDelegate
extends org.eclipse.jdt.junit.launcher.JUnitLaunchConfigurationDelegate {
    private String fWorkspaceLocation;
    protected File fConfigDir = null;
    private Map<String, List<IPluginModelBase>> fAllBundles;
    private Map<IPluginModelBase, String> fModels;
    private String launchMode;
    private static final String PDE_JUNIT_SHOW_COMMAND = "pde.junit.showcommandline";

    static {
        RequirementHelper.registerLaunchTypeRequirements("org.eclipse.pde.ui.JunitLaunchConfig", lc -> {
            String application = lc.getAttribute("testApplication", null);
            if (application == null) {
                application = lc.getAttribute("application", null);
            }
            if (application == null) {
                application = TargetPlatform.getDefaultApplication();
            }
            if (!"org.eclipse.pde.junit.runtime.coretestapplication".equals(application)) {
                List<String> applicationRequirements = RequirementHelper.getApplicationRequirements(application);
                ArrayList<String> list = new ArrayList<String>(applicationRequirements);
                list.add("org.eclipse.osgi");
                return list;
            }
            return List.of("org.eclipse.osgi");
        });
    }

    public IVMRunner getVMRunner(ILaunchConfiguration configuration, String mode) throws CoreException {
        IVMInstall launcher = VMHelper.createLauncher(configuration, this.fModels.keySet());
        return launcher.getVMRunner(mode);
    }

    public String verifyMainTypeName(ILaunchConfiguration configuration) throws CoreException {
        if (TargetPlatformHelper.getTargetVersion() >= 3.3) {
            return "org.eclipse.equinox.launcher.Main";
        }
        return "org.eclipse.core.launcher.Main";
    }

    private IPluginBase getTestPlugin(ILaunchConfiguration configuration) throws CoreException {
        IJavaProject javaProject = this.getJavaProject(configuration);
        IPluginModelBase model = PluginRegistry.findModel((IProject)javaProject.getProject());
        if (model == null) {
            this.abort(NLS.bind((String)PDEMessages.JUnitLaunchConfiguration_error_notaplugin, (Object)javaProject.getProject().getName()), null, 0);
        }
        if (model instanceof IFragmentModel) {
            IFragment fragment = ((IFragmentModel)model).getFragment();
            IPluginBase hostModel = this.getFragmentHostModel(fragment.getPluginId(), fragment.getPluginVersion(), fragment.getRule());
            if (hostModel == null) {
                this.abort(NLS.bind((String)PDEMessages.JUnitLaunchConfiguration_error_missingPlugin, (Object)fragment.getPluginId()), null, 0);
            }
            model = hostModel.getPluginModel();
        }
        return model.getPluginBase();
    }

    private IPluginBase getFragmentHostModel(String hostId, String hostVersion, int hostVersionMatchRule) {
        List hosts = this.fAllBundles.getOrDefault(hostId, Collections.emptyList());
        Stream<IPluginBase> hostPlugins = hosts.stream().map(IPluginModelBase::getPluginBase);
        return hostPlugins.filter(h -> VersionUtil.compare((String)h.getVersion(), (String)hostVersion, (int)hostVersionMatchRule)).max(Comparator.comparing(IPluginBase::getVersion)).orElse(null);
    }

    protected void abort(String message, Throwable exception, int code) throws CoreException {
        throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.launching", code, message, exception));
    }

    public String getModuleCLIOptions(ILaunchConfiguration configuration) throws CoreException {
        return "";
    }

    protected void collectExecutionArguments(ILaunchConfiguration configuration, List<String> vmArguments, List<String> programArgs) throws CoreException {
        String attrRunWithJunitPlatformAnnotation;
        String[] userArgs;
        super.collectExecutionArguments(configuration, vmArguments, programArgs);
        programArgs.add("-application");
        String application = this.getApplication(configuration);
        programArgs.add(application);
        if (configuration.getAttribute("useProduct", false)) {
            programArgs.add("-product");
            programArgs.add(configuration.getAttribute("product", ""));
        } else {
            String defaultApplication = TargetPlatform.getDefaultApplication();
            if ("org.eclipse.pde.junit.runtime.coretestapplication".equals(application)) {
                defaultApplication = null;
            } else if ("org.eclipse.pde.junit.runtime.nonuithreadtestapplication".equals(application)) {
                defaultApplication = "org.eclipse.pde.junit.runtime.coretestapplication";
            }
            String testApplication = configuration.getAttribute("testApplication", defaultApplication);
            if (testApplication != null) {
                programArgs.add("-testApplication");
                programArgs.add(testApplication);
            }
        }
        if (this.fWorkspaceLocation == null) {
            this.fWorkspaceLocation = LaunchArgumentsHelper.getWorkspaceLocation(configuration);
        }
        if (this.fWorkspaceLocation.length() > 0) {
            programArgs.add("-data");
            programArgs.add(this.fWorkspaceLocation);
        }
        String productID = LaunchConfigurationHelper.getProductID(configuration);
        IPluginBase testPlugin = this.getTestPlugin(configuration);
        IJavaProject javaProject = this.getJavaProject(configuration);
        if (this.isJUnitContainerProject(javaProject)) {
            try {
                Throwable throwable = null;
                Object var9_11 = null;
                try (PdeProjectAnalyzer analyzer = new PdeProjectAnalyzer(javaProject.getProject(), true);){
                    analyzer.setImportPackage("*");
                    String bsn = testPlugin.getId() + "-additional-test-probe-imports";
                    analyzer.setBundleSymbolicName(bsn);
                    analyzer.set("Fragment-Host", testPlugin.getId());
                    analyzer.set("Bundle-ActivationPolicy", "lazy");
                    Manifest calcManifest = analyzer.calcManifest();
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    calcManifest.write(out);
                    Path tmpPath = Path.of(this.fWorkspaceLocation, testPlugin.getId() + "-fragment.jar");
                    Files.createDirectories(tmpPath.getParent(), new FileAttribute[0]);
                    Throwable throwable2 = null;
                    Object var16_22 = null;
                    try {
                        JarOutputStream stream = new JarOutputStream(Files.newOutputStream(tmpPath, new OpenOption[0]), calcManifest);
                        if (stream != null) {
                            stream.close();
                        }
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                    tmpPath.toFile().deleteOnExit();
                    Map manifest = ManifestElement.parseBundleManifest((InputStream)new ByteArrayInputStream(out.toByteArray()), null);
                    ExtraBundleModel extraBundleModel = new ExtraBundleModel(tmpPath, manifest);
                    this.fAllBundles.put(bsn, List.of(extraBundleModel));
                    BundleLauncherHelper.addDefaultStartingBundle(this.fModels, (IPluginModelBase)extraBundleModel);
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                ILog.get().error("Can't compute additional imports for test project!", (Throwable)e);
            }
        }
        LaunchConfigurationHelper.createConfigIniFile(configuration, productID, this.fAllBundles, null, this.fModels, this.getConfigurationDirectory(configuration));
        TargetPlatformHelper.checkPluginPropertiesConsistency(this.fAllBundles, (File)this.getConfigurationDirectory(configuration));
        programArgs.add("-configuration");
        programArgs.add(IPath.fromOSString((String)this.getConfigurationDirectory(configuration).getPath()).addTrailingSeparator().toPath().toUri().toString());
        programArgs.add("-dev");
        Properties devProperties = ClasspathHelper.getDevEntriesProperties(this.fAllBundles, (boolean)true);
        if (javaProject != null) {
            Arrays.stream(javaProject.getRawClasspath()).filter(entry -> entry.getEntryKind() == 3).filter(IClasspathEntry::isTest).filter(entry -> entry.getOutputLocation() != null).forEach(entry -> {
                IPath relativePath = entry.getOutputLocation().removeFirstSegments(1).makeRelative();
                ClasspathHelper.addDevClasspath((IPluginBase)testPlugin, (Properties)devProperties, (String)relativePath.toString(), (boolean)true);
            });
        }
        programArgs.add(ClasspathHelper.writeDevEntries((String)(this.getConfigurationDirectory(configuration).toString() + "/dev.properties"), (Properties)devProperties).toUri().toString());
        if (configuration.getAttribute("tracing", false) && !"[NONE]".equals(configuration.getAttribute("checked", null))) {
            programArgs.add("-debug");
            Path path = this.getConfigurationDirectory(configuration).toPath().resolve(".options");
            programArgs.add(LaunchArgumentsHelper.getTracingFileArgument(configuration, path));
        }
        String[] stringArray = userArgs = LaunchArgumentsHelper.getUserProgramArgumentArray(configuration);
        int calcManifest = userArgs.length;
        int bsn = 0;
        while (bsn < calcManifest) {
            String userArg = stringArray[bsn];
            if (!userArg.equals("-debug") || !programArgs.contains("-debug")) {
                programArgs.add(userArg);
            }
            ++bsn;
        }
        if (!configuration.getAttribute("append.args", false)) {
            if (!programArgs.contains("-os")) {
                programArgs.add("-os");
                programArgs.add(TargetPlatform.getOS());
            }
            if (!programArgs.contains("-ws")) {
                programArgs.add("-ws");
                programArgs.add(TargetPlatform.getWS());
            }
            if (!programArgs.contains("-arch")) {
                programArgs.add("-arch");
                programArgs.add(TargetPlatform.getOSArch());
            }
        }
        programArgs.add("-testpluginname");
        programArgs.add(testPlugin.getId());
        IVMInstall launcher = VMHelper.createLauncher(configuration, this.fModels.keySet());
        boolean isModular = JavaRuntime.isModularJava((IVMInstall)launcher);
        if (isModular) {
            VMHelper.addNewArgument(vmArguments, "--add-modules", "ALL-SYSTEM");
        }
        if (configuration.getAttribute(attrRunWithJunitPlatformAnnotation = "org.eclipse.jdt.junit.IS_RUN_WITH_JUNIT_PLATFORM", false)) {
            programArgs.add("-runasjunit5");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isJUnitContainerProject(IJavaProject javaProject) {
        if (javaProject == null) return false;
        try {
            IClasspathEntry[] classpath;
            IClasspathEntry[] iClasspathEntryArray = classpath = javaProject.getRawClasspath();
            int n = classpath.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                IClasspathEntry cp = iClasspathEntryArray[n2];
                if (cp.getEntryKind() == 5) {
                    if (ICoreConstants.JUNIT5_CONTAINER_PATH.equals((Object)cp.getPath())) {
                        return true;
                    }
                    if (ICoreConstants.JUNIT4_CONTAINER_PATH.equals((Object)cp.getPath())) {
                        return true;
                    }
                }
                ++n2;
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        return false;
    }

    public String showCommandLine(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        launch.setAttribute(PDE_JUNIT_SHOW_COMMAND, "true");
        return super.showCommandLine(configuration, mode, launch, monitor);
    }

    protected String getApplication(ILaunchConfiguration configuration) {
        String application = null;
        boolean shouldRunInUIThread = true;
        try {
            shouldRunInUIThread = configuration.getAttribute("run_in_ui_thread", true);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        if (!shouldRunInUIThread) {
            return "org.eclipse.pde.junit.runtime.nonuithreadtestapplication";
        }
        try {
            application = configuration.getAttribute("application", null);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        if (application == null) {
            application = "org.eclipse.pde.junit.runtime.uitestapplication";
        }
        return application;
    }

    private IPluginModelBase findRequiredPluginInTargetOrHost(String id) throws CoreException {
        IPluginModelBase model = PluginRegistry.findModel((String)id);
        if (model == null || !model.getBundleDescription().isResolved()) {
            model = PDECore.getDefault().findPluginInHost(id);
        }
        if (model == null) {
            this.abort(NLS.bind((String)PDEMessages.JUnitLaunchConfiguration_error_missingPlugin, (Object)id), null, 0);
        }
        return model;
    }

    public String getProgramArguments(ILaunchConfiguration configuration) throws CoreException {
        return LaunchArgumentsHelper.getUserProgramArguments(configuration);
    }

    public String getVMArguments(ILaunchConfiguration configuration) throws CoreException {
        String vmArgs = LaunchArgumentsHelper.getUserVMArguments(configuration);
        vmArgs = this.concatArg(vmArgs, "-Declipse.pde.launch=true");
        if (this.fAllBundles.containsKey("org.eclipse.equinox.p2.core") && !vmArgs.contains("-Declipse.p2.data.area=")) {
            vmArgs = this.concatArg(vmArgs, "-Declipse.p2.data.area=@config.dir" + File.separator + "p2");
        }
        return vmArgs;
    }

    private String concatArg(String vmArgs, String arg) {
        if (vmArgs.length() > 0 && !vmArgs.endsWith(" ")) {
            vmArgs = vmArgs.concat(" ");
        }
        return vmArgs.concat(arg);
    }

    public String[] getEnvironment(ILaunchConfiguration configuration) throws CoreException {
        return DebugPlugin.getDefault().getLaunchManager().getEnvironment(configuration);
    }

    @Deprecated
    public String[] getClasspath(ILaunchConfiguration configuration) throws CoreException {
        String[] classpath = LaunchArgumentsHelper.constructClasspath(configuration);
        if (classpath == null) {
            this.abort(PDEMessages.WorkbenchLauncherConfigurationDelegate_noStartup, null, 0);
        }
        return classpath;
    }

    public String[][] getClasspathAndModulepath(ILaunchConfiguration configuration) throws CoreException {
        String[] classpath = LaunchArgumentsHelper.constructClasspath(configuration);
        if (classpath == null) {
            this.abort(PDEMessages.WorkbenchLauncherConfigurationDelegate_noStartup, null, 0);
        }
        String[][] cpmp = super.getClasspathAndModulepath(configuration);
        cpmp[0] = classpath;
        return cpmp;
    }

    public File getWorkingDirectory(ILaunchConfiguration configuration) throws CoreException {
        return LaunchArgumentsHelper.getWorkingDirectory(configuration);
    }

    public Map<String, Object> getVMSpecificAttributesMap(ILaunchConfiguration configuration) throws CoreException {
        return LaunchArgumentsHelper.getVMSpecificAttributesMap(configuration, this.fModels.keySet());
    }

    protected void setDefaultSourceLocator(ILaunch launch, ILaunchConfiguration configuration) throws CoreException {
        ILaunchConfigurationWorkingCopy wc = null;
        wc = configuration.isWorkingCopy() ? (ILaunchConfigurationWorkingCopy)configuration : configuration.getWorkingCopy();
        String id = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_SOURCE_PATH_PROVIDER, null);
        if (!"org.eclipse.pde.ui.workbenchClasspathProvider".equals(id)) {
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_SOURCE_PATH_PROVIDER, "org.eclipse.pde.ui.workbenchClasspathProvider");
            wc.doSave();
        }
        this.manageLaunch(launch);
    }

    protected File getConfigurationDirectory(ILaunchConfiguration configuration) {
        if (this.fConfigDir == null) {
            this.fConfigDir = LaunchConfigurationHelper.getConfigurationArea(configuration);
        }
        return this.fConfigDir;
    }

    protected IProject[] getBuildOrder(ILaunchConfiguration configuration, String mode) throws CoreException {
        return this.computeBuildOrder(LaunchPluginValidator.getAffectedProjects(configuration));
    }

    protected IProject[] getProjectsForProblemSearch(ILaunchConfiguration configuration, String mode) throws CoreException {
        return LaunchPluginValidator.getAffectedProjects(configuration);
    }

    protected void manageLaunch(ILaunch launch) {
        PDELaunchingPlugin.getDefault().getLaunchListener().manage(launch);
    }

    protected void preLaunchCheck(ILaunchConfiguration configuration, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        boolean autoValidate;
        this.fWorkspaceLocation = null;
        this.fConfigDir = null;
        this.fModels = BundleLauncherHelper.getMergedBundleMap(configuration, false);
        this.fAllBundles = this.fModels.keySet().stream().collect(Collectors.groupingBy(m -> m.getPluginBase().getId(), LinkedHashMap::new, Collectors.toCollection(ArrayList::new)));
        this.launchMode = launch.getLaunchMode();
        this.addRequiredJunitRuntimePlugins(configuration);
        String attribute = launch.getAttribute(PDE_JUNIT_SHOW_COMMAND);
        boolean isShowCommand = false;
        if (attribute != null) {
            isShowCommand = attribute.equals("true");
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)((autoValidate = configuration.getAttribute("automaticValidate", false)) ? 3 : 4));
        if (!isShowCommand) {
            if (autoValidate) {
                this.validatePluginDependencies(configuration, (IProgressMonitor)subMonitor.split(1));
            }
            this.validateProjectDependencies(configuration, (IProgressMonitor)subMonitor.split(1));
            this.clear(configuration, (IProgressMonitor)subMonitor.split(1));
        }
        launch.setAttribute(PDE_JUNIT_SHOW_COMMAND, "false");
        launch.setAttribute("configLocation", this.getConfigurationDirectory(configuration).toString());
        this.synchronizeManifests(configuration, (IProgressMonitor)subMonitor.split(1));
    }

    private void addRequiredJunitRuntimePlugins(ILaunchConfiguration configuration) throws CoreException {
        LinkedHashSet<String> requiredPlugins = new LinkedHashSet<String>(JUnitLaunchConfigurationDelegate.getRequiredJunitRuntimePlugins(configuration));
        if (this.fAllBundles.containsKey("junit-platform-runner") || this.fAllBundles.containsKey("org.junit.platform.runner")) {
            requiredPlugins.add("junit-platform-launcher");
            requiredPlugins.add("junit-jupiter-engine");
        }
        HashSet<BundleDescription> addedRequirements = new HashSet<BundleDescription>();
        this.addAbsentRequirements(requiredPlugins, addedRequirements);
        Set requirementsOfRequirements = DependencyManager.findRequirementsClosure(addedRequirements, (DependencyManager.Options[])new DependencyManager.Options[0]);
        Set<String> rorIds = requirementsOfRequirements.stream().map(BundleDescription::getSymbolicName).collect(Collectors.toSet());
        this.addAbsentRequirements(rorIds, null);
    }

    private void addAbsentRequirements(Collection<String> requirements, Set<BundleDescription> addedRequirements) throws CoreException {
        for (String id : requirements) {
            List models = this.fAllBundles.computeIfAbsent(id, k -> new ArrayList());
            if (!models.stream().noneMatch(m -> m.getBundleDescription().isResolved())) continue;
            IPluginModelBase model = this.findRequiredPluginInTargetOrHost(id);
            models.add(model);
            BundleLauncherHelper.addDefaultStartingBundle(this.fModels, model);
            if (addedRequirements == null) continue;
            addedRequirements.add(model.getBundleDescription());
        }
    }

    public static Collection<String> getRequiredJunitRuntimePlugins(ILaunchConfiguration configuration) {
        ITestKind testKind = JUnitLaunchConfigurationConstants.getTestRunnerKind((ILaunchConfiguration)configuration);
        if (testKind.isNull()) {
            return Collections.emptyList();
        }
        ArrayList<String> plugins = new ArrayList<String>();
        plugins.add("org.eclipse.pde.junit.runtime");
        if ("org.eclipse.jdt.junit.loader.junit4".equals(testKind.getId())) {
            plugins.add("org.eclipse.jdt.junit4.runtime");
        } else if ("org.eclipse.jdt.junit.loader.junit5".equals(testKind.getId())) {
            plugins.add("org.eclipse.jdt.junit5.runtime");
        }
        return plugins;
    }

    protected void synchronizeManifests(ILaunchConfiguration configuration, IProgressMonitor monitor) {
        LaunchConfigurationHelper.synchronizeManifests(configuration, this.getConfigurationDirectory(configuration));
        monitor.done();
    }

    protected void clear(ILaunchConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        if (this.fWorkspaceLocation == null) {
            this.fWorkspaceLocation = LaunchArgumentsHelper.getWorkspaceLocation(configuration);
        }
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)50);
        LauncherUtils.clearWorkspace(configuration, this.fWorkspaceLocation, this.launchMode, (IProgressMonitor)subMon.split(25));
        subMon.setWorkRemaining(25);
        if (configuration.getAttribute("clearConfig", false)) {
            CoreUtility.deleteContent((File)this.getConfigurationDirectory(configuration), (IProgressMonitor)subMon.split(25));
        }
        subMon.done();
    }

    protected void validateProjectDependencies(ILaunchConfiguration configuration, IProgressMonitor monitor) {
        LauncherUtils.validateProjectDependencies(configuration, monitor);
    }

    protected void validatePluginDependencies(ILaunchConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        EclipsePluginValidationOperation op = new EclipsePluginValidationOperation(configuration, this.fModels.keySet(), this.launchMode);
        LaunchPluginValidator.runValidationOperation(op, monitor);
    }
}

