/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.accessibility;

import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.internal.cocoa.NSMutableArray;
import org.eclipse.swt.internal.cocoa.id;

class Relation {
    Accessible accessible;
    Accessible[] targets;
    int type;

    Relation(Accessible accessible, int type) {
        this.accessible = accessible;
        this.type = type;
        this.targets = new Accessible[0];
    }

    void addTarget(Accessible target) {
        if (this.containsTarget(target)) {
            return;
        }
        Accessible[] newTargets = new Accessible[this.targets.length + 1];
        System.arraycopy(this.targets, 0, newTargets, 0, this.targets.length);
        newTargets[this.targets.length] = target;
        this.targets = newTargets;
    }

    boolean containsTarget(Accessible target) {
        int i = 0;
        while (i < this.targets.length) {
            if (this.targets[i] == target) {
                return true;
            }
            ++i;
        }
        return false;
    }

    void removeTarget(Accessible target) {
        if (!this.containsTarget(target)) {
            return;
        }
        Accessible[] newTargets = new Accessible[this.targets.length - 1];
        int j = 0;
        int i = 0;
        while (i < this.targets.length) {
            if (this.targets[i] != target) {
                newTargets[j++] = this.targets[i];
            }
            ++i;
        }
        this.targets = newTargets;
    }

    id getTitleUIElement() {
        id result = null;
        int i = 0;
        while (i < this.targets.length) {
            Accessible target = this.targets[i];
            result = target.accessibleHandle(target);
            ++i;
        }
        return result;
    }

    id getServesAsTitleForUIElements() {
        NSMutableArray result = NSMutableArray.arrayWithCapacity(this.targets.length);
        int i = 0;
        while (i < this.targets.length) {
            Accessible target = this.targets[i];
            id accessibleElement = target.accessibleHandle(target);
            result.addObject(accessibleElement);
            ++i;
        }
        return result;
    }

    id getLinkedUIElements() {
        NSMutableArray result = NSMutableArray.arrayWithCapacity(this.targets.length);
        int i = 0;
        while (i < this.targets.length) {
            Accessible target = this.targets[i];
            id accessibleElement = target.accessibleHandle(target);
            result.addObject(accessibleElement);
            ++i;
        }
        return result;
    }
}

