/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.jarpackager;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.internal.core.manipulation.util.BasicElementLabels;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.jarpackager.JarPackagerMessagesCore;

public class JarPackagerUtilCore {
    private JarPackagerUtilCore() {
    }

    public static void addEntry(JarEntry entry, InputStream content, JarOutputStream jarOutputStream) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try {
            try {
                jarOutputStream.putNextEntry(entry);
                content.transferTo(jarOutputStream);
            }
            finally {
                if (content != null) {
                    content.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static void writeArchive(ZipFile zipFile, boolean areDirectoryEntriesIncluded, boolean isCompressed, JarOutputStream jarOutputStream, Set<String> directories, MultiStatus status, IProgressMonitor progressMonitor) {
        Enumeration<? extends ZipEntry> jarEntriesEnum = zipFile.entries();
        File zipFile1 = new File(zipFile.getName());
        try {
            String zipFileCanonical = zipFile1.getCanonicalPath();
            while (jarEntriesEnum.hasMoreElements()) {
                ZipEntry zipEntry = jarEntriesEnum.nextElement();
                if (!zipEntry.isDirectory()) {
                    String entryName = zipEntry.getName();
                    File zipEntryFile = new File(zipFile1, entryName);
                    String zipEntryCanonical = zipEntryFile.getCanonicalPath();
                    if (zipEntryCanonical.startsWith(zipFileCanonical + File.separator)) {
                        JarPackagerUtilCore.addFile(entryName, zipEntry, zipFile, areDirectoryEntriesIncluded, isCompressed, jarOutputStream, directories, status);
                    } else {
                        JarPackagerUtilCore.addWarning("Invalid path" + entryName, null, status);
                    }
                }
                progressMonitor.worked(1);
                if (!progressMonitor.isCanceled()) continue;
                throw new OperationCanceledException();
            }
        }
        catch (IOException e) {
            JarPackagerUtilCore.addWarning("ZipFile error" + zipFile.getName(), null, status);
            e.printStackTrace();
        }
    }

    private static void addFile(String destinationPath, ZipEntry jarEntry, ZipFile zipFile, boolean areDirectoryEntriesIncluded, boolean isCompressed, JarOutputStream jarOutputStream, Set<String> directories, MultiStatus status) {
        if ("META-INF/MANIFEST.MF".equalsIgnoreCase(destinationPath) || destinationPath.startsWith("META-INF/") && destinationPath.endsWith(".SF")) {
            return;
        }
        try {
            JarPackagerUtilCore.addZipEntry(jarEntry, zipFile, destinationPath, areDirectoryEntriesIncluded, isCompressed, jarOutputStream, directories);
        }
        catch (IOException ex) {
            if (ex instanceof ZipException && ex.getMessage() != null && ex.getMessage().startsWith("duplicate entry:")) {
                if (!destinationPath.startsWith("META-INF/")) {
                    JarPackagerUtilCore.addWarning(ex.getMessage(), ex, status);
                }
            }
            JarPackagerUtilCore.addWarning(Messages.format(JarPackagerMessagesCore.FatJarBuilder_error_readingArchiveFile, new Object[]{BasicElementLabels.getResourceName(zipFile.getName()), ex.getLocalizedMessage()}), ex, status);
        }
    }

    public static void addZipEntry(ZipEntry zipEntry, ZipFile zipFile, String path, boolean areDirectoryEntriesIncluded, boolean isCompressed, JarOutputStream jarOutputStream, Set<String> directories) throws IOException {
        if (areDirectoryEntriesIncluded) {
            JarPackagerUtilCore.addDirectories(path, jarOutputStream, directories);
        }
        JarEntry newEntry = new JarEntry(path.replace(File.separatorChar, '/'));
        if (isCompressed) {
            newEntry.setMethod(8);
        } else {
            newEntry.setMethod(0);
            newEntry.setSize(zipEntry.getSize());
            newEntry.setCrc(zipEntry.getCrc());
        }
        long lastModified = System.currentTimeMillis();
        newEntry.setTime(lastModified);
        Throwable throwable = null;
        Object var11_11 = null;
        try (InputStream content = zipFile.getInputStream(zipEntry);){
            jarOutputStream.putNextEntry(newEntry);
            content.transferTo(jarOutputStream);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static void addDirectories(String destPath, JarOutputStream jarOutputStream, Set<String> directories) throws IOException {
        String path = destPath.replace(File.separatorChar, '/');
        int lastSlash = path.lastIndexOf(47);
        ArrayList<JarEntry> entryDirectories = new ArrayList<JarEntry>(2);
        while (lastSlash != -1) {
            if (!directories.add(path = path.substring(0, lastSlash + 1))) break;
            JarEntry newEntry = new JarEntry(path);
            newEntry.setMethod(0);
            newEntry.setSize(0L);
            newEntry.setCrc(0L);
            newEntry.setTime(System.currentTimeMillis());
            entryDirectories.add(newEntry);
            lastSlash = path.lastIndexOf(47, lastSlash - 1);
        }
        int i = entryDirectories.size() - 1;
        while (i >= 0) {
            jarOutputStream.putNextEntry((ZipEntry)entryDirectories.get(i));
            --i;
        }
    }

    private static final void addWarning(String message, Throwable error, MultiStatus status) {
        status.add((IStatus)new Status(2, "org.eclipse.jdt.core.manipulation", 10001, message, error));
    }
}

