/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.launching.rap.ui;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.launcher.BaseBlock;
import org.eclipse.pde.ui.launcher.AbstractLauncherTab;
import org.eclipse.rcptt.launching.rap.RAPLaunchConfig;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class DataLocationBlock
extends BaseBlock {
    private Button useDefaultLocationButton;
    private Button clearInstanceAreaButton;
    private String instanceName;

    public DataLocationBlock(AbstractLauncherTab launcherTab) {
        super(launcherTab);
    }

    public Control createControl(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText("Instance Area");
        group.setLayout((Layout)new GridLayout(2, false));
        this.useDefaultLocationButton = this.createDefaultLocationButton((Composite)group);
        this.useDefaultLocationButton.setLayoutData((Object)DataLocationBlock.createHFillGridDataWithHSpan(2));
        this.createText((Composite)group, PDEUIMessages.ConfigurationTab_configLog, 20);
        Control buttonArea = this.createButtonArea((Composite)group);
        buttonArea.setLayoutData((Object)DataLocationBlock.createHFillGridDataWithHSpan(2));
        return group;
    }

    public void initializeFrom(RAPLaunchConfig rapConfig) throws CoreException {
        this.instanceName = rapConfig.getName();
        boolean useDefaultDataLocation = rapConfig.getUseDefaultDatatLocation();
        this.useDefaultLocationButton.setSelection(useDefaultDataLocation);
        this.enableBrowseSection(!useDefaultDataLocation);
        this.fLocationText.setEditable(!useDefaultDataLocation);
        this.fLocationText.setEnabled(!useDefaultDataLocation);
        boolean doClear = rapConfig.getDoClearDataLocation();
        this.clearInstanceAreaButton.setSelection(doClear);
        String defaultLocation = RAPLaunchConfig.getDefaultDataLocation((String)this.instanceName);
        String dataLocation = rapConfig.getDataLocation();
        if (useDefaultDataLocation) {
            this.fLocationText.setText(defaultLocation);
        } else {
            this.fLocationText.setText(dataLocation);
        }
    }

    public boolean getUseDefaultDataLocation() {
        return this.useDefaultLocationButton.getSelection();
    }

    public boolean getDoClearDataLocation() {
        return this.clearInstanceAreaButton.getSelection();
    }

    public String getLocation() {
        return super.getLocation();
    }

    protected String getName() {
        return "instanceAreaBlock";
    }

    protected boolean isFile() {
        return false;
    }

    private Button createDefaultLocationButton(Composite parent) {
        final Button button = new Button(parent, 32);
        button.setText(PDEUIMessages.ConfigurationTab_useDefaultLoc);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataLocationBlock.this.updateUseDefaultLocation(button.getSelection());
            }
        });
        return button;
    }

    private void updateUseDefaultLocation(boolean useDefaultLocation) {
        if (useDefaultLocation) {
            String defaultLocation = RAPLaunchConfig.getDefaultDataLocation((String)this.instanceName);
            this.fLocationText.setText(defaultLocation);
        }
        this.enableBrowseSection(!useDefaultLocation);
        this.fLocationText.setEditable(!useDefaultLocation);
        this.fLocationText.setEnabled(!useDefaultLocation);
    }

    private Control createButtonArea(Composite parent) {
        Composite buttonsArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout(4, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttonsArea.setLayout((Layout)layout);
        this.createInstanceAreaButton(buttonsArea);
        this.createButtons(buttonsArea, new String[]{PDEUIMessages.BaseBlock_workspace, PDEUIMessages.BaseBlock_filesystem, PDEUIMessages.BaseBlock_variables});
        return buttonsArea;
    }

    private void createInstanceAreaButton(Composite parent) {
        this.clearInstanceAreaButton = new Button(parent, 32);
        this.clearInstanceAreaButton.setText("Cle&ar the instance area before launching");
        GridData layoutData = DataLocationBlock.createHFillGridDataWithHSpan(1);
        this.clearInstanceAreaButton.setLayoutData((Object)layoutData);
        this.clearInstanceAreaButton.addSelectionListener((SelectionListener)this.fListener);
    }

    private static GridData createHFillGridDataWithHSpan(int horizontalSpan) {
        GridData result = new GridData(4, 0x1000000, true, false);
        result.horizontalSpan = horizontalSpan;
        return result;
    }
}

