/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.slf4j;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.equinox.slf4j.EquinoxLogger;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.log.LogService;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;

public class EquinoxLoggerFactory
implements ILoggerFactory {
    private static final StackWalker STACK_WALKER = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE);
    private static final Bundle FACTORY_BUNDLE = FrameworkUtil.getBundle(EquinoxLoggerFactory.class);
    private static final Bundle SLF4J_BUNDLE = FrameworkUtil.getBundle(ILoggerFactory.class);
    static final ConcurrentMap<Bundle, EquinoxLogger> LOGGER_MAP = new ConcurrentHashMap<Bundle, EquinoxLogger>();
    static final AtomicReference<LogService> logService = new AtomicReference();

    public Logger getLogger(String name) {
        Bundle bundle = this.getBundle();
        if (bundle == null) {
            return new EquinoxLogger(name, null);
        }
        return (Logger)LOGGER_MAP.computeIfAbsent(bundle, b -> {
            LogService service = logService.get();
            org.osgi.service.log.Logger bundleLogger = service == null ? null : service.getLogger(b, "org.eclipse.equinox.logger", org.osgi.service.log.Logger.class);
            return new EquinoxLogger(name, bundleLogger);
        });
    }

    private Bundle getBundle() {
        return STACK_WALKER.walk(s -> s.map(frame -> FrameworkUtil.getBundle(frame.getDeclaringClass())).dropWhile(stackFrameBundle -> stackFrameBundle == FACTORY_BUNDLE || stackFrameBundle == SLF4J_BUNDLE).findFirst().orElse(null));
    }
}

