/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params;

import java.util.Arrays;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.IntUnaryOperator;
import org.junit.jupiter.api.Named;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.platform.commons.util.Preconditions;

class EvaluatedArgumentSet {
    private final Object[] all;
    private final Object[] consumed;
    private final Optional<String> name;

    static EvaluatedArgumentSet allOf(Arguments arguments) {
        Object[] all = arguments.get();
        return EvaluatedArgumentSet.create(all, all, arguments);
    }

    static EvaluatedArgumentSet of(Arguments arguments, IntUnaryOperator consumedLengthComputer) {
        Object[] all = arguments.get();
        Object[] consumed = EvaluatedArgumentSet.dropSurplus(all, consumedLengthComputer.applyAsInt(all.length));
        return EvaluatedArgumentSet.create(all, consumed, arguments);
    }

    private static EvaluatedArgumentSet create(Object[] all, Object[] consumed, Arguments arguments) {
        return new EvaluatedArgumentSet(all, consumed, EvaluatedArgumentSet.determineName(arguments));
    }

    private EvaluatedArgumentSet(Object[] all, Object[] consumed, Optional<String> name) {
        this.all = all;
        this.consumed = consumed;
        this.name = name;
    }

    int getTotalLength() {
        return this.all.length;
    }

    Object[] getAllPayloads() {
        return EvaluatedArgumentSet.extractFromNamed(this.all, Named::getPayload);
    }

    int getConsumedLength() {
        return this.consumed.length;
    }

    Object[] getConsumedNames() {
        return EvaluatedArgumentSet.extractFromNamed(this.consumed, Named::getName);
    }

    Object[] getConsumedPayloads() {
        return EvaluatedArgumentSet.extractFromNamed(this.consumed, Named::getPayload);
    }

    Object getConsumedPayload(int index) {
        return EvaluatedArgumentSet.extractFromNamed(this.consumed[index], Named::getPayload);
    }

    Optional<String> getName() {
        return this.name;
    }

    private static Object[] dropSurplus(Object[] arguments, int newLength) {
        Preconditions.condition((newLength <= arguments.length ? 1 : 0) != 0, () -> String.format("New length %d must be less than or equal to the total length %d", newLength, arguments.length));
        return arguments.length > newLength ? Arrays.copyOf(arguments, newLength) : arguments;
    }

    private static Optional<String> determineName(Arguments arguments) {
        if (arguments instanceof Arguments.ArgumentSet) {
            return Optional.of(((Arguments.ArgumentSet)arguments).getName());
        }
        return Optional.empty();
    }

    private static Object[] extractFromNamed(Object[] arguments, Function<Named<?>, Object> mapper) {
        return Arrays.stream(arguments).map(argument -> EvaluatedArgumentSet.extractFromNamed(argument, mapper)).toArray();
    }

    private static Object extractFromNamed(Object argument, Function<Named<?>, Object> mapper) {
        return argument instanceof Named ? mapper.apply((Named)argument) : argument;
    }
}

