/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.bnd;

import aQute.bnd.properties.IDocument;
import aQute.bnd.properties.IRegion;
import aQute.bnd.properties.LineType;
import aQute.bnd.properties.PropertiesLineReader;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.bnd.BndDocument;

public class BndBuildPathAutoCompleteProcessor
implements IContentAssistProcessor {
    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        org.eclipse.jface.text.IDocument document = viewer.getDocument();
        if (document != null) {
            try {
                LineType type;
                PropertiesLineReader reader = new PropertiesLineReader((IDocument)new BndDocument(document));
                while ((type = reader.next()) != LineType.eof) {
                    if (type != LineType.entry) continue;
                    String key = reader.key();
                    IRegion region = reader.region();
                    if (!this.matches(region, offset)) continue;
                    Prefix prefix = this.getPrefix(document, offset);
                    if ("-buildpath".equals(key)) {
                        Value value = this.getValue(key, reader, document);
                        BundleDescription[] bundles = PDECore.getDefault().getModelManager().getState().getState().getBundles();
                        String strippedPrefix = prefix.prefix().strip().toLowerCase();
                        Comparator<BundleDescription> prefixMatchFirst = Comparator.comparingInt(bd -> bd.getSymbolicName().toLowerCase().startsWith(strippedPrefix) ? 0 : 1);
                        Comparator<BundleDescription> orderBySymbolicName = Comparator.comparing(BundleDescription::getSymbolicName, String.CASE_INSENSITIVE_ORDER);
                        ICompletionProposal[] array = (ICompletionProposal[])Arrays.stream(bundles).filter(bd -> bd.getSymbolicName() != null).filter(bd -> bd.getSymbolicName().toLowerCase().contains(strippedPrefix)).sorted(prefixMatchFirst.thenComparing(orderBySymbolicName)).map(bd -> {
                            String replacement = this.buildReplacement(key, value, (BundleDescription)bd, prefix);
                            CompletionProposal proposal = new CompletionProposal(replacement, region.getOffset(), region.getLength(), replacement.length(), null, bd.getSymbolicName(), null, null);
                            return proposal;
                        }).toArray(ICompletionProposal[]::new);
                        return array;
                    }
                    if ("-runee".equals(key)) continue;
                    "-includeresource".equals(key);
                }
            }
            catch (Exception e) {
                PDECore.log((IStatus)Status.error((String)"Internal error on autocompletion", (Throwable)e));
            }
        }
        return new ICompletionProposal[0];
    }

    private String buildReplacement(String key, Value value, BundleDescription bundleDescription, Prefix prefix) {
        StringBuilder sb = new StringBuilder();
        sb.append(key);
        sb.append(value.terminatingChar());
        String rawValue = value.value();
        String prefixString = prefix.prefix();
        String substring = rawValue.substring(0, rawValue.length() - prefixString.length());
        sb.append(substring);
        int l = prefixString.length();
        int i = 0;
        while (i < l) {
            char c = prefixString.charAt(i);
            if (Character.isWhitespace(c)) {
                sb.append(c);
            }
            ++i;
        }
        sb.append(bundleDescription.getSymbolicName());
        return sb.toString();
    }

    private Prefix getPrefix(org.eclipse.jface.text.IDocument document, int offset) {
        try {
            StringBuilder sb = new StringBuilder();
            while (offset > 0) {
                char c = document.getChar(offset - 1);
                if (c == ':' || c == '=' || c == ' ' || c == ',' || c == '\\') {
                    return new Prefix(c, sb.toString());
                }
                sb.insert(0, c);
                --offset;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return new Prefix(' ', "");
    }

    private boolean matches(IRegion region, int offset) {
        if (offset >= region.getOffset()) {
            return offset <= region.getOffset() + region.getLength();
        }
        return false;
    }

    private Value getValue(String key, PropertiesLineReader reader, org.eclipse.jface.text.IDocument document) throws BadLocationException {
        IRegion region = reader.region();
        String string = document.get(region.getOffset(), region.getLength()).substring(key.length());
        while (string.length() > 0) {
            char c = string.charAt(0);
            string = string.substring(1);
            if (c != ':' && c != '=') continue;
            return new Value(c, string);
        }
        return new Value(' ', "");
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return new IContextInformation[0];
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return new char[0];
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return new char[0];
    }

    public String getErrorMessage() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    private record Prefix(char terminatingChar, String prefix) {
    }

    private record Value(char terminatingChar, String value) {
    }
}

