/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.zephyr.ui.preferences;

import java.net.URL;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.rcptt.internal.zephyr.ZephyrPlugin;
import org.eclipse.rcptt.zephyr.ZephyrService;
import org.eclipse.rcptt.zephyr.internal.ui.Messages;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public final class ZephyrPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Button zephyrCheckBox;
    private Text zephyrAddress;
    private Text zephyrUsername;
    private Text zephyrPassword;
    private Button testConnectionButton;

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        if (this.zephyrCheckBox.getSelection()) {
            ZephyrPlugin.setZephyrEnabled((boolean)true);
        } else {
            ZephyrPlugin.setZephyrEnabled((boolean)false);
        }
        ZephyrPlugin.setZephyrAddress((String)this.zephyrAddress.getText());
        ZephyrPlugin.setZephyrUsername((String)this.zephyrUsername.getText());
        ZephyrPlugin.setZephyrPassword((String)this.zephyrPassword.getText());
        return super.performOk();
    }

    protected void performDefaults() {
        this.zephyrCheckBox.setSelection(false);
        this.zephyrAddress.setText("");
        this.zephyrUsername.setText("");
        this.zephyrPassword.setText("");
        this.testConnectionButton.setEnabled(false);
        super.performDefaults();
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, false));
        this.zephyrCheckBox = this.createCheckBoxButton(composite, Messages.ZephyrPreferencePage_EnableIntegration, ZephyrPlugin.getZephyrEnabled());
        this.zephyrAddress = this.createText(composite, Messages.ZephyrPreferencePage_Address, ZephyrPlugin.getZephyrAddress());
        this.zephyrUsername = this.createText(composite, Messages.ZephyrPreferencePage_Username, ZephyrPlugin.getZephyrUsername());
        this.zephyrPassword = this.createText(composite, Messages.ZephyrPreferencePage_Password, ZephyrPlugin.getZephyrPassword());
        this.zephyrPassword.setEchoChar('*');
        this.testConnectionButton = this.createButton(composite, Messages.ZephyrPreferencePage_TestConnection);
        boolean state = ZephyrPlugin.getZephyrEnabled();
        this.testConnectionButton.setEnabled(state && this.isValid());
        return null;
    }

    private Text createText(Composite parent, String labelText, String initialValue) {
        Label label = new Label(parent, 16384);
        label.setText(labelText);
        Text text = new Text(parent, 2048);
        text.setText(initialValue);
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ZephyrPreferencePage.this.validate();
                boolean state = ZephyrPreferencePage.this.zephyrCheckBox.getSelection();
                ZephyrPreferencePage.this.testConnectionButton.setEnabled(state && ZephyrPreferencePage.this.isValid());
            }
        });
        text.setLayoutData((Object)new GridData(768));
        return text;
    }

    private Button createCheckBoxButton(Composite parent, String labelText, boolean state) {
        Label label = new Label(parent, 16384);
        label.setText(labelText);
        Button button = new Button(parent, 32);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ZephyrPreferencePage.this.validate();
                boolean state = ZephyrPreferencePage.this.zephyrCheckBox.getSelection();
                ZephyrPreferencePage.this.testConnectionButton.setEnabled(state && ZephyrPreferencePage.this.isValid());
            }
        });
        button.setSelection(state);
        return button;
    }

    private Button createButton(Composite parent, String labelText) {
        Button button = new Button(parent, 8);
        button.setText(labelText);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ZephyrPreferencePage.this.testConnection();
            }
        });
        return button;
    }

    private void validate() {
        String message = this.doValidate();
        this.setMessage(null);
        this.setErrorMessage(message);
        this.setValid(message == null);
    }

    private String doValidate() {
        if (!this.zephyrCheckBox.getSelection()) {
            return null;
        }
        if (!this.isValidURL(this.zephyrAddress.getText())) {
            return Messages.ZephyrPreferencePage_IncorrectAddressMsg;
        }
        if (this.zephyrUsername.getText() == null || this.zephyrUsername.getText().equals("")) {
            return MessageFormat.format(Messages.ZephyrPreferencePage_FieldNotSpecifiedMsg, Messages.ZephyrPreferencePage_Username);
        }
        if (this.zephyrPassword.getText() == null || this.zephyrPassword.getText().equals("")) {
            return MessageFormat.format(Messages.ZephyrPreferencePage_FieldNotSpecifiedMsg, Messages.ZephyrPreferencePage_Password);
        }
        return null;
    }

    private boolean isValidURL(String urlString) {
        try {
            URL url = new URL(urlString);
            return !url.getHost().equals("");
        }
        catch (Exception e) {
            ZephyrPlugin.log((Throwable)e);
            return false;
        }
    }

    private void testConnection() {
        BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable(){

            @Override
            public void run() {
                String password;
                String username;
                ZephyrService service = new ZephyrService();
                String address = ZephyrPreferencePage.this.zephyrAddress.getText();
                IStatus result = service.doTestConnection(address, username = ZephyrPreferencePage.this.zephyrUsername.getText(), password = ZephyrPreferencePage.this.zephyrPassword.getText());
                if (result.isOK()) {
                    ZephyrPreferencePage.this.setMessage(result.getMessage(), 1);
                    ZephyrPreferencePage.this.setErrorMessage(null);
                } else {
                    ZephyrPreferencePage.this.setMessage(null);
                    ZephyrPreferencePage.this.setErrorMessage(result.getMessage());
                }
            }
        });
    }
}

