/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.repository.sail;

import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.BooleanQuery;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.parser.ParsedBooleanQuery;
import org.eclipse.rdf4j.repository.sail.SailQuery;
import org.eclipse.rdf4j.repository.sail.SailRepositoryConnection;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.SailException;

public class SailBooleanQuery
extends SailQuery
implements BooleanQuery {
    protected SailBooleanQuery(ParsedBooleanQuery tupleQuery, SailRepositoryConnection sailConnection) {
        super(tupleQuery, sailConnection);
    }

    @Override
    public ParsedBooleanQuery getParsedQuery() {
        return (ParsedBooleanQuery)super.getParsedQuery();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean evaluate() throws QueryEvaluationException {
        ParsedBooleanQuery parsedBooleanQuery = this.getParsedQuery();
        TupleExpr tupleExpr = parsedBooleanQuery.getTupleExpr();
        Dataset dataset = this.getDataset();
        if (dataset == null) {
            dataset = parsedBooleanQuery.getDataset();
        }
        CloseableIteration<? extends BindingSet, QueryEvaluationException> bindingsIter1 = null;
        CloseableIteration<? extends BindingSet, QueryEvaluationException> bindingsIter2 = null;
        try {
            SailConnection sailCon = this.getConnection().getSailConnection();
            bindingsIter1 = sailCon.evaluate(tupleExpr, dataset, this.getBindings(), this.getIncludeInferred());
            bindingsIter2 = this.enforceMaxQueryTime(bindingsIter1);
            boolean bl = bindingsIter2.hasNext();
            return bl;
        }
        catch (SailException e) {
            throw new QueryEvaluationException(e.getMessage(), e);
        }
        finally {
            try {
                if (bindingsIter2 != null) {
                    bindingsIter2.close();
                }
            }
            finally {
                if (bindingsIter1 != null) {
                    bindingsIter1.close();
                }
            }
        }
    }
}

