/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.SHACL;
import org.eclipse.rdf4j.sail.shacl.SourceConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ValidationSettings;
import org.eclipse.rdf4j.sail.shacl.ast.Cache;
import org.eclipse.rdf4j.sail.shacl.ast.ShaclProperties;
import org.eclipse.rdf4j.sail.shacl.ast.Shape;
import org.eclipse.rdf4j.sail.shacl.ast.SparqlFragment;
import org.eclipse.rdf4j.sail.shacl.ast.StatementMatcher;
import org.eclipse.rdf4j.sail.shacl.ast.ValidationApproach;
import org.eclipse.rdf4j.sail.shacl.ast.ValidationQuery;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.ConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.paths.Path;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.EmptyNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNodeProvider;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ShiftToNodeShape;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.TargetChainPopper;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.UnionNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.Unique;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationReportNode;
import org.eclipse.rdf4j.sail.shacl.ast.targets.TargetChain;
import org.eclipse.rdf4j.sail.shacl.results.ValidationResult;
import org.eclipse.rdf4j.sail.shacl.wrapper.data.ConnectionsGroup;
import org.eclipse.rdf4j.sail.shacl.wrapper.data.RdfsSubClassOfReasoner;
import org.eclipse.rdf4j.sail.shacl.wrapper.shape.ShapeSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyShape
extends Shape {
    private static final Logger logger = LoggerFactory.getLogger(PropertyShape.class);
    List<String> name;
    List<String> description;
    Object defaultValue;
    Object group;
    Path path;

    public PropertyShape() {
    }

    public PropertyShape(PropertyShape propertyShape) {
        super(propertyShape);
        this.name = propertyShape.name;
        this.description = propertyShape.description;
        this.defaultValue = propertyShape.defaultValue;
        this.group = propertyShape.group;
        this.path = propertyShape.path;
    }

    public static PropertyShape getInstance(ShaclProperties properties, ShapeSource shapeSource, Shape.ParseSettings parseSettings, Cache cache) {
        Shape shape = cache.get(properties.getId());
        if (shape == null) {
            shape = new PropertyShape();
            cache.put(properties.getId(), shape);
            shape.populate(properties, shapeSource, parseSettings, cache);
        }
        if (shape.constraintComponents.isEmpty()) {
            shape.deactivated = true;
        }
        return (PropertyShape)shape;
    }

    @Override
    public void populate(ShaclProperties properties, ShapeSource connection, Shape.ParseSettings parseSettings, Cache cache) {
        super.populate(properties, connection, parseSettings, cache);
        this.path = Path.buildPath(connection, properties.getPath());
        if (this.path == null) {
            throw new IllegalStateException(properties.getId() + " is a sh:PropertyShape without a sh:path!");
        }
        this.constraintComponents = this.getConstraintComponents(properties, connection, parseSettings, cache);
    }

    @Override
    protected Shape shallowClone() {
        return new PropertyShape(this);
    }

    @Override
    public void toModel(Resource subject, IRI predicate, Model model, Set<Resource> cycleDetection) {
        super.toModel(subject, predicate, model, cycleDetection);
        model.add(this.getId(), RDF.TYPE, SHACL.PROPERTY_SHAPE, new Resource[0]);
        if (subject != null) {
            if (predicate == null) {
                model.add(subject, SHACL.PROPERTY, this.getId(), new Resource[0]);
            } else {
                model.add(subject, predicate, this.getId(), new Resource[0]);
            }
        }
        if (!cycleDetection.contains(this.getId())) {
            model.add(this.getId(), SHACL.PATH, this.path.getId(), new Resource[0]);
            this.path.toModel(this.path.getId(), null, model, cycleDetection);
        }
        cycleDetection.add(this.getId());
        this.constraintComponents.forEach(c -> c.toModel(this.getId(), null, model, cycleDetection));
    }

    @Override
    public void setTargetChain(TargetChain targetChain) {
        super.setTargetChain(targetChain.add(this.path));
    }

    @Override
    public ValidationQuery generateSparqlValidationQuery(ConnectionsGroup connectionsGroup, ValidationSettings validationSettings, boolean negatePlan, boolean negateChildren, ConstraintComponent.Scope scope) {
        if (this.deactivated) {
            return ValidationQuery.Deactivated.getInstance();
        }
        if (!this.getPath().isSupported()) {
            logger.error("Unsupported SHACL feature detected: {}. Shape ignored!\n{}", (Object)this.path, (Object)this);
            return ValidationQuery.Deactivated.getInstance();
        }
        ValidationQuery validationQuery = this.constraintComponents.stream().map(c -> {
            ValidationQuery validationQuery1 = c.generateSparqlValidationQuery(connectionsGroup, validationSettings, negatePlan, negateChildren, ConstraintComponent.Scope.propertyShape);
            if (!(c instanceof PropertyShape)) {
                return validationQuery1.withConstraintComponent((ConstraintComponent)c);
            }
            return validationQuery1;
        }).reduce((a, b) -> ValidationQuery.union(a, b, !this.produceValidationReports)).orElseThrow(IllegalStateException::new);
        if (this.produceValidationReports) {
            assert (this.constraintComponents.size() == 1);
            assert (!(this.constraintComponents.get(0) instanceof PropertyShape));
            validationQuery.withShape(this);
            validationQuery.withSeverity(this.getSeverity());
            validationQuery.makeCurrentStateValidationReport();
        }
        if (scope == ConstraintComponent.Scope.propertyShape) {
            validationQuery.popTargetChain();
        } else {
            validationQuery.shiftToNodeShape();
        }
        return validationQuery;
    }

    @Override
    public PlanNode generateTransactionalValidationPlan(ConnectionsGroup connectionsGroup, ValidationSettings validationSettings, PlanNodeProvider overrideTargetNode, ConstraintComponent.Scope scope) {
        if (this.isDeactivated()) {
            return EmptyNode.getInstance();
        }
        if (!this.getPath().isSupported()) {
            logger.error("Unsupported SHACL feature detected: {}. Shape ignored!\n{}", (Object)this.path, (Object)this);
            return EmptyNode.getInstance();
        }
        PlanNode union = EmptyNode.getInstance();
        for (ConstraintComponent constraintComponent : this.constraintComponents) {
            PlanNode validationPlanNode = constraintComponent.generateTransactionalValidationPlan(connectionsGroup, validationSettings, overrideTargetNode, ConstraintComponent.Scope.propertyShape);
            if (!(constraintComponent instanceof PropertyShape)) {
                validationPlanNode = new ValidationReportNode(validationPlanNode, t -> new ValidationResult(t.getActiveTarget(), t.getValue(), this, constraintComponent, this.getSeverity(), t.getScope(), t.getContexts(), this.getContexts()));
            }
            validationPlanNode = scope == ConstraintComponent.Scope.propertyShape ? Unique.getInstance(new TargetChainPopper(validationPlanNode), true) : Unique.getInstance(new ShiftToNodeShape(validationPlanNode), true);
            union = UnionNode.getInstance(union, validationPlanNode);
        }
        return union;
    }

    @Override
    public PlanNode getAllTargetsPlan(ConnectionsGroup connectionsGroup, Resource[] dataGraph, ConstraintComponent.Scope scope, StatementMatcher.StableRandomVariableProvider stableRandomVariableProvider, ValidationSettings validationSettings) {
        PlanNode planNode = this.constraintComponents.stream().map(c -> c.getAllTargetsPlan(connectionsGroup, dataGraph, ConstraintComponent.Scope.propertyShape, new StatementMatcher.StableRandomVariableProvider(), validationSettings)).distinct().reduce((xva$0, xva$1) -> UnionNode.getInstanceDedupe(xva$0, xva$1)).orElse(EmptyNode.getInstance());
        if (connectionsGroup.getStats().hasRemoved()) {
            PlanNode planNodeEffectiveTarget = this.getTargetChain().getEffectiveTarget(ConstraintComponent.Scope.propertyShape, connectionsGroup.getRdfsSubClassOfReasoner(), stableRandomVariableProvider).getPlanNode(connectionsGroup, dataGraph, ConstraintComponent.Scope.propertyShape, true, null);
            planNode = UnionNode.getInstanceDedupe(planNode, planNodeEffectiveTarget);
        }
        planNode = scope == ConstraintComponent.Scope.propertyShape ? Unique.getInstance(new TargetChainPopper(planNode), true) : new ShiftToNodeShape(planNode);
        planNode = Unique.getInstance(planNode, false);
        return planNode;
    }

    @Override
    public ValidationApproach getPreferredValidationApproach(ConnectionsGroup connectionsGroup) {
        return this.constraintComponents.stream().map(constraintComponent -> constraintComponent.getPreferredValidationApproach(connectionsGroup)).reduce(ValidationApproach::reducePreferred).orElse(ValidationApproach.MOST_COMPATIBLE);
    }

    public Path getPath() {
        return this.path;
    }

    @Override
    public boolean requiresEvaluation(ConnectionsGroup connectionsGroup, ConstraintComponent.Scope scope, Resource[] dataGraph, StatementMatcher.StableRandomVariableProvider stableRandomVariableProvider) {
        if (!this.getPath().isSupported()) {
            logger.error("Unsupported SHACL feature detected: {}. Shape ignored!\n{}", (Object)this.path, (Object)this);
            return false;
        }
        return super.requiresEvaluation(connectionsGroup, scope, dataGraph, stableRandomVariableProvider);
    }

    @Override
    public ConstraintComponent deepClone() {
        PropertyShape nodeShape = new PropertyShape(this);
        nodeShape.constraintComponents = this.constraintComponents.stream().map(ConstraintComponent::deepClone).collect(Collectors.toList());
        return nodeShape;
    }

    @Override
    public SparqlFragment buildSparqlValidNodes_rsx_targetShape(StatementMatcher.Variable<Value> subject, StatementMatcher.Variable<Value> object, RdfsSubClassOfReasoner rdfsSubClassOfReasoner, ConstraintComponent.Scope scope, StatementMatcher.StableRandomVariableProvider stableRandomVariableProvider) {
        List<SparqlFragment> sparqlFragments = this.constraintComponents.stream().map(shape -> shape.buildSparqlValidNodes_rsx_targetShape(object, stableRandomVariableProvider.next(), rdfsSubClassOfReasoner, ConstraintComponent.Scope.propertyShape, stableRandomVariableProvider)).collect(Collectors.toList());
        if (SparqlFragment.isFilterCondition(sparqlFragments)) {
            return SparqlFragment.and(sparqlFragments);
        }
        return SparqlFragment.join(sparqlFragments);
    }

    @Override
    public SourceConstraintComponent getConstraintComponent() {
        return SourceConstraintComponent.PropertyConstraintComponent;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PropertyShape that = (PropertyShape)o;
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.description, that.description)) {
            return false;
        }
        if (!Objects.equals(this.defaultValue, that.defaultValue)) {
            return false;
        }
        if (!Objects.equals(this.group, that.group)) {
            return false;
        }
        return Objects.equals(this.path, that.path);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.defaultValue != null ? this.defaultValue.hashCode() : 0);
        result = 31 * result + (this.group != null ? this.group.hashCode() : 0);
        result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
        return result;
    }
}

