/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.impl;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.algebra.And;
import org.eclipse.rdf4j.query.algebra.Difference;
import org.eclipse.rdf4j.query.algebra.EmptySet;
import org.eclipse.rdf4j.query.algebra.Filter;
import org.eclipse.rdf4j.query.algebra.Intersection;
import org.eclipse.rdf4j.query.algebra.Join;
import org.eclipse.rdf4j.query.algebra.LeftJoin;
import org.eclipse.rdf4j.query.algebra.Or;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.QueryModelVisitor;
import org.eclipse.rdf4j.query.algebra.SingletonSet;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.UnaryTupleOperator;
import org.eclipse.rdf4j.query.algebra.Union;
import org.eclipse.rdf4j.query.algebra.ValueConstant;
import org.eclipse.rdf4j.query.algebra.ValueExpr;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryOptimizer;
import org.eclipse.rdf4j.query.algebra.evaluation.util.QueryEvaluationUtility;
import org.eclipse.rdf4j.query.algebra.helpers.AbstractQueryModelVisitor;
import org.eclipse.rdf4j.query.algebra.helpers.collectors.VarNameCollector;

@Deprecated(forRemoval=true, since="4.1.0")
public class QueryModelNormalizer
extends AbstractQueryModelVisitor<RuntimeException>
implements QueryOptimizer {
    @Override
    public void optimize(TupleExpr tupleExpr, Dataset dataset, BindingSet bindings) {
        tupleExpr.visit((QueryModelVisitor)this);
    }

    public void meet(Join join) {
        super.meet(join);
        TupleExpr leftArg = join.getLeftArg();
        TupleExpr rightArg = join.getRightArg();
        if (leftArg instanceof EmptySet || rightArg instanceof EmptySet) {
            join.replaceWith((QueryModelNode)new EmptySet());
        } else if (leftArg instanceof SingletonSet) {
            join.replaceWith((QueryModelNode)rightArg);
        } else if (rightArg instanceof SingletonSet) {
            join.replaceWith((QueryModelNode)leftArg);
        } else if (leftArg instanceof Union) {
            Union union = (Union)leftArg;
            Join leftJoin = new Join(union.getLeftArg(), rightArg.clone());
            Join rightJoin = new Join(union.getRightArg(), rightArg.clone());
            Union newUnion = new Union((TupleExpr)leftJoin, (TupleExpr)rightJoin);
            newUnion.setVariableScopeChange(union.isVariableScopeChange());
            join.replaceWith((QueryModelNode)newUnion);
            newUnion.visit((QueryModelVisitor)this);
        } else if (rightArg instanceof Union) {
            Union union = (Union)rightArg;
            Join leftJoin = new Join(leftArg.clone(), union.getLeftArg());
            Join rightJoin = new Join(leftArg.clone(), union.getRightArg());
            Union newUnion = new Union((TupleExpr)leftJoin, (TupleExpr)rightJoin);
            newUnion.setVariableScopeChange(union.isVariableScopeChange());
            join.replaceWith((QueryModelNode)newUnion);
            newUnion.visit((QueryModelVisitor)this);
        } else if (leftArg instanceof LeftJoin && this.isWellDesigned((LeftJoin)leftArg)) {
            LeftJoin leftJoin = (LeftJoin)leftArg;
            join.replaceWith((QueryModelNode)leftJoin);
            join.setLeftArg(leftJoin.getLeftArg());
            leftJoin.setLeftArg((TupleExpr)join);
            leftJoin.visit((QueryModelVisitor)this);
        } else if (rightArg instanceof LeftJoin && this.isWellDesigned((LeftJoin)rightArg)) {
            LeftJoin leftJoin = (LeftJoin)rightArg;
            join.replaceWith((QueryModelNode)leftJoin);
            join.setRightArg(leftJoin.getLeftArg());
            leftJoin.setLeftArg((TupleExpr)join);
            leftJoin.visit((QueryModelVisitor)this);
        }
    }

    public void meet(LeftJoin leftJoin) {
        super.meet(leftJoin);
        TupleExpr leftArg = leftJoin.getLeftArg();
        TupleExpr rightArg = leftJoin.getRightArg();
        ValueExpr condition = leftJoin.getCondition();
        if (leftArg instanceof EmptySet) {
            leftJoin.replaceWith((QueryModelNode)leftArg);
        } else if (rightArg instanceof EmptySet) {
            leftJoin.replaceWith((QueryModelNode)leftArg);
        } else if (rightArg instanceof SingletonSet) {
            leftJoin.replaceWith((QueryModelNode)leftArg);
        } else if (condition instanceof ValueConstant) {
            boolean conditionValue = QueryEvaluationUtility.getEffectiveBooleanValue(((ValueConstant)condition).getValue()).orElse(false);
            if (!conditionValue) {
                leftJoin.replaceWith((QueryModelNode)leftArg);
            } else {
                leftJoin.setCondition(null);
            }
        }
    }

    public void meet(Union union) {
        super.meet(union);
        TupleExpr leftArg = union.getLeftArg();
        TupleExpr rightArg = union.getRightArg();
        if (leftArg instanceof EmptySet) {
            union.replaceWith((QueryModelNode)rightArg);
        } else if (rightArg instanceof EmptySet) {
            union.replaceWith((QueryModelNode)leftArg);
        }
    }

    public void meet(Difference difference) {
        super.meet(difference);
        TupleExpr leftArg = difference.getLeftArg();
        TupleExpr rightArg = difference.getRightArg();
        if (leftArg instanceof EmptySet) {
            difference.replaceWith((QueryModelNode)leftArg);
        } else if (rightArg instanceof EmptySet) {
            difference.replaceWith((QueryModelNode)leftArg);
        } else if (leftArg instanceof SingletonSet && rightArg instanceof SingletonSet) {
            difference.replaceWith((QueryModelNode)new EmptySet());
        }
    }

    public void meet(Intersection intersection) {
        super.meet(intersection);
        TupleExpr leftArg = intersection.getLeftArg();
        TupleExpr rightArg = intersection.getRightArg();
        if (leftArg instanceof EmptySet || rightArg instanceof EmptySet) {
            intersection.replaceWith((QueryModelNode)new EmptySet());
        }
    }

    protected void meetUnaryTupleOperator(UnaryTupleOperator node) {
        super.meetUnaryTupleOperator(node);
        if (node.getArg() instanceof EmptySet) {
            node.replaceWith((QueryModelNode)node.getArg());
        }
    }

    public void meet(Filter node) {
        super.meet(node);
        TupleExpr arg = node.getArg();
        ValueExpr condition = node.getCondition();
        if (!(arg instanceof EmptySet) && condition instanceof ValueConstant) {
            boolean conditionValue = QueryEvaluationUtility.getEffectiveBooleanValue(((ValueConstant)condition).getValue()).orElse(false);
            if (!conditionValue) {
                node.replaceWith((QueryModelNode)new EmptySet());
            } else {
                node.replaceWith((QueryModelNode)arg);
            }
        }
    }

    public void meet(Or or) {
        super.meet(or);
        if (or.getLeftArg().equals(or.getRightArg())) {
            or.replaceWith((QueryModelNode)or.getLeftArg());
        }
    }

    public void meet(And and) {
        super.meet(and);
        if (and.getLeftArg().equals(and.getRightArg())) {
            and.replaceWith((QueryModelNode)and.getLeftArg());
        }
    }

    private boolean isWellDesigned(LeftJoin leftJoin) {
        QueryModelNode parent;
        VarNameCollector optionalVarCollector = new VarNameCollector();
        leftJoin.getRightArg().visit((QueryModelVisitor)optionalVarCollector);
        if (leftJoin.hasCondition()) {
            leftJoin.getCondition().visit((QueryModelVisitor)optionalVarCollector);
        }
        Set problemVars = optionalVarCollector.getVarNames();
        problemVars.removeAll(leftJoin.getLeftArg().getBindingNames());
        if (problemVars.isEmpty()) {
            return true;
        }
        BindingCollector bindingCollector = new BindingCollector();
        LeftJoin node = leftJoin;
        while ((parent = node.getParentNode()) != null) {
            bindingCollector.setNodeToIgnore((QueryModelNode)node);
            parent.visitChildren((QueryModelVisitor)bindingCollector);
            node = parent;
        }
        problemVars.retainAll(bindingCollector.getBindingNames());
        return problemVars.isEmpty();
    }

    private static class BindingCollector
    extends AbstractQueryModelVisitor<RuntimeException> {
        private QueryModelNode nodeToIgnore;
        private final Set<String> bindingNames = new HashSet<String>();

        private BindingCollector() {
        }

        public void setNodeToIgnore(QueryModelNode node) {
            this.nodeToIgnore = node;
        }

        public Set<String> getBindingNames() {
            return this.bindingNames;
        }

        protected void meetNode(QueryModelNode node) {
            if (node instanceof TupleExpr && node != this.nodeToIgnore) {
                TupleExpr tupleExpr = (TupleExpr)node;
                this.bindingNames.addAll(tupleExpr.getBindingNames());
            }
        }
    }
}

