/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.nativerdf;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.rdf4j.sail.nativerdf.RecordCache;
import org.eclipse.rdf4j.sail.nativerdf.btree.RecordIterator;

public class InMemRecordCache
implements RecordCache {
    private List<byte[]> records = new ArrayList<byte[]>(1);

    @Override
    public void setMaxRecords(long maxRecords) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getRecordCount() {
        return this.records.size();
    }

    @Override
    public void storeRecord(byte[] data) throws IOException {
        this.records.add(data);
    }

    @Override
    public void storeRecords(RecordCache otherCache) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() throws IOException {
        this.records = new ArrayList<byte[]>(1);
    }

    @Override
    public RecordIterator getRecords() throws IOException {
        return new RecordIterator(){
            private int index = 0;

            @Override
            public byte[] next() throws IOException {
                if (this.index < InMemRecordCache.this.records.size()) {
                    return InMemRecordCache.this.records.get(this.index++);
                }
                return null;
            }

            @Override
            public void set(byte[] record) throws IOException {
                InMemRecordCache.this.records.set(this.index - 1, record);
            }

            @Override
            public void close() throws IOException {
            }
        };
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public void discard() throws IOException {
    }
}

