/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.http.server.repository.transaction;

import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.rdf4j.http.server.ServerHTTPException;
import org.eclipse.rdf4j.http.server.repository.transaction.Transaction;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFWriter;
import org.eclipse.rdf4j.rio.RDFWriterFactory;
import org.springframework.web.servlet.View;

public class TransactionExportStatementsView
implements View {
    public static final String SUBJECT_KEY = "subject";
    public static final String PREDICATE_KEY = "predicate";
    public static final String OBJECT_KEY = "object";
    public static final String CONTEXTS_KEY = "contexts";
    public static final String USE_INFERENCING_KEY = "useInferencing";
    public static final String TRANSACTION_KEY = "transaction";
    public static final String FACTORY_KEY = "factory";
    public static final String HEADERS_ONLY = "headersOnly";
    private static final TransactionExportStatementsView INSTANCE = new TransactionExportStatementsView();

    public static TransactionExportStatementsView getInstance() {
        return INSTANCE;
    }

    private TransactionExportStatementsView() {
    }

    public String getContentType() {
        return null;
    }

    public void render(Map model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Resource subj = (Resource)model.get(SUBJECT_KEY);
        IRI pred = (IRI)model.get(PREDICATE_KEY);
        Value obj = (Value)model.get(OBJECT_KEY);
        Resource[] contexts = (Resource[])model.get(CONTEXTS_KEY);
        boolean useInferencing = (Boolean)model.get(USE_INFERENCING_KEY);
        Transaction transaction = (Transaction)model.get(TRANSACTION_KEY);
        boolean headersOnly = (Boolean)model.get(HEADERS_ONLY);
        RDFWriterFactory rdfWriterFactory = (RDFWriterFactory)model.get(FACTORY_KEY);
        RDFFormat rdfFormat = rdfWriterFactory.getRDFFormat();
        try (ServletOutputStream out = response.getOutputStream();){
            RDFWriter rdfWriter = rdfWriterFactory.getWriter((OutputStream)out);
            response.setStatus(200);
            Object mimeType = rdfFormat.getDefaultMIMEType();
            if (rdfFormat.hasCharset()) {
                Charset charset = rdfFormat.getCharset();
                mimeType = (String)mimeType + "; charset=" + charset.name();
            }
            response.setContentType((String)mimeType);
            Object filename = "statements";
            if (rdfFormat.getDefaultFileExtension() != null) {
                filename = (String)filename + "." + rdfFormat.getDefaultFileExtension();
            }
            response.setHeader("Content-Disposition", "attachment; filename=" + (String)filename);
            if (!headersOnly) {
                transaction.exportStatements(subj, pred, obj, useInferencing, rdfWriter, contexts);
            }
        }
        catch (RDFHandlerException e) {
            throw new ServerHTTPException("Serialization error: " + e.getMessage(), (Throwable)e);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new ServerHTTPException("Repository error: " + e.getMessage(), (Throwable)e);
        }
    }
}

