/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.rdf4j.query.algebra.Exists;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.QueryModelVisitor;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.UnaryTupleOperator;
import org.eclipse.rdf4j.query.algebra.ValueExpr;

public class Filter
extends UnaryTupleOperator {
    private ValueExpr condition;

    public Filter() {
    }

    public Filter(TupleExpr arg, ValueExpr condition) {
        super(arg);
        this.setCondition(condition);
    }

    public ValueExpr getCondition() {
        return this.condition;
    }

    public void setCondition(ValueExpr condition) {
        assert (condition != null) : "condition must not be null";
        condition.setParentNode(this);
        this.condition = condition;
    }

    @Override
    public Set<String> getBindingNames() {
        Set<String> result = this.getArg().getBindingNames();
        if (this.condition instanceof Exists) {
            result = Stream.concat(result.stream(), ((Exists)this.condition).getSubQuery().getBindingNames().stream()).collect(Collectors.toSet());
        }
        return result;
    }

    @Override
    public <X extends Exception> void visit(QueryModelVisitor<X> visitor) throws X {
        visitor.meet(this);
    }

    @Override
    public <X extends Exception> void visitChildren(QueryModelVisitor<X> visitor) throws X {
        this.condition.visit(visitor);
        super.visitChildren(visitor);
    }

    @Override
    public void replaceChildNode(QueryModelNode current, QueryModelNode replacement) {
        if (this.condition == current) {
            this.setCondition((ValueExpr)replacement);
        } else {
            super.replaceChildNode(current, replacement);
        }
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof Filter && super.equals(other)) {
            Filter o = (Filter)other;
            return this.condition.equals(o.getCondition());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.condition.hashCode();
    }

    @Override
    public Filter clone() {
        Filter clone = (Filter)super.clone();
        clone.setCondition(this.getCondition().clone());
        return clone;
    }

    @Override
    public String getSignature() {
        StringBuilder sb = new StringBuilder(128);
        sb.append(super.getSignature());
        return sb.toString();
    }
}

