/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.rio.helpers;

import org.eclipse.rdf4j.model.ModelFactory;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.impl.LinkedHashModelFactory;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFHandlerException;

public class RDFHandlerWrapper
implements RDFHandler {
    private final RDFHandler[] rdfHandlers;
    private final ModelFactory modelFactory;

    public RDFHandlerWrapper(RDFHandler ... rdfHandlers) {
        this(new LinkedHashModelFactory(), rdfHandlers);
    }

    public RDFHandlerWrapper(ModelFactory modelFactory, RDFHandler ... rdfHandlers) {
        assert (rdfHandlers != null);
        this.rdfHandlers = rdfHandlers;
        this.modelFactory = modelFactory;
    }

    @Override
    public void startRDF() throws RDFHandlerException {
        for (RDFHandler rdfHandler : this.rdfHandlers) {
            rdfHandler.startRDF();
        }
    }

    @Override
    public void endRDF() throws RDFHandlerException {
        for (RDFHandler rdfHandler : this.rdfHandlers) {
            rdfHandler.endRDF();
        }
    }

    @Override
    public void handleNamespace(String prefix, String uri) throws RDFHandlerException {
        for (RDFHandler rdfHandler : this.rdfHandlers) {
            rdfHandler.handleNamespace(prefix, uri);
        }
    }

    @Override
    public void handleStatement(Statement st) throws RDFHandlerException {
        for (RDFHandler rdfHandler : this.rdfHandlers) {
            rdfHandler.handleStatement(st);
        }
    }

    @Override
    public void handleComment(String comment) throws RDFHandlerException {
        for (RDFHandler rdfHandler : this.rdfHandlers) {
            rdfHandler.handleComment(comment);
        }
    }

    public ModelFactory getModelFactory() {
        return this.modelFactory;
    }
}

