/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.rio.languages;

import java.util.Objects;
import java.util.regex.Pattern;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.util.LiteralUtilException;
import org.eclipse.rdf4j.rio.LanguageHandler;

public class RFC3066LanguageHandler
implements LanguageHandler {
    protected final Pattern matcher = Pattern.compile("[a-zA-Z]{1,8}(-[a-zA-Z0-9]{1,8})*");

    @Override
    public boolean isRecognizedLanguage(String languageTag) {
        Objects.requireNonNull(languageTag, "Language tag cannot be null");
        boolean result = this.matcher.matcher(languageTag).matches();
        return result;
    }

    @Override
    public boolean verifyLanguage(String literalValue, String languageTag) throws LiteralUtilException {
        Objects.requireNonNull(languageTag, "Language tag cannot be null");
        Objects.requireNonNull(literalValue, "Literal value cannot be null");
        if (this.isRecognizedLanguage(languageTag)) {
            return true;
        }
        throw new LiteralUtilException("Could not verify RFC3066 language tag");
    }

    @Override
    public Literal normalizeLanguage(String literalValue, String languageTag, ValueFactory valueFactory) throws LiteralUtilException {
        Objects.requireNonNull(languageTag, "Language tag cannot be null");
        Objects.requireNonNull(literalValue, "Literal value cannot be null");
        if (this.isRecognizedLanguage(languageTag)) {
            return valueFactory.createLiteral(literalValue, languageTag.toLowerCase().intern());
        }
        throw new LiteralUtilException("Could not normalize RFC3066 language tag");
    }

    @Override
    public String getKey() {
        return "org.eclipse.rdf4j.rio.languages.RFC3066";
    }
}

