/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.lmdb.config;

import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.util.ModelException;
import org.eclipse.rdf4j.model.util.Models;
import org.eclipse.rdf4j.sail.base.config.BaseSailConfig;
import org.eclipse.rdf4j.sail.config.SailConfigException;
import org.eclipse.rdf4j.sail.lmdb.config.LmdbStoreSchema;

public class LmdbStoreConfig
extends BaseSailConfig {
    public static final long TRIPLE_DB_SIZE = 0xA00000L;
    public static final long VALUE_DB_SIZE = 0xA00000L;
    public static final int VALUE_CACHE_SIZE = 512;
    public static final int VALUE_ID_CACHE_SIZE = 128;
    public static final int NAMESPACE_CACHE_SIZE = 64;
    public static final int NAMESPACE_ID_CACHE_SIZE = 32;
    private String tripleIndexes;
    private long tripleDBSize = -1L;
    private long valueDBSize = -1L;
    private boolean forceSync = false;
    private int valueCacheSize = -1;
    private int valueIDCacheSize = -1;
    private int namespaceCacheSize = -1;
    private int namespaceIDCacheSize = -1;
    private boolean autoGrow = true;

    public LmdbStoreConfig() {
        super("rdf4j:LmdbStore");
    }

    public LmdbStoreConfig(String tripleIndexes) {
        this();
        this.setTripleIndexes(tripleIndexes);
    }

    public LmdbStoreConfig(String tripleIndexes, boolean forceSync) {
        this(tripleIndexes);
        this.setForceSync(forceSync);
    }

    public String getTripleIndexes() {
        return this.tripleIndexes;
    }

    public LmdbStoreConfig setTripleIndexes(String tripleIndexes) {
        this.tripleIndexes = tripleIndexes;
        return this;
    }

    public LmdbStoreConfig setTripleDBSize(long tripleDBSize) {
        this.tripleDBSize = tripleDBSize;
        return this;
    }

    public long getTripleDBSize() {
        return this.tripleDBSize >= 0L ? this.tripleDBSize : 0xA00000L;
    }

    public LmdbStoreConfig setValueDBSize(long valueDBSize) {
        this.valueDBSize = valueDBSize;
        return this;
    }

    public long getValueDBSize() {
        return this.valueDBSize >= 0L ? this.valueDBSize : 0xA00000L;
    }

    public boolean getForceSync() {
        return this.forceSync;
    }

    public LmdbStoreConfig setForceSync(boolean forceSync) {
        this.forceSync = forceSync;
        return this;
    }

    public int getValueCacheSize() {
        return this.valueCacheSize >= 0 ? this.valueCacheSize : 512;
    }

    public LmdbStoreConfig setValueCacheSize(int valueCacheSize) {
        this.valueCacheSize = valueCacheSize;
        return this;
    }

    public int getValueIDCacheSize() {
        return this.valueIDCacheSize >= 0 ? this.valueIDCacheSize : 128;
    }

    public LmdbStoreConfig setValueIDCacheSize(int valueIDCacheSize) {
        this.valueIDCacheSize = valueIDCacheSize;
        return this;
    }

    public int getNamespaceCacheSize() {
        return this.namespaceCacheSize >= 0 ? this.namespaceCacheSize : 64;
    }

    public LmdbStoreConfig setNamespaceCacheSize(int namespaceCacheSize) {
        this.namespaceCacheSize = namespaceCacheSize;
        return this;
    }

    public int getNamespaceIDCacheSize() {
        return this.namespaceIDCacheSize >= 0 ? this.namespaceIDCacheSize : 32;
    }

    public LmdbStoreConfig setNamespaceIDCacheSize(int namespaceIDCacheSize) {
        this.namespaceIDCacheSize = namespaceIDCacheSize;
        return this;
    }

    public boolean getAutoGrow() {
        return this.autoGrow;
    }

    public LmdbStoreConfig setAutoGrow(boolean autoGrow) {
        this.autoGrow = autoGrow;
        return this;
    }

    @Override
    public Resource export(Model m) {
        Resource implNode = super.export(m);
        SimpleValueFactory vf = SimpleValueFactory.getInstance();
        m.setNamespace("ns", "http://rdf4j.org/config/sail/lmdb#");
        if (this.tripleIndexes != null) {
            m.add(implNode, LmdbStoreSchema.TRIPLE_INDEXES, vf.createLiteral(this.tripleIndexes), new Resource[0]);
        }
        if (this.tripleDBSize >= 0L) {
            m.add(implNode, LmdbStoreSchema.TRIPLE_DB_SIZE, vf.createLiteral(this.tripleDBSize), new Resource[0]);
        }
        if (this.valueDBSize >= 0L) {
            m.add(implNode, LmdbStoreSchema.VALUE_DB_SIZE, vf.createLiteral(this.valueDBSize), new Resource[0]);
        }
        if (this.forceSync) {
            m.add(implNode, LmdbStoreSchema.FORCE_SYNC, vf.createLiteral(true), new Resource[0]);
        }
        if (this.valueCacheSize >= 0) {
            m.add(implNode, LmdbStoreSchema.VALUE_CACHE_SIZE, vf.createLiteral(this.valueCacheSize), new Resource[0]);
        }
        if (this.valueIDCacheSize >= 0) {
            m.add(implNode, LmdbStoreSchema.VALUE_ID_CACHE_SIZE, vf.createLiteral(this.valueIDCacheSize), new Resource[0]);
        }
        if (this.namespaceCacheSize >= 0) {
            m.add(implNode, LmdbStoreSchema.NAMESPACE_CACHE_SIZE, vf.createLiteral(this.namespaceCacheSize), new Resource[0]);
        }
        if (this.namespaceIDCacheSize >= 0) {
            m.add(implNode, LmdbStoreSchema.NAMESPACE_ID_CACHE_SIZE, vf.createLiteral(this.namespaceIDCacheSize), new Resource[0]);
        }
        if (!this.autoGrow) {
            m.add(implNode, LmdbStoreSchema.AUTO_GROW, vf.createLiteral(false), new Resource[0]);
        }
        return implNode;
    }

    @Override
    public void parse(Model m, Resource implNode) throws SailConfigException {
        super.parse(m, implNode);
        try {
            Models.objectLiteral(m.getStatements(implNode, LmdbStoreSchema.TRIPLE_INDEXES, null, new Resource[0])).ifPresent(lit -> this.setTripleIndexes(lit.getLabel()));
            Models.objectLiteral(m.getStatements(implNode, LmdbStoreSchema.TRIPLE_DB_SIZE, null, new Resource[0])).ifPresent(lit -> {
                try {
                    this.setTripleDBSize(lit.longValue());
                }
                catch (NumberFormatException e) {
                    throw new SailConfigException("Long value required for " + LmdbStoreSchema.TRIPLE_DB_SIZE + " property, found " + lit);
                }
            });
            Models.objectLiteral(m.getStatements(implNode, LmdbStoreSchema.VALUE_DB_SIZE, null, new Resource[0])).ifPresent(lit -> {
                try {
                    this.setValueDBSize(lit.longValue());
                }
                catch (NumberFormatException e) {
                    throw new SailConfigException("Long value required for " + LmdbStoreSchema.VALUE_DB_SIZE + " property, found " + lit);
                }
            });
            Models.objectLiteral(m.getStatements(implNode, LmdbStoreSchema.FORCE_SYNC, null, new Resource[0])).ifPresent(lit -> {
                try {
                    this.setForceSync(lit.booleanValue());
                }
                catch (IllegalArgumentException e) {
                    throw new SailConfigException("Boolean value required for " + LmdbStoreSchema.FORCE_SYNC + " property, found " + lit);
                }
            });
            Models.objectLiteral(m.getStatements(implNode, LmdbStoreSchema.VALUE_CACHE_SIZE, null, new Resource[0])).ifPresent(lit -> {
                try {
                    this.setValueCacheSize(lit.intValue());
                }
                catch (NumberFormatException e) {
                    throw new SailConfigException("Integer value required for " + LmdbStoreSchema.VALUE_CACHE_SIZE + " property, found " + lit);
                }
            });
            Models.objectLiteral(m.getStatements(implNode, LmdbStoreSchema.VALUE_ID_CACHE_SIZE, null, new Resource[0])).ifPresent(lit -> {
                try {
                    this.setValueIDCacheSize(lit.intValue());
                }
                catch (NumberFormatException e) {
                    throw new SailConfigException("Integer value required for " + LmdbStoreSchema.VALUE_ID_CACHE_SIZE + " property, found " + lit);
                }
            });
            Models.objectLiteral(m.getStatements(implNode, LmdbStoreSchema.NAMESPACE_CACHE_SIZE, null, new Resource[0])).ifPresent(lit -> {
                try {
                    this.setNamespaceCacheSize(lit.intValue());
                }
                catch (NumberFormatException e) {
                    throw new SailConfigException("Integer value required for " + LmdbStoreSchema.NAMESPACE_CACHE_SIZE + " property, found " + lit);
                }
            });
            Models.objectLiteral(m.getStatements(implNode, LmdbStoreSchema.NAMESPACE_ID_CACHE_SIZE, null, new Resource[0])).ifPresent(lit -> {
                try {
                    this.setNamespaceIDCacheSize(lit.intValue());
                }
                catch (NumberFormatException e) {
                    throw new SailConfigException("Integer value required for " + LmdbStoreSchema.NAMESPACE_ID_CACHE_SIZE + " property, found " + lit);
                }
            });
            Models.objectLiteral(m.getStatements(implNode, LmdbStoreSchema.AUTO_GROW, null, new Resource[0])).ifPresent(lit -> {
                try {
                    this.setAutoGrow(lit.booleanValue());
                }
                catch (IllegalArgumentException e) {
                    throw new SailConfigException("Boolean value required for " + LmdbStoreSchema.AUTO_GROW + " property, found " + lit);
                }
            });
        }
        catch (ModelException e) {
            throw new SailConfigException(e.getMessage(), e);
        }
    }
}

