/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sparqlbuilder.constraint;

import org.eclipse.rdf4j.sparqlbuilder.constraint.Expression;
import org.eclipse.rdf4j.sparqlbuilder.constraint.SparqlAggregate;
import org.eclipse.rdf4j.sparqlbuilder.util.SparqlBuilderUtils;

public class Aggregate
extends Expression<Aggregate> {
    private static final String DISTINCT = "DISTINCT";
    private static final Object SEPARATOR = "SEPARATOR";
    private String separator;
    private boolean isDistinct = false;
    private boolean countAll = false;

    Aggregate(SparqlAggregate aggregate) {
        super(aggregate);
    }

    public Aggregate distinct() {
        return this.distinct(true);
    }

    public Aggregate distinct(boolean isDistinct) {
        this.isDistinct = isDistinct;
        return this;
    }

    public Aggregate countAll() {
        return this.countAll(true);
    }

    public Aggregate countAll(boolean countAll) {
        this.countAll = countAll;
        return this;
    }

    public Aggregate separator(String separator) {
        this.separator = separator;
        return this;
    }

    @Override
    public String getQueryString() {
        StringBuilder aggregate = new StringBuilder();
        StringBuilder params = new StringBuilder();
        aggregate.append(this.operator.getQueryString());
        if (this.isDistinct) {
            params.append(DISTINCT).append(" ");
        }
        if (this.operator == SparqlAggregate.COUNT && this.countAll) {
            params.append("*");
        } else {
            params.append(super.getQueryString());
        }
        if (this.operator == SparqlAggregate.GROUP_CONCAT && this.separator != null) {
            params.append(" ").append(";").append(" ").append(SEPARATOR).append(" ").append("=").append(" ").append(this.separator);
        }
        return aggregate.append(SparqlBuilderUtils.getParenthesizedString(params.toString())).toString();
    }
}

