/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated.evaluation;

import java.util.List;
import java.util.function.Supplier;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.federated.algebra.StatementSource;
import org.eclipse.rdf4j.federated.evaluation.iterator.FedXZeroLengthPathIteration;
import org.eclipse.rdf4j.federated.structures.QueryInfo;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.query.algebra.evaluation.EvaluationStrategy;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryEvaluationStep;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryValueEvaluationStep;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.QueryEvaluationContext;

public final class FedXZeroLengthPathEvaluationStep
implements QueryEvaluationStep {
    private final Var subjectVar;
    private final Var objVar;
    private final Var contextVar;
    private final QueryValueEvaluationStep subPrep;
    private final QueryValueEvaluationStep objPrep;
    private final EvaluationStrategy strategy;
    private final QueryEvaluationContext context;
    private final Supplier<List<StatementSource>> statementSources;
    private final Supplier<QueryInfo> queryInfo;

    public FedXZeroLengthPathEvaluationStep(Var subjectVar, Var objVar, Var contextVar, QueryValueEvaluationStep subPrep, QueryValueEvaluationStep objPrep, EvaluationStrategy strategy, QueryEvaluationContext context, Supplier<List<StatementSource>> statementSources, Supplier<QueryInfo> queryInfo) {
        this.subjectVar = subjectVar;
        this.objVar = objVar;
        this.contextVar = contextVar;
        this.subPrep = subPrep;
        this.objPrep = objPrep;
        this.strategy = strategy;
        this.context = context;
        this.statementSources = statementSources;
        this.queryInfo = queryInfo;
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(BindingSet bindings) {
        Value subj = null;
        try {
            subj = this.subPrep.evaluate(bindings);
        }
        catch (QueryEvaluationException queryEvaluationException) {
            // empty catch block
        }
        Value obj = null;
        try {
            obj = this.objPrep.evaluate(bindings);
        }
        catch (QueryEvaluationException queryEvaluationException) {
            // empty catch block
        }
        if (subj != null && obj != null && !subj.equals(obj)) {
            return EMPTY_ITERATION;
        }
        return this.getZeroLengthPathIterator(bindings, this.subjectVar, this.objVar, this.contextVar, subj, obj, this.context);
    }

    protected FedXZeroLengthPathIteration getZeroLengthPathIterator(BindingSet bindings, Var subjectVar, Var objVar, Var contextVar, Value subj, Value obj, QueryEvaluationContext context) {
        return new FedXZeroLengthPathIteration(this.strategy, subjectVar, objVar, subj, obj, contextVar, bindings, context, this.queryInfo.get(), this.statementSources.get());
    }
}

