/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.rio.datatypes;

import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.datatypes.XMLDatatypeUtil;
import org.eclipse.rdf4j.model.util.LiteralUtilException;
import org.eclipse.rdf4j.rio.DatatypeHandler;

public class XMLSchemaDatatypeHandler
implements DatatypeHandler {
    public boolean isRecognizedDatatype(IRI datatypeUri) {
        if (datatypeUri == null) {
            throw new NullPointerException("Datatype URI cannot be null");
        }
        return XMLDatatypeUtil.isBuiltInDatatype((IRI)datatypeUri);
    }

    public boolean verifyDatatype(String literalValue, IRI datatypeUri) throws LiteralUtilException {
        if (this.isRecognizedDatatype(datatypeUri)) {
            if (literalValue == null) {
                throw new NullPointerException("Literal value cannot be null");
            }
            return XMLDatatypeUtil.isValidValue((String)literalValue, (IRI)datatypeUri);
        }
        throw new LiteralUtilException("Could not verify XMLSchema literal");
    }

    public Literal normalizeDatatype(String literalValue, IRI datatypeUri, ValueFactory valueFactory) throws LiteralUtilException {
        if (this.isRecognizedDatatype(datatypeUri)) {
            if (literalValue == null) {
                throw new NullPointerException("Literal value cannot be null");
            }
            try {
                return valueFactory.createLiteral(XMLDatatypeUtil.normalize((String)literalValue, (IRI)datatypeUri), datatypeUri);
            }
            catch (IllegalArgumentException e) {
                throw new LiteralUtilException("Could not normalise XMLSchema literal", (Throwable)e);
            }
        }
        throw new LiteralUtilException("Could not normalise XMLSchema literal");
    }

    public String getKey() {
        return "org.eclipse.rdf4j.rio.datatypes.xmlschema";
    }
}

