/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.DASH;
import org.eclipse.rdf4j.sail.shacl.SourceConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ValidationSettings;
import org.eclipse.rdf4j.sail.shacl.ast.ShaclAstLists;
import org.eclipse.rdf4j.sail.shacl.ast.SparqlFragment;
import org.eclipse.rdf4j.sail.shacl.ast.StatementMatcher;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.AbstractConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.ConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.paths.Path;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.BulkedExternalLeftOuterJoin;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.EmptyNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.GroupByFilter;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNodeProvider;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ShiftToPropertyShape;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.TrimToTarget;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.UnBufferedPlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.UnionNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.Unique;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationTuple;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValueInFilter;
import org.eclipse.rdf4j.sail.shacl.ast.targets.EffectiveTarget;
import org.eclipse.rdf4j.sail.shacl.wrapper.data.ConnectionsGroup;
import org.eclipse.rdf4j.sail.shacl.wrapper.data.RdfsSubClassOfReasoner;
import org.eclipse.rdf4j.sail.shacl.wrapper.shape.ShapeSource;

public class DashHasValueInConstraintComponent
extends AbstractConstraintComponent {
    final Set<Value> hasValueIn;

    public DashHasValueInConstraintComponent(ShapeSource shapeSource, Resource hasValueIn) {
        super(hasValueIn);
        this.hasValueIn = Collections.unmodifiableSet(new LinkedHashSet<Value>(ShaclAstLists.toList(shapeSource, hasValueIn, Value.class)));
    }

    public DashHasValueInConstraintComponent(DashHasValueInConstraintComponent dashHasValueInConstraintComponent) {
        super(dashHasValueInConstraintComponent.getId());
        this.hasValueIn = dashHasValueInConstraintComponent.hasValueIn;
    }

    @Override
    public void toModel(Resource subject, IRI predicate, Model model, Set<Resource> cycleDetection) {
        model.add(subject, DASH.hasValueIn, (Value)this.getId(), new Resource[0]);
        if (!model.contains(this.getId(), null, null, new Resource[0])) {
            ShaclAstLists.listToRdf(this.hasValueIn, this.getId(), model);
        }
    }

    @Override
    public SourceConstraintComponent getConstraintComponent() {
        return SourceConstraintComponent.HasValueInConstraintComponent;
    }

    @Override
    public ConstraintComponent deepClone() {
        return new DashHasValueInConstraintComponent(this);
    }

    @Override
    public PlanNode generateTransactionalValidationPlan(ConnectionsGroup connectionsGroup, ValidationSettings validationSettings, PlanNodeProvider overrideTargetNode, ConstraintComponent.Scope scope) {
        StatementMatcher.StableRandomVariableProvider stableRandomVariableProvider = new StatementMatcher.StableRandomVariableProvider();
        EffectiveTarget target = this.getTargetChain().getEffectiveTarget(scope, connectionsGroup.getRdfsSubClassOfReasoner(), stableRandomVariableProvider);
        if (scope == ConstraintComponent.Scope.propertyShape) {
            PlanNode addedTargets;
            Path path = this.getTargetChain().getPath().get();
            if (overrideTargetNode != null) {
                addedTargets = target.extend(overrideTargetNode.getPlanNode(), connectionsGroup, validationSettings.getDataGraph(), scope, EffectiveTarget.Extend.right, false, null);
            } else {
                addedTargets = target.getPlanNode(connectionsGroup, validationSettings.getDataGraph(), scope, true, null);
                PlanNode addedByPath = path.getAllAdded(connectionsGroup, validationSettings.getDataGraph(), null);
                addedByPath = target.getTargetFilter(connectionsGroup, validationSettings.getDataGraph(), Unique.getInstance(new TrimToTarget(addedByPath), false));
                addedByPath = target.extend(addedByPath, connectionsGroup, validationSettings.getDataGraph(), scope, EffectiveTarget.Extend.left, false, null);
                addedTargets = UnionNode.getInstance(addedByPath, addedTargets);
                addedTargets = Unique.getInstance(addedTargets, false);
            }
            BulkedExternalLeftOuterJoin joined = new BulkedExternalLeftOuterJoin(addedTargets, connectionsGroup.getBaseConnection(), validationSettings.getDataGraph(), path.getTargetQueryFragment(new StatementMatcher.Variable<String>("a"), new StatementMatcher.Variable<String>("c"), connectionsGroup.getRdfsSubClassOfReasoner(), stableRandomVariableProvider, Set.of()), b -> new ValidationTuple(b.getValue("a"), b.getValue("c"), scope, true, validationSettings.getDataGraph()));
            GroupByFilter invalidTargets = new GroupByFilter(joined, group -> group.stream().map(ValidationTuple::getValue).noneMatch(this.hasValueIn::contains));
            return Unique.getInstance(new TrimToTarget(invalidTargets), false);
        }
        if (scope == ConstraintComponent.Scope.nodeShape) {
            PlanNode addedTargets = overrideTargetNode != null ? target.extend(overrideTargetNode.getPlanNode(), connectionsGroup, validationSettings.getDataGraph(), scope, EffectiveTarget.Extend.right, false, null) : target.getPlanNode(connectionsGroup, validationSettings.getDataGraph(), scope, false, null);
            PlanNode falseNode = new ValueInFilter(addedTargets, this.hasValueIn).getFalseNode(UnBufferedPlanNode.class);
            return falseNode;
        }
        throw new UnsupportedOperationException("Unknown scope: " + scope);
    }

    @Override
    public PlanNode getAllTargetsPlan(ConnectionsGroup connectionsGroup, Resource[] dataGraph, ConstraintComponent.Scope scope, StatementMatcher.StableRandomVariableProvider stableRandomVariableProvider, ValidationSettings validationSettings) {
        if (scope == ConstraintComponent.Scope.propertyShape) {
            PlanNode allTargetsPlan = this.getTargetChain().getEffectiveTarget(ConstraintComponent.Scope.nodeShape, connectionsGroup.getRdfsSubClassOfReasoner(), stableRandomVariableProvider).getPlanNode(connectionsGroup, dataGraph, ConstraintComponent.Scope.nodeShape, true, null);
            return Unique.getInstance(new ShiftToPropertyShape(allTargetsPlan), true);
        }
        return EmptyNode.getInstance();
    }

    @Override
    public SparqlFragment buildSparqlValidNodes_rsx_targetShape(StatementMatcher.Variable<Value> subject, StatementMatcher.Variable<Value> object, RdfsSubClassOfReasoner rdfsSubClassOfReasoner, ConstraintComponent.Scope scope, StatementMatcher.StableRandomVariableProvider stableRandomVariableProvider) {
        if (scope == ConstraintComponent.Scope.propertyShape) {
            Path path = this.getTargetChain().getPath().get();
            ArrayList<StatementMatcher> statementMatchers = new ArrayList<StatementMatcher>();
            String sparql = this.hasValueIn.stream().map(value -> {
                SparqlFragment targetQueryFragment = path.getTargetQueryFragment(subject, object, rdfsSubClassOfReasoner, stableRandomVariableProvider, Set.of());
                List<StatementMatcher> optimizedStatementMatchers = StatementMatcher.swap(targetQueryFragment.getStatementMatchers(), object, new StatementMatcher.Variable<Value>((Value)value));
                statementMatchers.addAll(optimizedStatementMatchers);
                return "BIND(" + this.stringRepresentationOfValue((Value)value) + " as " + object.asSparqlVariable() + ")\n" + targetQueryFragment.getFragment();
            }).collect(Collectors.joining("} UNION {\n#VALUES_INJECTION_POINT#\n", "{\n#VALUES_INJECTION_POINT#\n", "}"));
            return SparqlFragment.bgp(List.of(), sparql, statementMatchers, null);
        }
        String sparql = this.hasValueIn.stream().map(value -> {
            if (value.isIRI()) {
                return object.asSparqlVariable() + " = <" + value + ">";
            }
            if (value.isLiteral()) {
                return object.asSparqlVariable() + " = " + value;
            }
            throw new UnsupportedOperationException("value was unsupported type: " + value.getClass().getSimpleName());
        }).reduce((a, b) -> a + " || " + b).orElseThrow(() -> new IllegalStateException("hasValueIn was empty"));
        return SparqlFragment.filterCondition(List.of(), sparql, List.of());
    }

    @Override
    public List<Literal> getDefaultMessage() {
        return List.of();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DashHasValueInConstraintComponent that = (DashHasValueInConstraintComponent)o;
        return this.hasValueIn.equals(that.hasValueIn);
    }

    public int hashCode() {
        return this.hasValueIn.hashCode() + "DashHasValueInConstraintComponent".hashCode();
    }
}

