/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.planNodes;

import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Value;

public class Formatter {
    public static String prefix(Value in) {
        if (in == null) {
            return "null";
        }
        if (in instanceof IRI) {
            String namespace = ((IRI)in).getNamespace();
            if (namespace.equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#")) {
                return in.toString().replace("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "rdf:");
            }
            if (namespace.equals("http://www.w3.org/2000/01/rdf-schema#")) {
                return in.toString().replace("http://www.w3.org/2000/01/rdf-schema#", "rdfs:");
            }
            if (namespace.equals("http://www.w3.org/ns/shacl#")) {
                return in.toString().replace("http://www.w3.org/ns/shacl#", "sh:");
            }
            if (namespace.equals("http://example.com/ns#")) {
                return in.toString().replace("http://example.com/ns#", "ex:");
            }
            if (namespace.equals("http://www.w3.org/2001/XMLSchema#")) {
                return in.toString().replace("http://www.w3.org/2001/XMLSchema#", "xsd:");
            }
        }
        return in.toString();
    }

    public static String formatSparqlQuery(String query) {
        StringBuilder stringBuilder = new StringBuilder();
        query = query.replace(" .", " .\n");
        query = query.replace("\n\n", "\n");
        String[] split = query.split("\n");
        int indent = 0;
        for (String s : split) {
            if ((s = s.trim()).startsWith("}")) {
                --indent;
            }
            for (int i = 0; i < indent; ++i) {
                stringBuilder.append("\t");
            }
            stringBuilder.append(s).append("\n");
            if (!s.endsWith("{")) continue;
            ++indent;
        }
        return stringBuilder.toString().trim();
    }
}

