/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.inferencer.fc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.time.StopWatch;
import org.eclipse.rdf4j.common.transaction.IsolationLevel;
import org.eclipse.rdf4j.common.transaction.IsolationLevels;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.RDFS;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.sail.NotifyingSail;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.helpers.NotifyingSailWrapper;
import org.eclipse.rdf4j.sail.inferencer.InferencerConnection;
import org.eclipse.rdf4j.sail.inferencer.fc.SchemaCachingRDFSInferencerConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaCachingRDFSInferencer
extends NotifyingSailWrapper {
    private static final Logger logger = LoggerFactory.getLogger(SchemaCachingRDFSInferencer.class);
    private static final Resource[] DEFAULT_CONTEXT = new Resource[]{null};
    Repository predefinedSchema;
    private final ReentrantLock exclusiveWriteLock = new ReentrantLock(true);
    boolean useAllRdfsRules = true;
    protected volatile boolean useInferredToCreateSchema;
    private Collection<Resource> properties = new HashSet<Resource>();
    private Collection<Resource> types = new HashSet<Resource>();
    private Collection<Statement> subClassOfStatements = new HashSet<Statement>();
    private Collection<Statement> subPropertyOfStatements = new HashSet<Statement>();
    private Collection<Statement> rangeStatements = new HashSet<Statement>();
    private Collection<Statement> domainStatements = new HashSet<Statement>();
    private Map<Resource, Set<Resource>> calculatedTypes = new HashMap<Resource, Set<Resource>>();
    private Map<Resource, Set<Resource>> calculatedProperties = new HashMap<Resource, Set<Resource>>();
    private Map<Resource, Set<Resource>> calculatedRange = new HashMap<Resource, Set<Resource>>();
    private Map<Resource, Set<Resource>> calculatedDomain = new HashMap<Resource, Set<Resource>>();
    private boolean sharedSchema;
    private boolean addInferredStatementsToDefaultContext = false;
    private volatile boolean unmodifiable;

    public SchemaCachingRDFSInferencer() {
        this.predefinedSchema = null;
    }

    public SchemaCachingRDFSInferencer(NotifyingSail data) {
        super(data);
        this.predefinedSchema = null;
    }

    public SchemaCachingRDFSInferencer(NotifyingSail data, Repository predefinedSchema) {
        super(data);
        this.predefinedSchema = predefinedSchema;
    }

    public SchemaCachingRDFSInferencer(NotifyingSail data, boolean useAllRdfsRules) {
        super(data);
        this.predefinedSchema = null;
        this.useAllRdfsRules = useAllRdfsRules;
    }

    public SchemaCachingRDFSInferencer(NotifyingSail data, Repository predefinedSchema, boolean useAllRdfsRules) {
        super(data);
        this.predefinedSchema = predefinedSchema;
        this.useAllRdfsRules = useAllRdfsRules;
    }

    void clearInferenceTables() {
        logger.debug("Clear inference tables");
        this.acquireExclusiveWriteLock();
        this.properties.clear();
        this.types.clear();
        this.subClassOfStatements.clear();
        this.subPropertyOfStatements.clear();
        this.rangeStatements.clear();
        this.domainStatements.clear();
        this.calculatedTypes.clear();
        this.calculatedProperties.clear();
        this.calculatedRange.clear();
        this.calculatedDomain.clear();
    }

    void acquireExclusiveWriteLock() {
        if (this.exclusiveWriteLock.isHeldByCurrentThread()) {
            return;
        }
        try {
            this.exclusiveWriteLock.lockInterruptibly();
        }
        catch (InterruptedException e) {
            throw new SailException((Throwable)e);
        }
    }

    void releaseExclusiveWriteLock() {
        while (this.exclusiveWriteLock.isHeldByCurrentThread()) {
            this.exclusiveWriteLock.unlock();
        }
    }

    public void init() throws SailException {
        super.init();
        if (this.sharedSchema) {
            return;
        }
        try (SchemaCachingRDFSInferencerConnection conn = this.getConnection();){
            conn.begin();
            conn.addAxiomStatements();
            List<Object> tboxStatments = new ArrayList();
            if (this.predefinedSchema != null) {
                logger.debug("Initializing with a predefined schema.");
                try (RepositoryConnection schemaConnection = this.predefinedSchema.getConnection();){
                    schemaConnection.begin();
                    try (Stream stream = schemaConnection.getStatements(null, null, null, new Resource[0]).stream();){
                        tboxStatments = stream.peek(conn::processForSchemaCache).collect(Collectors.toList());
                    }
                    schemaConnection.commit();
                }
            }
            this.calculateInferenceMaps(conn, true);
            if (this.predefinedSchema != null) {
                tboxStatments.forEach(statement -> conn.addStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), statement.getContext()));
            }
            conn.commit();
        }
    }

    public SchemaCachingRDFSInferencerConnection getConnection() throws SailException {
        InferencerConnection e = (InferencerConnection)super.getConnection();
        return new SchemaCachingRDFSInferencerConnection(this, e);
    }

    public ValueFactory getValueFactory() {
        return this.getBaseSail().getValueFactory();
    }

    public static SchemaCachingRDFSInferencer fastInstantiateFrom(SchemaCachingRDFSInferencer sailToInstantiateFrom, NotifyingSail store) {
        return SchemaCachingRDFSInferencer.fastInstantiateFrom(sailToInstantiateFrom, store, true);
    }

    public static SchemaCachingRDFSInferencer fastInstantiateFrom(SchemaCachingRDFSInferencer sailToInstantiateFrom, NotifyingSail store, boolean useAllRdfsRules) {
        sailToInstantiateFrom.getConnection().close();
        sailToInstantiateFrom.makeUnmodifiable();
        SchemaCachingRDFSInferencer ret = new SchemaCachingRDFSInferencer(store, sailToInstantiateFrom.predefinedSchema, useAllRdfsRules);
        ret.sharedSchema = true;
        sailToInstantiateFrom.calculatedTypes.forEach((key, value) -> value.forEach(v -> {
            if (!ret.calculatedTypes.containsKey(key)) {
                ret.calculatedTypes.put((Resource)key, (Set<Resource>)new HashSet<Resource>(Set.of(v)));
            } else {
                ret.calculatedTypes.get(key).add((Resource)v);
            }
        }));
        sailToInstantiateFrom.calculatedProperties.forEach((key, value) -> value.forEach(v -> {
            if (!ret.calculatedProperties.containsKey(key)) {
                ret.calculatedProperties.put((Resource)key, (Set<Resource>)new HashSet<Resource>(Set.of(v)));
            } else {
                ret.calculatedProperties.get(key).add((Resource)v);
            }
        }));
        sailToInstantiateFrom.calculatedRange.forEach((key, value) -> value.forEach(v -> {
            if (!ret.calculatedRange.containsKey(key)) {
                ret.calculatedRange.put((Resource)key, (Set<Resource>)new HashSet<Resource>(Set.of(v)));
            } else {
                ret.calculatedRange.get(key).add((Resource)v);
            }
        }));
        sailToInstantiateFrom.calculatedDomain.forEach((key, value) -> value.forEach(v -> {
            if (!ret.calculatedDomain.containsKey(key)) {
                ret.calculatedDomain.put((Resource)key, (Set<Resource>)new HashSet<Resource>(Set.of(v)));
            } else {
                ret.calculatedDomain.get(key).add((Resource)v);
            }
        }));
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeUnmodifiable() {
        if (this.unmodifiable) {
            return;
        }
        SchemaCachingRDFSInferencer schemaCachingRDFSInferencer = this;
        synchronized (schemaCachingRDFSInferencer) {
            if (!this.unmodifiable) {
                this.unmodifiable = true;
                this.properties = this.properties.isEmpty() ? Collections.emptySet() : Set.copyOf(this.properties);
                this.types = this.types.isEmpty() ? Collections.emptySet() : Set.copyOf(this.types);
                this.subClassOfStatements = this.subClassOfStatements.isEmpty() ? Collections.emptySet() : Set.copyOf(this.subClassOfStatements);
                this.subPropertyOfStatements = this.subPropertyOfStatements.isEmpty() ? Collections.emptySet() : Set.copyOf(this.subPropertyOfStatements);
                this.rangeStatements = this.rangeStatements.isEmpty() ? Collections.emptySet() : Set.copyOf(this.rangeStatements);
                this.domainStatements = this.domainStatements.isEmpty() ? Collections.emptySet() : Set.copyOf(this.domainStatements);
                this.calculatedTypes.replaceAll((k, v) -> Set.copyOf(v));
                this.calculatedProperties.replaceAll((k, v) -> Set.copyOf(v));
                this.calculatedRange.replaceAll((k, v) -> Set.copyOf(v));
                this.calculatedDomain.replaceAll((k, v) -> Set.copyOf(v));
                this.calculatedTypes = this.calculatedTypes.isEmpty() ? Collections.emptyMap() : Map.copyOf(this.calculatedTypes);
                this.calculatedProperties = this.calculatedProperties.isEmpty() ? Collections.emptyMap() : Map.copyOf(this.calculatedProperties);
                this.calculatedRange = this.calculatedRange.isEmpty() ? Collections.emptyMap() : Map.copyOf(this.calculatedRange);
                this.calculatedDomain = this.calculatedDomain.isEmpty() ? Collections.emptyMap() : Map.copyOf(this.calculatedDomain);
            }
        }
    }

    void calculateInferenceMaps(SchemaCachingRDFSInferencerConnection conn, boolean addInferred) {
        logger.debug("Calculate inference maps.");
        this.calculateSubClassOf(this.subClassOfStatements);
        this.properties.forEach(predicate -> {
            if (addInferred) {
                conn.addInferredStatementInternal((Resource)predicate, RDF.TYPE, (Value)RDF.PROPERTY, DEFAULT_CONTEXT);
            }
            this.calculatedProperties.put((Resource)predicate, ConcurrentHashMap.newKeySet());
        });
        this.calculateSubPropertyOf(this.subPropertyOfStatements);
        this.calculateDomainAndRange(this.rangeStatements, this.calculatedRange);
        this.calculateDomainAndRange(this.domainStatements, this.calculatedDomain);
        if (addInferred) {
            logger.debug("Add inferred rdfs:subClassOf statements");
            this.calculatedTypes.forEach((subClass, superClasses) -> superClasses.forEach(superClass -> conn.addInferredStatementInternal((Resource)subClass, RDFS.SUBCLASSOF, (Value)superClass, DEFAULT_CONTEXT)));
        }
        if (addInferred) {
            logger.debug("Add inferred rdfs:subPropertyOf statements");
            this.calculatedProperties.forEach((sub, sups) -> sups.forEach(sup -> conn.addInferredStatementInternal((Resource)sub, RDFS.SUBPROPERTYOF, (Value)sup, DEFAULT_CONTEXT)));
        }
    }

    void addSubClassOfStatement(Statement st) {
        if (!st.getObject().isResource()) {
            throw new SailException("Object of rdfs:subClassOf should be a resource! " + st);
        }
        this.subClassOfStatements.add(st);
        this.types.add(st.getSubject());
        this.types.add((Resource)st.getObject());
    }

    void addSubPropertyOfStatement(Statement st) {
        if (!st.getObject().isResource()) {
            throw new SailException("Object of rdfs:subPropertyOf should be a resource! " + st);
        }
        this.subPropertyOfStatements.add(st);
        this.properties.add(st.getSubject());
        this.properties.add((Resource)st.getObject());
    }

    void addRangeStatement(Statement st) {
        if (!st.getObject().isResource()) {
            throw new SailException("Object of rdfs:range should be a resource! " + st);
        }
        this.rangeStatements.add(st);
        this.properties.add(st.getSubject());
        this.types.add((Resource)st.getObject());
    }

    void addDomainStatement(Statement st) {
        if (!st.getObject().isResource()) {
            throw new SailException("Object of rdfs:domain should be a resource! " + st);
        }
        this.domainStatements.add(st);
        this.properties.add(st.getSubject());
        this.types.add((Resource)st.getObject());
    }

    boolean hasType(Resource r) {
        return this.types.contains(r);
    }

    void addType(Resource r) {
        this.types.add(r);
    }

    boolean hasProperty(Resource property) {
        return this.properties.contains(property);
    }

    void addProperty(Resource property) {
        this.properties.add(property);
    }

    Set<Resource> resolveTypes(Resource value) {
        return this.calculatedTypes.getOrDefault(value, Collections.emptySet());
    }

    Set<Resource> resolveProperties(Resource predicate) {
        return this.calculatedProperties.getOrDefault(predicate, Collections.emptySet());
    }

    Set<Resource> resolveRangeTypes(IRI predicate) {
        return this.calculatedRange.getOrDefault(predicate, Collections.emptySet());
    }

    Set<Resource> resolveDomainTypes(IRI predicate) {
        return this.calculatedDomain.getOrDefault(predicate, Collections.emptySet());
    }

    private void calculateSubClassOf(Collection<Statement> subClassOfStatements) {
        logger.debug("Calculate rdfs:subClassOf inference map.");
        StopWatch stopWatch = null;
        if (logger.isDebugEnabled()) {
            stopWatch = StopWatch.createStarted();
        }
        logger.debug("Fill initial maps");
        this.types.forEach(type -> {
            if (!this.calculatedTypes.containsKey(type)) {
                ConcurrentHashMap.KeySetView values = ConcurrentHashMap.newKeySet();
                values.add(RDFS.RESOURCE);
                values.add(type);
                this.calculatedTypes.put((Resource)type, values);
            } else {
                this.calculatedTypes.get(type).add((Resource)type);
            }
        });
        subClassOfStatements.forEach(s -> {
            if (!s.getObject().isResource()) {
                throw new SailException("Object of rdfs:subClassOf should be a resource! " + s);
            }
            Resource subClass = s.getSubject();
            Resource superClass = (Resource)s.getObject();
            if (!this.calculatedTypes.containsKey(subClass)) {
                ConcurrentHashMap.KeySetView values = ConcurrentHashMap.newKeySet();
                values.add(RDFS.RESOURCE);
                values.add(subClass);
                values.add(superClass);
                this.calculatedTypes.put(subClass, values);
            } else {
                this.calculatedTypes.get(subClass).add(superClass);
            }
        });
        logger.debug("Run until fixed point");
        long prevSize = 0L;
        long newSize = -1L;
        while (prevSize != newSize) {
            prevSize = newSize;
            newSize = this.getStream(this.calculatedTypes).map(Map.Entry::getValue).mapToInt(value -> {
                ArrayList<Set<Resource>> forwardChainedSets = new ArrayList<Set<Resource>>(value.size());
                for (Resource resource : value) {
                    if (resource == RDFS.RESOURCE) continue;
                    forwardChainedSets.add(this.resolveTypes(resource));
                }
                this.addAll((Set<Resource>)value, (List<Set<Resource>>)forwardChainedSets);
                return value.size();
            }).sum();
            logger.debug("Fixed point iteration new size {}", (Object)newSize);
        }
        if (logger.isDebugEnabled()) {
            assert (stopWatch != null);
            stopWatch.stop();
            logger.debug("Took: " + stopWatch);
        }
    }

    private Stream<Map.Entry<Resource, Set<Resource>>> getStream(Map<Resource, Set<Resource>> map) {
        Set<Map.Entry<Resource, Set<Resource>>> entries = map.entrySet();
        if (entries.size() > 100) {
            return entries.parallelStream().peek(ent -> {
                assert (ent.getValue() instanceof ConcurrentHashMap.KeySetView);
            });
        }
        return entries.stream();
    }

    private void calculateSubPropertyOf(Collection<Statement> subPropertyOfStatemenets) {
        logger.debug("Calculate rdfs:subPropertyOf inference map.");
        StopWatch stopWatch = null;
        if (logger.isDebugEnabled()) {
            stopWatch = StopWatch.createStarted();
        }
        subPropertyOfStatemenets.forEach(s -> {
            if (!s.getObject().isResource()) {
                throw new SailException("Object of rdfs:subPropertyOf should be a resource! " + s);
            }
            Resource subProperty = s.getSubject();
            Resource superProperty = (Resource)s.getObject();
            if (!this.calculatedProperties.containsKey(subProperty)) {
                this.calculatedProperties.put(subProperty, ConcurrentHashMap.newKeySet());
            }
            if (!this.calculatedProperties.containsKey(superProperty)) {
                this.calculatedProperties.put(superProperty, ConcurrentHashMap.newKeySet());
            }
            this.calculatedProperties.get(subProperty).add(superProperty);
        });
        this.calculatedProperties.forEach((k, v) -> v.add(k));
        logger.debug("Run until fixed point");
        long prevSize = 0L;
        long newSize = -1L;
        while (prevSize != newSize) {
            prevSize = newSize;
            newSize = this.getStream(this.calculatedProperties).map(Map.Entry::getValue).mapToInt(value -> {
                ArrayList<Set<Resource>> forwardChainedSets = new ArrayList<Set<Resource>>(value.size());
                for (Resource resource : value) {
                    forwardChainedSets.add(this.resolveProperties(resource));
                }
                this.addAll((Set<Resource>)value, (List<Set<Resource>>)forwardChainedSets);
                return value.size();
            }).sum();
            logger.debug("Fixed point iteration new size {}", (Object)newSize);
        }
        if (logger.isDebugEnabled()) {
            assert (stopWatch != null);
            stopWatch.stop();
            logger.debug("Took: " + stopWatch);
        }
    }

    private void addAll(Set<Resource> res, List<Set<Resource>> from) {
        if (from.size() == 1) {
            Set<Resource> forwardChained = from.get(0);
            if (forwardChained.size() != res.size()) {
                res.addAll(forwardChained);
            }
        } else {
            for (Set<Resource> forwardChainedSet : from) {
                res.addAll(forwardChainedSet);
            }
        }
    }

    private void calculateDomainAndRange(Collection<Statement> rangeOrDomainStatements, Map<Resource, Set<Resource>> calculatedRangeOrDomain) {
        StopWatch stopWatch = null;
        if (logger.isDebugEnabled()) {
            stopWatch = StopWatch.createStarted();
        }
        logger.debug("Calculate rdfs:domain and rdfs:range inference map.");
        rangeOrDomainStatements.forEach(s -> {
            if (!s.getObject().isResource()) {
                throw new SailException("Object of rdfs:range or rdfs:domain should be a resource! " + s);
            }
            Resource predicate = s.getSubject();
            Resource object = (Resource)s.getObject();
            if (!this.calculatedProperties.containsKey(predicate)) {
                this.calculatedProperties.put(predicate, ConcurrentHashMap.newKeySet());
            }
            if (!calculatedRangeOrDomain.containsKey(predicate)) {
                calculatedRangeOrDomain.put(predicate, ConcurrentHashMap.newKeySet());
            }
            ((Set)calculatedRangeOrDomain.get(predicate)).add(object);
            if (!this.calculatedTypes.containsKey(object)) {
                this.calculatedTypes.put(object, ConcurrentHashMap.newKeySet());
            }
        });
        this.calculatedProperties.keySet().stream().filter(key -> !calculatedRangeOrDomain.containsKey(key)).forEach(key -> calculatedRangeOrDomain.put((Resource)key, ConcurrentHashMap.newKeySet()));
        logger.debug("Run until fixed point");
        long prevSize = 0L;
        long[] newSize = new long[]{-1L};
        while (prevSize != newSize[0]) {
            prevSize = newSize[0];
            newSize[0] = 0L;
            calculatedRangeOrDomain.forEach((key, value) -> {
                ArrayList resolvedBySubProperty = new ArrayList();
                this.resolveProperties((Resource)key).forEach(newPredicate -> {
                    Set iris = (Set)calculatedRangeOrDomain.get(newPredicate);
                    if (iris != null) {
                        resolvedBySubProperty.addAll(iris);
                    }
                });
                ArrayList resolvedBySubClass = new ArrayList();
                value.addAll(resolvedBySubProperty);
                value.stream().map(this::resolveTypes).forEach(resolvedBySubClass::addAll);
                value.addAll(resolvedBySubClass);
                newSize[0] = newSize[0] + (long)value.size();
            });
            logger.debug("Fixed point iteration new size {}", (Object)newSize[0]);
        }
        if (logger.isDebugEnabled()) {
            assert (stopWatch != null);
            stopWatch.stop();
            logger.debug("Took: " + stopWatch);
        }
    }

    public IsolationLevel getDefaultIsolationLevel() {
        IsolationLevel level = super.getDefaultIsolationLevel();
        if (level.isCompatibleWith((IsolationLevel)IsolationLevels.READ_COMMITTED)) {
            return level;
        }
        List supported = this.getSupportedIsolationLevels();
        return IsolationLevels.getCompatibleIsolationLevel((IsolationLevel)IsolationLevels.READ_COMMITTED, (List)supported);
    }

    public boolean isAddInferredStatementsToDefaultContext() {
        return this.addInferredStatementsToDefaultContext;
    }

    public void setAddInferredStatementsToDefaultContext(boolean addInferredStatementsToDefaultContext) {
        this.addInferredStatementsToDefaultContext = addInferredStatementsToDefaultContext;
    }

    boolean usesPredefinedSchema() {
        return this.predefinedSchema != null || this.sharedSchema;
    }
}

