/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.resultio.helpers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.BooleanQueryResultHandler;
import org.eclipse.rdf4j.query.QueryResultHandlerException;
import org.eclipse.rdf4j.query.TupleQueryResultHandler;
import org.eclipse.rdf4j.query.TupleQueryResultHandlerException;

public class QueryResultCollector
implements TupleQueryResultHandler,
BooleanQueryResultHandler {
    private boolean hasBooleanSet = false;
    private Boolean value = null;
    private boolean endQueryResultFound = false;
    private List<String> bindingNames = Collections.emptyList();
    private List<BindingSet> bindingSets = Collections.emptyList();
    private final List<String> links = new ArrayList<String>();

    public void handleBoolean(boolean value) throws QueryResultHandlerException {
        this.hasBooleanSet = true;
        this.value = value;
    }

    public void startQueryResult(List<String> bindingNames) throws TupleQueryResultHandlerException {
        this.endQueryResultFound = false;
        this.bindingNames = Collections.unmodifiableList(new ArrayList<String>(bindingNames));
        this.bindingSets = new ArrayList<BindingSet>();
    }

    public void handleSolution(BindingSet bindingSet) throws TupleQueryResultHandlerException {
        this.endQueryResultFound = false;
        this.bindingSets.add(bindingSet);
    }

    public void endQueryResult() throws TupleQueryResultHandlerException {
        this.endQueryResultFound = true;
        this.bindingSets = Collections.unmodifiableList(this.bindingSets);
    }

    public void handleLinks(List<String> linkUrls) throws QueryResultHandlerException {
        this.links.addAll(linkUrls);
    }

    public boolean getHandledBoolean() {
        return this.hasBooleanSet;
    }

    public boolean getBoolean() throws QueryResultHandlerException {
        if (!this.hasBooleanSet) {
            throw new QueryResultHandlerException("Did not collect a boolean value");
        }
        return this.value;
    }

    public boolean getHandledTuple() {
        return this.endQueryResultFound;
    }

    public List<String> getBindingNames() throws QueryResultHandlerException {
        if (!this.endQueryResultFound) {
            throw new QueryResultHandlerException("Did not successfully collect a tuple results set.");
        }
        return this.bindingNames;
    }

    public List<BindingSet> getBindingSets() throws QueryResultHandlerException {
        if (!this.endQueryResultFound) {
            throw new QueryResultHandlerException("Did not successfully collect a tuple results set.");
        }
        return this.bindingSets;
    }

    public List<String> getLinks() {
        return Collections.unmodifiableList(this.links);
    }
}

