/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.request.json;

import java.util.Date;
import org.apache.solr.client.solrj.request.json.JsonFacetMap;

public class RangeFacetMap
extends JsonFacetMap<RangeFacetMap> {
    public RangeFacetMap(String field, long start, long end, long gap) {
        super("range");
        if (field == null) {
            throw new IllegalArgumentException("Parameter 'field' must be non-null");
        }
        if (end < start) {
            throw new IllegalArgumentException("Parameter 'end' must be greater than parameter 'start'");
        }
        if (gap <= 0L) {
            throw new IllegalArgumentException("Parameter 'gap' must be a positive integer");
        }
        this.put("field", field);
        this.put("start", start);
        this.put("end", end);
        this.put("gap", gap);
    }

    public RangeFacetMap(String field, double start, double end, double gap) {
        super("range");
        if (field == null) {
            throw new IllegalArgumentException("Parameter 'field' must be non-null");
        }
        if (end < start) {
            throw new IllegalArgumentException("Parameter 'end' must be greater than parameter 'start'");
        }
        if (gap <= 0.0) {
            throw new IllegalArgumentException("Parameter 'gap' must be a positive value");
        }
        this.put("field", field);
        this.put("start", start);
        this.put("end", end);
        this.put("gap", gap);
    }

    public RangeFacetMap(String field, Date start, Date end, String gap) {
        super("range");
        if (field == null) {
            throw new IllegalArgumentException("Parameter 'field' must be non-null");
        }
        if (start == null) {
            throw new IllegalArgumentException("Parameter 'start' must be non-null");
        }
        if (end == null) {
            throw new IllegalArgumentException("Parameter 'gap' must be non-null");
        }
        this.put("field", field);
        this.put("start", start);
        this.put("end", end);
        this.put("gap", gap);
    }

    @Override
    public RangeFacetMap getThis() {
        return this;
    }

    public RangeFacetMap setHardEnd(boolean hardEnd) {
        this.put("hardend", hardEnd);
        return this;
    }

    public RangeFacetMap setOtherBuckets(OtherBuckets bucketSpecifier) {
        if (bucketSpecifier == null) {
            throw new IllegalArgumentException("Parameter 'bucketSpecifier' must be non-null");
        }
        this.put("other", bucketSpecifier.toString());
        return this;
    }

    public RangeFacetMap setMinCount(int minOccurrences) {
        if (minOccurrences < 0) {
            throw new IllegalArgumentException(" Parameter 'minOccurrences' must be non-negative");
        }
        this.put("mincount", minOccurrences);
        return this;
    }

    public static enum OtherBuckets {
        BEFORE("before"),
        AFTER("after"),
        BETWEEN("between"),
        NONE("none"),
        ALL("all");

        private final String value;

        private OtherBuckets(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

