/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.response;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.solr.client.solrj.response.AnalysisResponseBase;
import org.apache.solr.common.util.NamedList;

public class FieldAnalysisResponse
extends AnalysisResponseBase {
    private Map<String, Analysis> analysisByFieldTypeName = new HashMap<String, Analysis>();
    private Map<String, Analysis> analysisByFieldName = new HashMap<String, Analysis>();

    @Override
    public void setResponse(NamedList<Object> response) {
        super.setResponse(response);
        NamedList analysisNL = (NamedList)response.get("analysis");
        for (Map.Entry entry : (NamedList)analysisNL.get("field_types")) {
            this.analysisByFieldTypeName.put(entry.getKey(), this.buildAnalysis((NamedList)entry.getValue()));
        }
        for (Map.Entry entry : (NamedList)analysisNL.get("field_names")) {
            this.analysisByFieldName.put(entry.getKey(), this.buildAnalysis((NamedList)entry.getValue()));
        }
    }

    private Analysis buildAnalysis(NamedList<NamedList<Object>> value) {
        Analysis analysis = new Analysis();
        NamedList<Object> queryNL = value.get("query");
        List<AnalysisResponseBase.AnalysisPhase> phases = queryNL == null ? null : this.buildPhases(queryNL);
        analysis.setQueryPhases(phases);
        NamedList<Object> indexNL = value.get("index");
        phases = this.buildPhases(indexNL);
        analysis.setIndexPhases(phases);
        return analysis;
    }

    public int getFieldTypeAnalysisCount() {
        return this.analysisByFieldTypeName.size();
    }

    public Analysis getFieldTypeAnalysis(String fieldTypeName) {
        return this.analysisByFieldTypeName.get(fieldTypeName);
    }

    public Iterable<Map.Entry<String, Analysis>> getAllFieldTypeAnalysis() {
        return this.analysisByFieldTypeName.entrySet();
    }

    public int getFieldNameAnalysisCount() {
        return this.analysisByFieldName.size();
    }

    public Analysis getFieldNameAnalysis(String fieldName) {
        return this.analysisByFieldName.get(fieldName);
    }

    public Iterable<Map.Entry<String, Analysis>> getAllFieldNameAnalysis() {
        return this.analysisByFieldName.entrySet();
    }

    public static class Analysis {
        private List<AnalysisResponseBase.AnalysisPhase> queryPhases;
        private List<AnalysisResponseBase.AnalysisPhase> indexPhases;

        private Analysis() {
        }

        public int getQueryPhasesCount() {
            return this.queryPhases == null ? -1 : this.queryPhases.size();
        }

        public Iterable<AnalysisResponseBase.AnalysisPhase> getQueryPhases() {
            return this.queryPhases;
        }

        public int getIndexPhasesCount() {
            return this.indexPhases.size();
        }

        public Iterable<AnalysisResponseBase.AnalysisPhase> getIndexPhases() {
            return this.indexPhases;
        }

        private void setQueryPhases(List<AnalysisResponseBase.AnalysisPhase> queryPhases) {
            this.queryPhases = queryPhases;
        }

        private void setIndexPhases(List<AnalysisResponseBase.AnalysisPhase> indexPhases) {
            this.indexPhases = indexPhases;
        }
    }
}

