/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.lucene;

import java.util.List;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.query.algebra.Extension;
import org.eclipse.rdf4j.query.algebra.ExtensionElem;
import org.eclipse.rdf4j.query.algebra.Filter;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.SingletonSet;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.sail.lucene.AbstractSearchQueryEvaluator;

public class GeoRelationQuerySpec
extends AbstractSearchQueryEvaluator {
    private String relation;
    private QueryModelNode functionParent;
    private Literal qshape;
    private String valueVar;
    private StatementPattern geoStatement;
    private Filter filter;

    public void setRelation(String relation) {
        this.relation = relation;
    }

    public String getRelation() {
        return this.relation;
    }

    public void setFunctionParent(QueryModelNode functionParent) {
        this.functionParent = functionParent;
    }

    public void setQueryGeometry(Literal shape) {
        this.qshape = shape;
    }

    public Literal getQueryGeometry() {
        return this.qshape;
    }

    public void setFunctionValueVar(String varName) {
        this.valueVar = varName;
    }

    public String getFunctionValueVar() {
        return this.valueVar;
    }

    public void setGeometryPattern(StatementPattern sp) {
        if (sp.getSubjectVar().hasValue()) {
            throw new IllegalArgumentException("Subject cannot be bound: " + sp);
        }
        if (!sp.getPredicateVar().hasValue()) {
            throw new IllegalArgumentException("Predicate must be bound: " + sp);
        }
        if (sp.getObjectVar().hasValue()) {
            throw new IllegalArgumentException("Object cannot be bound: " + sp);
        }
        this.geoStatement = sp;
    }

    public String getSubjectVar() {
        return this.geoStatement.getSubjectVar().getName();
    }

    public Var getContextVar() {
        return this.geoStatement.getContextVar();
    }

    public IRI getGeoProperty() {
        return (IRI)this.geoStatement.getPredicateVar().getValue();
    }

    public String getGeoVar() {
        return this.geoStatement.getObjectVar().getName();
    }

    public void setFilter(Filter f) {
        this.filter = f;
    }

    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public QueryModelNode getParentQueryModelNode() {
        return this.filter;
    }

    @Override
    public QueryModelNode removeQueryPatterns() {
        SingletonSet placeholder = new SingletonSet();
        this.filter.replaceWith((QueryModelNode)this.filter.getArg());
        this.geoStatement.replaceWith((QueryModelNode)placeholder);
        if (this.functionParent instanceof ExtensionElem) {
            Extension extension = (Extension)this.functionParent.getParentNode();
            List elements = extension.getElements();
            if (elements.size() > 1) {
                elements.remove(this.functionParent);
            } else {
                extension.replaceWith((QueryModelNode)extension.getArg());
            }
        }
        return placeholder;
    }
}

