/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated.optimizer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.rdf4j.federated.algebra.EmptyNJoin;
import org.eclipse.rdf4j.federated.algebra.EmptyResult;
import org.eclipse.rdf4j.federated.algebra.ExclusiveGroup;
import org.eclipse.rdf4j.federated.algebra.ExclusiveTupleExpr;
import org.eclipse.rdf4j.federated.algebra.NJoin;
import org.eclipse.rdf4j.federated.exception.OptimizationException;
import org.eclipse.rdf4j.federated.optimizer.FedXCostModel;
import org.eclipse.rdf4j.federated.optimizer.FedXOptimizer;
import org.eclipse.rdf4j.federated.structures.QueryInfo;
import org.eclipse.rdf4j.federated.util.QueryAlgebraUtil;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.QueryModelVisitor;
import org.eclipse.rdf4j.query.algebra.Service;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.helpers.AbstractSimpleQueryModelVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatementGroupAndJoinOptimizer
extends AbstractSimpleQueryModelVisitor<OptimizationException>
implements FedXOptimizer {
    private static final Logger log = LoggerFactory.getLogger(StatementGroupAndJoinOptimizer.class);
    protected final QueryInfo queryInfo;
    private final FedXCostModel costModel;

    public StatementGroupAndJoinOptimizer(QueryInfo queryInfo, FedXCostModel costModel) {
        super(true);
        this.queryInfo = queryInfo;
        this.costModel = costModel;
    }

    @Override
    public void optimize(TupleExpr tupleExpr) {
        tupleExpr.visit((QueryModelVisitor)this);
    }

    public void meet(Service tupleExpr) {
    }

    public void meetOther(QueryModelNode node) {
        if (node instanceof NJoin) {
            super.meetOther(node);
            this.meetNJoin((NJoin)node);
        } else {
            super.meetOther(node);
        }
    }

    protected void meetNJoin(NJoin node) {
        List<TupleExpr> args = node.getArgs();
        if ((args = this.formGroups(args)).isEmpty()) {
            node.replaceWith((QueryModelNode)new EmptyNJoin(node, this.queryInfo));
            return;
        }
        if (args.size() == 1) {
            log.debug("Join arguments could be reduced to a single argument, replacing join node.");
            node.replaceWith((QueryModelNode)args.get(0));
            return;
        }
        args = this.optimizeJoinOrder(args);
        NJoin newNode = new NJoin(args, this.queryInfo);
        node.replaceWith((QueryModelNode)newNode);
    }

    protected List<TupleExpr> formGroups(List<TupleExpr> originalArgs) {
        LinkedList<TupleExpr> newArgs = new LinkedList<TupleExpr>();
        LinkedList<TupleExpr> argsCopy = new LinkedList<TupleExpr>(originalArgs);
        while (!argsCopy.isEmpty()) {
            ArrayList<ExclusiveTupleExpr> l;
            ExclusiveTupleExpr current;
            TupleExpr t = argsCopy.removeFirst();
            if (t instanceof EmptyResult) {
                return Collections.emptyList();
            }
            if (t instanceof ExclusiveGroup) {
                current = (ExclusiveGroup)t;
                l = null;
                for (TupleExpr te : argsCopy) {
                    ExclusiveTupleExpr check;
                    if (!(te instanceof ExclusiveTupleExpr) || !(check = (ExclusiveTupleExpr)te).getOwner().equals((Object)((ExclusiveGroup)current).getOwner())) continue;
                    if (l == null) {
                        l = new ArrayList<ExclusiveTupleExpr>();
                        l.addAll(((ExclusiveGroup)current).getExclusiveExpressions());
                    }
                    if (check instanceof ExclusiveGroup) {
                        l.addAll(((ExclusiveGroup)check).getExclusiveExpressions());
                        continue;
                    }
                    l.add(check);
                }
                if (l != null) {
                    argsCopy.removeAll(l);
                    argsCopy.remove(current);
                    newArgs.add(new ExclusiveGroup(l, ((ExclusiveGroup)current).getOwner(), this.queryInfo));
                    continue;
                }
                newArgs.add(current);
                continue;
            }
            if (t instanceof ExclusiveTupleExpr) {
                current = (ExclusiveTupleExpr)t;
                l = null;
                ArrayList<ExclusiveTupleExpr> toRemoveFromArgs = null;
                for (TupleExpr te : argsCopy) {
                    ExclusiveTupleExpr check;
                    if (te instanceof ExclusiveGroup) {
                        check = (ExclusiveGroup)te;
                        if (!((ExclusiveGroup)check).getOwner().equals((Object)current.getOwner())) continue;
                        if (l == null) {
                            l = new ArrayList();
                            l.add(current);
                        }
                        if (toRemoveFromArgs == null) {
                            toRemoveFromArgs = new ArrayList<ExclusiveTupleExpr>();
                        }
                        toRemoveFromArgs.add(check);
                        l.addAll(((ExclusiveGroup)check).getExclusiveExpressions());
                        continue;
                    }
                    if (!(te instanceof ExclusiveTupleExpr) || !(check = (ExclusiveTupleExpr)te).getOwner().equals((Object)current.getOwner())) continue;
                    if (l == null) {
                        l = new ArrayList();
                        l.add(current);
                    }
                    l.add(check);
                }
                if (l != null) {
                    argsCopy.removeAll(l);
                    if (toRemoveFromArgs != null) {
                        argsCopy.removeAll(toRemoveFromArgs);
                    }
                    newArgs.add(new ExclusiveGroup(l, current.getOwner(), this.queryInfo));
                    continue;
                }
                newArgs.add(current);
                continue;
            }
            newArgs.add(t);
        }
        return newArgs;
    }

    protected List<TupleExpr> optimizeJoinOrder(List<TupleExpr> joinArgs) {
        ArrayList<TupleExpr> optimized = new ArrayList<TupleExpr>(joinArgs.size());
        LinkedList<TupleExpr> left = new LinkedList<TupleExpr>(joinArgs);
        HashSet<String> joinVars = new HashSet<String>();
        while (!left.isEmpty()) {
            TupleExpr item = (TupleExpr)left.get(0);
            double minCost = Double.MAX_VALUE;
            for (TupleExpr tmp : left) {
                double currentCost = this.estimateCost(tmp, joinVars);
                if (!(currentCost < minCost)) continue;
                item = tmp;
                minCost = currentCost;
            }
            joinVars.addAll(QueryAlgebraUtil.getFreeVars(item));
            if (log.isTraceEnabled()) {
                log.trace("Cost of " + item.getClass().getSimpleName() + " is determined as " + minCost);
            }
            optimized.add(item);
            left.remove(item);
        }
        return optimized;
    }

    protected double estimateCost(TupleExpr tupleExpr, Set<String> joinVars) {
        return this.costModel.estimateCost(tupleExpr, joinVars);
    }
}

