/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.ImpactsEnum;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.SlowImpactsEnum;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.ImpactsDISI;
import org.apache.lucene.search.LeafSimScorer;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;

final class TermScorer
extends Scorer {
    private final PostingsEnum postingsEnum;
    private final ImpactsEnum impactsEnum;
    private final DocIdSetIterator iterator;
    private final LeafSimScorer docScorer;
    private final ImpactsDISI impactsDisi;

    TermScorer(Weight weight, PostingsEnum postingsEnum, LeafSimScorer docScorer) {
        super(weight);
        this.postingsEnum = postingsEnum;
        this.iterator = this.postingsEnum;
        this.impactsEnum = new SlowImpactsEnum(postingsEnum);
        this.impactsDisi = new ImpactsDISI(this.impactsEnum, this.impactsEnum, docScorer.getSimScorer());
        this.docScorer = docScorer;
    }

    TermScorer(Weight weight, ImpactsEnum impactsEnum, LeafSimScorer docScorer) {
        super(weight);
        this.impactsEnum = impactsEnum;
        this.postingsEnum = this.impactsEnum;
        this.impactsDisi = new ImpactsDISI(impactsEnum, impactsEnum, docScorer.getSimScorer());
        this.iterator = this.impactsDisi;
        this.docScorer = docScorer;
    }

    @Override
    public int docID() {
        return this.postingsEnum.docID();
    }

    final int freq() throws IOException {
        return this.postingsEnum.freq();
    }

    @Override
    public DocIdSetIterator iterator() {
        return this.iterator;
    }

    @Override
    public float score() throws IOException {
        assert (this.docID() != Integer.MAX_VALUE);
        return this.docScorer.score(this.postingsEnum.docID(), this.postingsEnum.freq());
    }

    @Override
    public float smoothingScore(int docId) throws IOException {
        return this.docScorer.score(docId, 0.0f);
    }

    @Override
    public int advanceShallow(int target) throws IOException {
        return this.impactsDisi.advanceShallow(target);
    }

    @Override
    public float getMaxScore(int upTo) throws IOException {
        return this.impactsDisi.getMaxScore(upTo);
    }

    @Override
    public void setMinCompetitiveScore(float minScore) {
        this.impactsDisi.setMinCompetitiveScore(minScore);
    }

    public String toString() {
        return "scorer(" + this.weight + ")[" + super.toString() + "]";
    }
}

