/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.nattable.freeze.event;

import java.util.Collection;
import net.sourceforge.nattable.coordinate.PositionCoordinate;
import net.sourceforge.nattable.coordinate.Range;
import net.sourceforge.nattable.freeze.FreezeLayer;
import net.sourceforge.nattable.layer.event.ILayerEventHandler;
import net.sourceforge.nattable.layer.event.IStructuralChangeEvent;
import net.sourceforge.nattable.layer.event.StructuralDiff;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FreezeEventHandler
implements ILayerEventHandler<IStructuralChangeEvent> {
    private final FreezeLayer freezeLayer;

    public FreezeEventHandler(FreezeLayer freezeLayer) {
        this.freezeLayer = freezeLayer;
    }

    @Override
    public Class<IStructuralChangeEvent> getLayerEventClass() {
        return IStructuralChangeEvent.class;
    }

    @Override
    public void handleLayerEvent(IStructuralChangeEvent event) {
        Collection<StructuralDiff> rowDiffs;
        PositionCoordinate topLeftPosition = this.freezeLayer.getTopLeftPosition();
        PositionCoordinate bottomRightPosition = this.freezeLayer.getBottomRightPosition();
        Collection<StructuralDiff> columnDiffs = event.getColumnDiffs();
        if (columnDiffs != null) {
            int leftOffset = 0;
            int rightOffset = 0;
            for (StructuralDiff columnDiff : columnDiffs) {
                switch (columnDiff.getDiffType()) {
                    case ADD: {
                        Range afterPositionRange = columnDiff.getAfterPositionRange();
                        if (afterPositionRange.start < topLeftPosition.columnPosition) {
                            leftOffset += afterPositionRange.size();
                        }
                        if (afterPositionRange.start > bottomRightPosition.columnPosition) break;
                        rightOffset += afterPositionRange.size();
                        break;
                    }
                    case DELETE: {
                        Range beforePositionRange = columnDiff.getBeforePositionRange();
                        if (beforePositionRange.start < topLeftPosition.columnPosition) {
                            leftOffset -= Math.min(beforePositionRange.end, topLeftPosition.columnPosition + 1) - beforePositionRange.start;
                        }
                        if (beforePositionRange.start > bottomRightPosition.columnPosition) break;
                        rightOffset -= Math.min(beforePositionRange.end, bottomRightPosition.columnPosition + 1) - beforePositionRange.start;
                    }
                }
            }
            topLeftPosition.columnPosition += leftOffset;
            bottomRightPosition.columnPosition += rightOffset;
        }
        if ((rowDiffs = event.getRowDiffs()) != null) {
            int leftOffset = 0;
            int rightOffset = 0;
            for (StructuralDiff rowDiff : rowDiffs) {
                switch (rowDiff.getDiffType()) {
                    case ADD: {
                        Range afterPositionRange = rowDiff.getAfterPositionRange();
                        if (afterPositionRange.start < topLeftPosition.rowPosition) {
                            leftOffset += afterPositionRange.size();
                        }
                        if (afterPositionRange.start > bottomRightPosition.rowPosition) break;
                        rightOffset += afterPositionRange.size();
                        break;
                    }
                    case DELETE: {
                        Range beforePositionRange = rowDiff.getBeforePositionRange();
                        if (beforePositionRange.start < topLeftPosition.rowPosition) {
                            leftOffset -= Math.min(beforePositionRange.end, topLeftPosition.rowPosition + 1) - beforePositionRange.start;
                        }
                        if (beforePositionRange.start > bottomRightPosition.rowPosition) break;
                        rightOffset -= Math.min(beforePositionRange.end, bottomRightPosition.rowPosition + 1) - beforePositionRange.start;
                    }
                }
            }
            topLeftPosition.rowPosition += leftOffset;
            bottomRightPosition.rowPosition += rightOffset;
        }
    }
}

