/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.nattable.reorder.action;

import net.sourceforge.nattable.NatTable;
import net.sourceforge.nattable.layer.ILayer;
import net.sourceforge.nattable.layer.LabelStack;
import net.sourceforge.nattable.layer.cell.LayerCell;
import net.sourceforge.nattable.painter.IOverlayPainter;
import net.sourceforge.nattable.reorder.command.ColumnReorderCommand;
import net.sourceforge.nattable.ui.action.IDragMode;
import net.sourceforge.nattable.ui.util.CellEdgeDetectUtil;
import net.sourceforge.nattable.ui.util.CellEdgeEnum;
import net.sourceforge.nattable.util.GUIHelper;
import net.sourceforge.nattable.viewport.command.ViewportSelectColumnCommand;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class ColumnReorderDragMode
implements IDragMode {
    protected int dragFromGridColumnPosition = -1;
    protected int dragToGridColumnPosition = -1;
    protected int dragToColumnHandleX = -1;
    protected ColumnReorderOverlayPainter overlayPainter = new ColumnReorderOverlayPainter();
    protected LabelStack regionLabels;
    protected boolean isValidCoordinate = false;
    private CellEdgeEnum moveDirection = null;

    public void mouseDown(NatTable natTable, MouseEvent event) {
        natTable.forceFocus();
        this.regionLabels = natTable.getRegionLabelsByXY(event.x, event.y);
        this.dragFromGridColumnPosition = natTable.getColumnPositionByX(event.x);
        this.dragToGridColumnPosition = -1;
        this.dragToColumnHandleX = -1;
        this.selectDragFocusColumn(natTable, event, this.dragFromGridColumnPosition);
        natTable.addOverlayPainter(this.overlayPainter);
    }

    public void mouseMove(NatTable natTable, MouseEvent event) {
        if (event.x > natTable.getWidth()) {
            return;
        }
        Point dragPt = new Point(event.x, event.y);
        int gridColumnPosition = natTable.getColumnPositionByX(event.x);
        if (gridColumnPosition >= 0) {
            int gridRowPosition = natTable.getRowPositionByY(event.y);
            LayerCell cell = natTable.getCellByPosition(gridColumnPosition, gridRowPosition);
            if (cell == null) {
                return;
            }
            Rectangle selectedColumnHeaderRect = cell.getBounds();
            int tmpDragToGridColumnPosition = 0;
            this.moveDirection = CellEdgeDetectUtil.getHorizontalCellEdge(selectedColumnHeaderRect, dragPt);
            switch (this.moveDirection) {
                case LEFT: {
                    tmpDragToGridColumnPosition = gridColumnPosition;
                    this.isValidCoordinate = this.isValidTargetColumnPosition(natTable, this.dragFromGridColumnPosition, tmpDragToGridColumnPosition, event);
                    if (this.isValidCoordinate) {
                        this.dragToGridColumnPosition = tmpDragToGridColumnPosition;
                        this.dragToColumnHandleX = selectedColumnHeaderRect.x;
                        break;
                    }
                    this.dragToColumnHandleX = 0;
                    break;
                }
                case RIGHT: {
                    tmpDragToGridColumnPosition = gridColumnPosition + 1;
                    this.isValidCoordinate = this.isValidTargetColumnPosition(natTable, this.dragFromGridColumnPosition, tmpDragToGridColumnPosition, event);
                    if (this.isValidCoordinate) {
                        this.dragToGridColumnPosition = tmpDragToGridColumnPosition;
                        this.dragToColumnHandleX = selectedColumnHeaderRect.x + selectedColumnHeaderRect.width;
                        break;
                    }
                    this.dragToColumnHandleX = 0;
                }
            }
            natTable.redraw(0, 0, natTable.getWidth(), natTable.getHeight(), false);
        }
    }

    protected boolean isValidTargetColumnPosition(ILayer natLayer, int dragFromColumnPosition, int dragToGridColumnPosition, MouseEvent event) {
        return true;
    }

    public void mouseUp(NatTable natTable, MouseEvent event) {
        natTable.removeOverlayPainter(this.overlayPainter);
        if (this.dragFromGridColumnPosition >= 0 && this.dragToGridColumnPosition >= 0 && this.isValidCoordinate) {
            this.fireMoveCommand(natTable);
            if (CellEdgeEnum.RIGHT == this.moveDirection) {
                this.selectDragFocusColumn(natTable, event, this.dragToGridColumnPosition - 1);
            } else {
                this.selectDragFocusColumn(natTable, event, this.dragToGridColumnPosition);
            }
        }
    }

    protected void fireMoveCommand(NatTable natTable) {
        natTable.doCommand(new ColumnReorderCommand(natTable, this.dragFromGridColumnPosition, this.dragToGridColumnPosition));
    }

    protected void selectDragFocusColumn(ILayer natLayer, MouseEvent event, int focusedColumnPosition) {
        boolean shiftMask = (0x20000 & event.stateMask) != 0;
        boolean controlMask = (0x40000 & event.stateMask) != 0;
        natLayer.doCommand(new ViewportSelectColumnCommand(natLayer, focusedColumnPosition, shiftMask, controlMask));
    }

    private class ColumnReorderOverlayPainter
    implements IOverlayPainter {
        private ColumnReorderOverlayPainter() {
        }

        public void paintOverlay(GC gc, ILayer layer) {
            if (ColumnReorderDragMode.this.dragFromGridColumnPosition >= 0) {
                Color orgBgColor = gc.getBackground();
                gc.setBackground(GUIHelper.COLOR_DARK_GRAY);
                gc.fillRectangle(ColumnReorderDragMode.this.dragToColumnHandleX - 1, 0, 2, layer.getHeight());
                gc.setBackground(orgBgColor);
            }
        }
    }
}

