/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.internal.dom.sgml.impl;

import org.eclipse.actf.model.internal.dom.sgml.ISGMLParser;
import org.eclipse.actf.model.internal.dom.sgml.impl.AttributeDefinition;
import org.eclipse.actf.model.internal.dom.sgml.modelgroup.IModelGroup;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ElementDefinition
implements IModelGroup {
    private boolean start;
    private boolean end;
    private String name;
    private IModelGroup contentModel;
    private ElementDefinition[] inclusions;
    private ElementDefinition[] exclusions;
    private AttributeDefinition[] attributeDefs = new AttributeDefinition[32];
    private int[] attributeDefHashes = new int[32];
    private int attrNum = 0;
    private boolean infinite = false;
    int number;
    private boolean[] inclusionVector;
    private boolean[] exclusionVector;
    private boolean[] hash = null;

    protected ElementDefinition(String string) {
        this.name = string;
    }

    protected ElementDefinition(String string, IModelGroup iModelGroup) {
        this.name = string;
        this.contentModel = iModelGroup;
    }

    final void addAttributeDefinition(AttributeDefinition attributeDefinition) {
        if (attributeDefinition != null) {
            if (this.attrNum == this.attributeDefs.length) {
                AttributeDefinition[] attributeDefinitionArray = new AttributeDefinition[this.attrNum * 2];
                int[] nArray = new int[this.attrNum * 2];
                int n = 0;
                while (n < this.attrNum) {
                    attributeDefinitionArray[n] = this.attributeDefs[n];
                    nArray[n] = this.attributeDefHashes[n];
                    ++n;
                }
                this.attributeDefs = attributeDefinitionArray;
                this.attributeDefHashes = nArray;
            }
            this.attributeDefs[this.attrNum] = attributeDefinition;
            this.attributeDefHashes[this.attrNum++] = this.hashCode(attributeDefinition.getName().toCharArray());
        }
    }

    public final boolean endTagOmittable() {
        return this.end;
    }

    public boolean match(ISGMLParser iSGMLParser, Node node, Node node2) {
        if (node2 instanceof Element && node2.getNodeName().equalsIgnoreCase(this.name)) {
            node.appendChild(node2);
            return true;
        }
        if (this.start) {
            boolean bl;
            Element element = iSGMLParser.getDocument().createElement(iSGMLParser.changeDefaultTagCase(this.name));
            if (node2 instanceof Element) {
                Element element2 = (Element)node2;
                if (this.exclusion(element2)) {
                    return false;
                }
                if (this.inclusion(element2)) {
                    element.appendChild(node2);
                    node.appendChild(element);
                    iSGMLParser.addAutoGenerated(element);
                    return true;
                }
            }
            if (bl = this.contentModel.match(iSGMLParser, element, node2)) {
                node.appendChild(element);
                iSGMLParser.addAutoGenerated(element);
                return true;
            }
        }
        return false;
    }

    final IModelGroup getContentModel() {
        return this.contentModel;
    }

    public boolean contentMatch(ISGMLParser iSGMLParser, Node node, Node node2) {
        return this.contentModel.match(iSGMLParser, node, node2);
    }

    public final String getDefaultValue(String string) {
        int n = this.hashCode(string.toCharArray());
        int n2 = 0;
        while (n2 < this.attrNum) {
            AttributeDefinition attributeDefinition;
            if (this.attributeDefHashes[n2] == n && (attributeDefinition = this.attributeDefs[n2]).getName().equalsIgnoreCase(string)) {
                return attributeDefinition.getDefaultValue();
            }
            ++n2;
        }
        return null;
    }

    final boolean exclusion(Element element) {
        if (this.exclusions == null) {
            return false;
        }
        int n = this.exclusions.length - 1;
        while (n >= 0) {
            if (this.exclusions[n].name.equalsIgnoreCase(element.getNodeName())) {
                return true;
            }
            --n;
        }
        return false;
    }

    final boolean inclusion(Element element) {
        if (this.inclusions == null) {
            return false;
        }
        int n = this.inclusions.length - 1;
        while (n >= 0) {
            if (this.inclusions[n].name.equalsIgnoreCase(element.getNodeName())) {
                return true;
            }
            --n;
        }
        return false;
    }

    public final String getName() {
        return this.name;
    }

    final boolean instance(Node node) {
        return node instanceof Element && node.getNodeName().equalsIgnoreCase(this.name);
    }

    final void setContentModel(IModelGroup iModelGroup) {
        this.contentModel = iModelGroup;
    }

    final void setEndTag(boolean bl) {
        this.end = bl;
    }

    final void setExclusion(ElementDefinition[] elementDefinitionArray) {
        this.exclusions = elementDefinitionArray;
    }

    final void setInclusion(ElementDefinition[] elementDefinitionArray) {
        this.inclusions = elementDefinitionArray;
    }

    final void setStartTag(boolean bl) {
        this.start = bl;
    }

    public final boolean startTagOmittable() {
        return this.start;
    }

    public String toString() {
        String string = "<!ELEMENT " + this.name + ' ' + (this.start ? (char)'O' : '-') + ' ' + (this.end ? (char)'O' : '-') + ' ' + '>';
        return string;
    }

    public AttributeDefinition getAttributeDef(String string) {
        int n = this.hashCode(string.toCharArray());
        int n2 = this.attrNum - 1;
        while (n2 >= 0) {
            if (this.attributeDefHashes[n2] == n && this.attributeDefs[n2].getName().equalsIgnoreCase(string)) {
                return this.attributeDefs[n2];
            }
            --n2;
        }
        return null;
    }

    private int hashCode(char[] cArray) {
        int n = 0;
        int n2 = cArray.length - 1;
        while (n2 >= 0) {
            n = 25 * n + (cArray[n2] & 0x1F) - 1;
            --n2;
        }
        return n;
    }

    public boolean optional() {
        return false;
    }

    public void refer(boolean bl) {
        if (bl) {
            this.infinite = bl;
        }
        if (this.inclusions != null) {
            int n = 0;
            while (n < this.inclusions.length) {
                this.inclusions[n].refer(true);
                ++n;
            }
        }
        if (this.contentModel != null) {
            this.contentModel.refer(bl);
        }
    }

    public boolean isSingleton() {
        return !this.infinite;
    }

    public int getMagicNumber() {
        return this.number;
    }

    public boolean match(int n) {
        return this.hash[n];
    }

    final boolean[] getInclusionVector() {
        return this.inclusionVector;
    }

    final boolean inclusion(int n) {
        return this.inclusionVector[n];
    }

    final boolean[] getExclusionVector() {
        return this.exclusionVector;
    }

    final boolean exclusion(int n) {
        return this.exclusionVector[n];
    }

    public boolean[] rehash(int n) {
        int n2;
        if (this.hash != null) {
            return this.hash;
        }
        this.inclusionVector = new boolean[n];
        if (this.inclusions != null) {
            n2 = 0;
            while (n2 < this.inclusions.length) {
                this.inclusionVector[this.inclusions[n2].number] = true;
                ++n2;
            }
        }
        this.exclusionVector = new boolean[n];
        if (this.exclusions != null) {
            n2 = 0;
            while (n2 < this.exclusions.length) {
                this.exclusionVector[this.exclusions[n2].number] = true;
                ++n2;
            }
        }
        this.hash = new boolean[n];
        boolean[] blArray = this.contentModel.rehash(n);
        if (this.start) {
            if (blArray == null) {
                blArray = new boolean[n];
            }
            int n3 = n - 1;
            while (n3 >= 0) {
                this.hash[n3] = (this.inclusionVector[n3] | blArray[n3]) & !this.exclusionVector[n3];
                --n3;
            }
        }
        this.hash[this.number] = true;
        return this.hash;
    }
}

