/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.fieldassist;

import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.IControlContentAdapter2;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;

public class CComboContentAdapter
implements IControlContentAdapter,
IControlContentAdapter2 {
    private static final boolean COMPUTE_TEXT_USING_CLIENTAREA = !"carbon".equals(SWT.getPlatform());

    public String getControlContents(Control control) {
        return ChartUIUtil.getText((Control)control);
    }

    public void setControlContents(Control control, String text, int cursorPosition) {
        ChartUIUtil.setText((Control)control, (String)text);
        ((CCombo)control).setSelection(new Point(cursorPosition, cursorPosition));
    }

    public void insertControlContents(Control control, String text, int cursorPosition) {
        CCombo combo = (CCombo)control;
        String contents = ChartUIUtil.getText((Control)combo);
        Point selection = combo.getSelection();
        StringBuffer sb = new StringBuffer();
        sb.append(contents.substring(0, selection.x));
        sb.append(text);
        if (selection.y < contents.length()) {
            sb.append(contents.substring(selection.y, contents.length()));
        }
        ChartUIUtil.setText((Control)combo, (String)sb.toString());
        selection.x += cursorPosition;
        selection.y = selection.x;
        combo.setSelection(selection);
    }

    public int getCursorPosition(Control control) {
        return ((CCombo)control).getSelection().x;
    }

    public Rectangle getInsertionBounds(Control control) {
        CCombo combo = (CCombo)control;
        int position = combo.getSelection().y;
        String contents = ChartUIUtil.getText((Control)combo);
        GC gc = new GC((Drawable)combo);
        gc.setFont(combo.getFont());
        Point extent = gc.textExtent(contents.substring(0, Math.min(position, contents.length())));
        gc.dispose();
        if (COMPUTE_TEXT_USING_CLIENTAREA) {
            return new Rectangle(combo.getClientArea().x + extent.x, combo.getClientArea().y, 1, combo.getClientArea().height);
        }
        return new Rectangle(extent.x, 0, 1, combo.getSize().y);
    }

    public void setCursorPosition(Control control, int index) {
        ((CCombo)control).setSelection(new Point(index, index));
    }

    public Point getSelection(Control control) {
        return ((CCombo)control).getSelection();
    }

    public void setSelection(Control control, Point range) {
        ((CCombo)control).setSelection(range);
    }
}

