/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.oda.mongodb.ui.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.birt.data.oda.mongodb.ui.Activator;
import org.eclipse.birt.data.oda.mongodb.ui.i18n.Messages;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class UIHelper {
    public static void setSystemHelp(Control control, String contextId) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp(control, contextId);
    }

    public static Image getImage(String sPluginRelativePath) throws IOException {
        ImageRegistry registry = JFaceResources.getImageRegistry();
        Image image = registry.get(sPluginRelativePath);
        if (image == null) {
            image = UIHelper.createImage(sPluginRelativePath);
            registry.put(sPluginRelativePath, image);
        }
        return image;
    }

    private static Image createImage(String sPluginRelativePath) throws IOException {
        Image img = null;
        try {
            img = new Image((Device)Display.getCurrent(), UIHelper.getURL(sPluginRelativePath).openStream());
        }
        catch (MalformedURLException malformedURLException) {
            img = new Image((Device)Display.getCurrent(), (InputStream)new FileInputStream(UIHelper.getURL(sPluginRelativePath).toString()));
        }
        if (img == null) {
            img = new Image((Device)Display.getCurrent(), 1, 1);
        }
        return img;
    }

    public static URL getURL(String sPluginRelativePath) throws MalformedURLException {
        URL url = null;
        url = Platform.getExtensionRegistry() != null ? new URL(Activator.getDefault().getBundle().getEntry("/"), sPluginRelativePath) : new URL("file:///" + new File(sPluginRelativePath).getAbsolutePath());
        return url;
    }

    public static String getUserErrorMessage(String userMsgKey, Exception ex) {
        String msg = userMsgKey != null ? Messages.getString(userMsgKey) : "";
        String exMsg = ex.getLocalizedMessage();
        if (exMsg != null) {
            msg = String.valueOf(msg) + "\n" + exMsg;
        }
        return msg;
    }

    public static Image getEmbeddedWarningImage() throws IOException {
        return UIHelper.getImage("icons/warning.gif");
    }

    public static Image getDatabaseDisplayImage() throws IOException {
        return UIHelper.getImage("icons/database.gif");
    }

    public static Image getCollectionDisplayImage() throws IOException {
        return UIHelper.getImage("icons/collection.gif");
    }

    public static Image getFieldDisplayImage() throws IOException {
        return UIHelper.getImage("icons/field.gif");
    }

    public static Image getDocumentDisplayImage() throws IOException {
        return UIHelper.getImage("icons/document.gif");
    }

    public static Image getSelectedDocumentDisplayImage() throws IOException {
        return UIHelper.getImage("icons/document_selected.gif");
    }

    public static Image getSelectedFieldDisplayImage() throws IOException {
        return UIHelper.getImage("icons/field_selected.gif");
    }

    public static Image getSyntaxValidationImage() throws IOException {
        return UIHelper.getImage("icons/validate.gif");
    }

    public static boolean isNumber(String text) {
        if (UIHelper.isEmptyString(text)) {
            return false;
        }
        return text.matches("^[0-9]*[1-9][0-9]*$");
    }

    public static boolean isNumberOrZero(String text) {
        if (UIHelper.isEmptyString(text)) {
            return false;
        }
        return text.matches("^[0-9]*[1-9][0-9]*$") || text.matches("0");
    }

    public static boolean isEmptyString(String text) {
        return text == null || text.trim().length() == 0;
    }
}

