/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.activity;

import java.util.ArrayList;
import java.util.Stack;
import org.eclipse.birt.report.model.activity.ActivityRecord;
import org.eclipse.birt.report.model.activity.CompoundRecord;
import org.eclipse.birt.report.model.activity.ExtensionActivityRecord;
import org.eclipse.birt.report.model.activity.LayoutCompoundRecord;
import org.eclipse.birt.report.model.activity.TransactionAdapter;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.activity.ActivityStackEvent;
import org.eclipse.birt.report.model.api.activity.ActivityStackListener;
import org.eclipse.birt.report.model.api.activity.IActivityRecord;
import org.eclipse.birt.report.model.api.activity.TransactionOption;
import org.eclipse.birt.report.model.api.extension.IElementCommand;
import org.eclipse.birt.report.model.core.Module;

public class ActivityStack
implements CommandStack {
    public static final int DEFAULT_STACK_LIMIT = 500;
    protected Stack<ActivityRecord> undoStack = new Stack();
    protected Stack<ActivityRecord> redoStack = new Stack();
    protected Stack<CompoundRecord> transStack = new Stack();
    protected TransactionAdapter adapter = new TransactionAdapter(this);
    private int stackLimit = 500;
    private int transCount = 0;
    protected ArrayList<ActivityStackListener> listeners = null;
    protected Module module = null;

    public ActivityStack(Module module) {
        this.module = module;
    }

    @Override
    public void execute(IElementCommand command) {
        ExtensionActivityRecord record = new ExtensionActivityRecord(command);
        this.execute(record);
    }

    @Override
    public void execute(IActivityRecord executeRecord) {
        ActivityRecord record = (ActivityRecord)executeRecord;
        assert (record != null);
        assert (record.getState() == 0);
        record.execute();
        record.setState(1);
        this.clearCachedValues();
        assert (!(record instanceof CompoundRecord));
        record.performPostTasks(this.transStack);
        if (this.transStack.isEmpty()) {
            this.destroyRecords(this.redoStack);
            record.setTransNo(++this.transCount);
            this.undoStack.push(record);
            this.trimUndoStack();
            this.sendNotifcations(new ActivityStackEvent(this, 1));
        } else {
            CompoundRecord trans = (CompoundRecord)this.transStack.lastElement();
            trans.append(record);
        }
    }

    private void clearCachedValues() {
        if (this.module != null && this.module.isCached()) {
            this.module.setIsCached(false);
        }
    }

    @Override
    public void undo() {
        assert (this.canUndo());
        ActivityRecord record = this.undoStack.pop();
        assert (record.getState() == 1 || record.getState() == 3);
        record.undo();
        record.setState(2);
        this.clearCachedValues();
        this.redoStack.push(record);
        record.performPostTasks(this.transStack);
        this.sendNotifcations(new ActivityStackEvent(this, 3));
    }

    @Override
    public void redo() {
        assert (this.canRedo());
        ActivityRecord record = this.redoStack.pop();
        assert (record.getState() == 2);
        record.redo();
        record.setState(3);
        this.clearCachedValues();
        this.undoStack.push(record);
        record.performPostTasks(this.transStack);
        this.sendNotifcations(new ActivityStackEvent(this, 2));
    }

    @Override
    public boolean canUndo() {
        if (!this.transStack.isEmpty()) {
            return false;
        }
        if (this.undoStack.size() == 0) {
            return false;
        }
        ActivityRecord record = (ActivityRecord)this.undoStack.lastElement();
        return record.canUndo();
    }

    @Override
    public boolean canRedo() {
        if (!this.transStack.isEmpty()) {
            return false;
        }
        if (this.redoStack.size() == 0) {
            return false;
        }
        ActivityRecord record = (ActivityRecord)this.redoStack.lastElement();
        return record.canUndo();
    }

    protected void trimUndoStack() {
        while (this.undoStack.size() > this.stackLimit) {
            ActivityRecord cmd = (ActivityRecord)this.undoStack.remove(0);
            assert (cmd.getState() != 4);
            cmd.destroy();
            cmd.setState(4);
        }
    }

    @Override
    public void flush() {
        this.destroyRecords(this.redoStack);
        this.destroyRecords(this.undoStack);
    }

    private void destroyRecords(Stack<ActivityRecord> stack) {
        for (ActivityRecord cmd : stack) {
            assert (cmd.getState() != 4);
            cmd.destroy();
            cmd.setState(4);
        }
        stack.removeAllElements();
    }

    @Override
    public void setStackLimit(int limit) {
        assert (limit >= 0);
        this.stackLimit = limit;
        this.trimUndoStack();
    }

    public Object[] getRecords() {
        ArrayList<ActivityRecord> records = new ArrayList<ActivityRecord>(this.undoStack);
        int i = this.redoStack.size() - 1;
        while (i >= 0) {
            records.add((ActivityRecord)this.redoStack.get(i));
            --i;
        }
        return records.toArray();
    }

    @Override
    public IActivityRecord getRedoRecord() {
        return this.redoStack.isEmpty() ? null : this.redoStack.peek();
    }

    @Override
    public IActivityRecord getUndoRecord() {
        return this.undoStack.isEmpty() ? null : this.undoStack.peek();
    }

    @Override
    public String getUndoLabel() {
        IActivityRecord cmd = this.getUndoRecord();
        if (cmd == null) {
            return null;
        }
        String label = cmd.getLabel();
        assert (label != null);
        return label;
    }

    @Override
    public String getRedoLabel() {
        IActivityRecord cmd = this.getRedoRecord();
        if (cmd == null) {
            return null;
        }
        String label = cmd.getLabel();
        assert (label != null);
        return label;
    }

    @Override
    public void startTrans(String label) {
        this.transStack.push(this.adapter.createNewRecord(0, label));
    }

    public void startTrans(String label, TransactionOption options) {
        this.startTrans(label);
        CompoundRecord tmpRecord = this.transStack.peek();
        tmpRecord.setOptions(options);
    }

    @Override
    public void commit() {
        assert (!this.transStack.empty());
        CompoundRecord transaction = this.transStack.pop();
        if (transaction.isEmpty()) {
            transaction.destroy();
            return;
        }
        transaction.setState(1);
        CompoundRecord record = transaction;
        ((ActivityRecord)record).performPostTasks(this.transStack);
        if (this.transStack.empty()) {
            this.destroyRecords(this.redoStack);
            record.setTransNo(++this.transCount);
            this.adapter.handleCommit(record);
            this.sendNotifcations(new ActivityStackEvent(this, 1));
        } else {
            CompoundRecord outer = (CompoundRecord)this.transStack.lastElement();
            outer.append(record);
        }
    }

    @Override
    public void rollback() {
        assert (this.transStack.size() > 0);
        CompoundRecord trans = this.transStack.pop();
        trans.rollback();
        trans.destroy();
        this.adapter.handleRollback(trans);
        if (this.transStack.empty()) {
            this.sendNotifcations(new ActivityStackEvent(this, 4));
        }
    }

    @Override
    public void rollbackAll() {
        while (!this.transStack.isEmpty()) {
            this.rollback();
        }
    }

    public int getCurrentTransNo() {
        if (this.undoStack.isEmpty()) {
            return 0;
        }
        return ((ActivityRecord)this.undoStack.lastElement()).getTransNo();
    }

    @Override
    public void addListener(ActivityStackListener obj) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        if (obj != null && !this.listeners.contains(obj)) {
            this.listeners.add(obj);
        }
    }

    @Override
    public void removeListener(ActivityStackListener obj) {
        if (this.listeners == null) {
            return;
        }
        int posn = this.listeners.indexOf(obj);
        if (posn != -1) {
            this.listeners.remove(posn);
        }
    }

    public void sendNotifcations(ActivityStackEvent event) {
        if (this.listeners != null) {
            ArrayList<ActivityStackListener> tmpList = new ArrayList<ActivityStackListener>();
            tmpList.addAll(this.listeners);
            for (ActivityStackListener listener : tmpList) {
                listener.stackChanged(event);
            }
        }
        if (this.module != null) {
            this.module.getNameHelper().clear();
        }
    }

    @Override
    public void startPersistentTrans(String label) {
        this.transStack.push(this.adapter.createNewRecord(3, label));
    }

    public void startPersistentTrans() {
        this.startPersistentTrans(null);
    }

    public void startSilentTrans(String label) {
        this.startSilentTrans(label, false);
    }

    public void startSilentTrans(boolean filterAll) {
        this.startSilentTrans(null, filterAll);
    }

    protected void startSilentTrans(String label, boolean filterAll) {
        LayoutCompoundRecord cmpRecord = (LayoutCompoundRecord)this.adapter.createNewRecord(2, label);
        cmpRecord.setFilterAll(filterAll);
        this.transStack.push(cmpRecord);
    }

    public void startFilterEventTrans(String label) {
        this.transStack.push(this.adapter.createNewRecord(1, label));
    }

    public void startNonUndoableTrans(String label) {
        this.transStack.push(this.adapter.createNewRecord(4, label));
    }

    @Override
    public void clearListeners() {
        if (this.listeners != null) {
            this.listeners.clear();
        }
        this.listeners = null;
    }

    protected int increaseTransCount() {
        return ++this.transCount;
    }

    public CompoundRecord getTopTransaction() {
        if (this.transStack.isEmpty()) {
            return null;
        }
        return (CompoundRecord)this.transStack.lastElement();
    }
}

