/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.bpel.ui.Messages;
import org.eclipse.bpel.ui.editparts.FlowEditPart;
import org.eclipse.bpel.ui.util.BPELUtil;
import org.eclipse.bpel.ui.util.ModelHelper;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.ui.IWorkbenchPart;

public class AutoArrangeFlowsAction
extends SelectionAction {
    public static final String ACTION_ID = "AutoArrangeFlowsAction";

    public AutoArrangeFlowsAction(IWorkbenchPart part) {
        super(part);
        this.setId(ACTION_ID);
        this.setText(Messages.AutoArrangeFlowsAction_Arrange_Flow_Contents_2);
        this.setToolTipText(Messages.AutoArrangeFlowsAction_Auto_arrange_flow_contents_3);
    }

    protected boolean isFreeform(FlowEditPart flowEditPart) {
        return flowEditPart.getContentPane().getLayoutManager() instanceof XYLayout;
    }

    boolean hasTargetFlows(List selectedObjects) {
        boolean foundFlow = false;
        for (Object object : selectedObjects) {
            if (!(object instanceof FlowEditPart)) continue;
            foundFlow = true;
            if (!this.isFreeform((FlowEditPart)object)) continue;
            return true;
        }
        if (!foundFlow) {
            for (Object object : selectedObjects) {
                if (!(object instanceof EditPart) || !((object = ((EditPart)object).getParent()) instanceof FlowEditPart)) continue;
                foundFlow = true;
                if (!this.isFreeform((FlowEditPart)object)) continue;
                return true;
            }
        }
        return false;
    }

    List getTargetFlows(List selectedObjects) {
        boolean foundFlow = false;
        ArrayList<FlowEditPart> result = new ArrayList<FlowEditPart>();
        for (Object object : selectedObjects) {
            if (!(object instanceof FlowEditPart)) continue;
            foundFlow = true;
            if (!this.isFreeform((FlowEditPart)object)) continue;
            result.add((FlowEditPart)object);
        }
        if (!foundFlow) {
            for (Object object : selectedObjects) {
                if (!(object instanceof EditPart) || !((object = ((EditPart)object).getParent()) instanceof FlowEditPart)) continue;
                foundFlow = true;
                if (!this.isFreeform((FlowEditPart)object)) continue;
                result.add((FlowEditPart)object);
            }
        }
        if (result.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        BPELUtil.sortFlowList(result);
        return result;
    }

    public void run() {
        List flowsList = this.getTargetFlows(this.getSelectedObjects());
        Iterator it = flowsList.iterator();
        while (it.hasNext()) {
            ((FlowEditPart)it.next()).doAutoLayout();
        }
    }

    protected boolean calculateEnabled() {
        List sel = this.getSelectedObjects();
        return sel.size() > 0 && this.hasTargetFlows(sel) && !ModelHelper.getBPELEditor(((EditPart)sel.get(0)).getModel()).getAutoFlowLayout();
    }

    public boolean isChecked() {
        return false;
    }
}

