/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.editparts.policies;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.bpel.common.ui.figures.InsetResizeHandle;
import org.eclipse.bpel.ui.BPELUIPlugin;
import org.eclipse.bpel.ui.util.BPELDragEditPartsTracker;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Handle;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.tools.ResizeTracker;
import org.eclipse.jface.resource.ColorRegistry;

public class BPELSelectionEditPolicy
extends NonResizableEditPolicy {
    protected boolean fResizable;
    protected boolean fMovable;

    public BPELSelectionEditPolicy(boolean resizable, boolean movable) {
        this.fResizable = resizable;
        this.fMovable = movable;
    }

    protected List<Handle> createSelectionHandles() {
        if (this.fResizable) {
            return this.createResizableHandles((GraphicalEditPart)this.getHost());
        }
        return this.createCornerHandles((GraphicalEditPart)this.getHost());
    }

    public void eraseSourceFeedback(Request request) {
        if (this.fResizable && "resize".equals(request.getType())) {
            this.eraseChangeBoundsFeedback((ChangeBoundsRequest)request);
        } else {
            super.eraseSourceFeedback(request);
        }
    }

    public Command getCommand(Request request) {
        if (this.fResizable && "resize".equals(request.getType())) {
            return this.getResizeCommand((ChangeBoundsRequest)request);
        }
        return super.getCommand(request);
    }

    protected Command getResizeCommand(ChangeBoundsRequest request) {
        ChangeBoundsRequest req = new ChangeBoundsRequest((Object)"resize children");
        req.setEditParts(this.getHost());
        req.setMoveDelta(request.getMoveDelta());
        req.setSizeDelta(request.getSizeDelta());
        req.setLocation(request.getLocation());
        req.setResizeDirection(request.getResizeDirection());
        return this.getHost().getParent().getCommand((Request)req);
    }

    public void showSourceFeedback(Request request) {
        if (this.fResizable && "resize".equals(request.getType())) {
            this.showChangeBoundsFeedback((ChangeBoundsRequest)request);
        } else {
            super.showSourceFeedback(request);
        }
    }

    public boolean understandsRequest(Request request) {
        if (this.fResizable && "resize".equals(request.getType())) {
            return true;
        }
        if ("move".equals(request.getType())) {
            return this.fMovable;
        }
        return super.understandsRequest(request);
    }

    List<Handle> createCornerHandles(GraphicalEditPart part) {
        ArrayList<Handle> handleList = new ArrayList<Handle>(4);
        handleList.add(this.createHandle(part, 20, this.getSouthInset(), this.getEastInset()));
        handleList.add(this.createHandle(part, 12, this.getSouthInset(), this.getWestInset()));
        handleList.add(this.createHandle(part, 9, this.getNorthInset(), this.getWestInset()));
        handleList.add(this.createHandle(part, 17, this.getNorthInset(), this.getEastInset()));
        return handleList;
    }

    Handle createHandle(GraphicalEditPart owner, int direction, int verticalInset, int horizontalInset) {
        InsetResizeHandle handle = new InsetResizeHandle(owner, direction, verticalInset, horizontalInset);
        handle.setCursor(Cursors.SIZEALL);
        handle.setDragTracker((DragTracker)new BPELDragEditPartsTracker((EditPart)owner));
        return handle;
    }

    List<Handle> createResizableHandles(GraphicalEditPart part) {
        ArrayList<Handle> handlesList = new ArrayList<Handle>(8);
        handlesList.add(this.createResizableHandle(part, 16, 0, this.getEastInset()));
        handlesList.add(this.createResizableHandle(part, 20, this.getSouthInset(), this.getEastInset()));
        handlesList.add(this.createResizableHandle(part, 4, this.getSouthInset(), 0));
        handlesList.add(this.createResizableHandle(part, 12, this.getSouthInset(), this.getWestInset()));
        handlesList.add(this.createResizableHandle(part, 8, 0, this.getWestInset()));
        handlesList.add(this.createResizableHandle(part, 9, this.getNorthInset(), this.getWestInset()));
        handlesList.add(this.createResizableHandle(part, 1, this.getNorthInset(), 0));
        handlesList.add(this.createResizableHandle(part, 17, this.getNorthInset(), this.getEastInset()));
        return handlesList;
    }

    Handle createResizableHandle(GraphicalEditPart owner, int direction, int verticalInset, int horizontalInset) {
        InsetResizeHandle handle = new InsetResizeHandle(owner, direction, verticalInset, horizontalInset);
        handle.setDragTracker((DragTracker)new ResizeTracker(owner, direction));
        return handle;
    }

    protected void eraseChangeBoundsFeedback(ChangeBoundsRequest request) {
        if ("move".equals(request.getType()) && !this.fMovable) {
            return;
        }
        super.eraseChangeBoundsFeedback(request);
    }

    protected void showChangeBoundsFeedback(ChangeBoundsRequest request) {
        if ("move".equals(request.getType()) && !this.fMovable) {
            return;
        }
        IFigure p = this.getDragSourceFeedbackFigure();
        Rectangle r = this.getHostFigure().getBounds().getCopy();
        this.getHostFigure().translateToAbsolute((Translatable)r);
        r.translate(request.getMoveDelta());
        Dimension resize = request.getSizeDelta();
        r.width += resize.width;
        r.height += resize.height;
        r.x += this.getDrawerInset();
        r.width -= this.getDrawerInset() * 2;
        p.translateToRelative((Translatable)r);
        p.setBounds(r);
    }

    protected IFigure createDragSourceFeedbackFigure() {
        ColorRegistry registry = BPELUIPlugin.INSTANCE.getColorRegistry();
        RectangleFigure r = new RectangleFigure();
        FigureUtilities.makeGhostShape((Shape)r);
        r.setLineStyle(4);
        r.setForegroundColor(registry.get("COLOR_BLACK"));
        Rectangle bounds = ((GraphicalEditPart)this.getHost()).getFigure().getBounds().getCopy();
        bounds.x += this.getDrawerInset();
        bounds.width -= this.getDrawerInset() * 2;
        r.setBounds(bounds);
        this.addFeedback((IFigure)r);
        return r;
    }

    protected int getDrawerInset() {
        return 0;
    }

    protected int getNorthInset() {
        return 0;
    }

    protected int getSouthInset() {
        return 0;
    }

    protected int getEastInset() {
        return 0;
    }

    protected int getWestInset() {
        return 0;
    }
}

