/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.properties;

import java.text.DateFormat;
import java.text.FieldPosition;
import java.util.Date;
import org.eclipse.bpel.common.ui.flatui.FlatFormAttachment;
import org.eclipse.bpel.common.ui.flatui.FlatFormData;
import org.eclipse.bpel.common.ui.flatui.FlatFormLayout;
import org.eclipse.bpel.ui.Messages;
import org.eclipse.bpel.ui.Policy;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class DateTimeSelector
extends Composite {
    static final String ID = "id";
    public static String[] DateTimeSelector_Months = new String[]{Messages.DateTimeSelector_Month_1, Messages.DateTimeSelector_Month_2, Messages.DateTimeSelector_Month_3, Messages.DateTimeSelector_Month_4, Messages.DateTimeSelector_Month_5, Messages.DateTimeSelector_Month_6, Messages.DateTimeSelector_Month_7, Messages.DateTimeSelector_Month_8, Messages.DateTimeSelector_Month_9, Messages.DateTimeSelector_Month_10, Messages.DateTimeSelector_Month_11, Messages.DateTimeSelector_Month_12};
    static final int YEAR = 0;
    static final int MONTH = 1;
    static final int DAY = 2;
    static final int HOUR = 3;
    static final int MINUTE = 4;
    static final int SECOND = 5;
    static final int LAST_IDX = 6;
    protected Object lastChangeContext;
    private Combo[] combo = new Combo[6];
    private Label timeSep;
    private Label timeSep2;
    private Label dateSep;
    private Label dateSep2;
    private int yearMin;
    private int yearMax;
    protected String dateSepText = "/";
    protected String timeSepText = ":";
    protected static final int[] rawDaysInMonth = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static String[] MONTH_NAMES;
    private FormToolkit wf;

    public static int daysInMonth(int monthMinusOne, int year) {
        if (monthMinusOne == 1 && (year & 3) == 0 && (year % 100 != 0 || year % 400 == 0)) {
            return 29;
        }
        return rawDaysInMonth[monthMinusOne];
    }

    public DateTimeSelector(FormToolkit toolkit, Composite parent, int style, int yearMin, int yearMax) {
        super(parent, style);
        this.wf = toolkit;
        this.yearMin = yearMin;
        this.yearMax = yearMax;
        if (MONTH_NAMES == null) {
            MONTH_NAMES = new String[12];
            int i = 0;
            while (i < MONTH_NAMES.length) {
                DateTimeSelector.MONTH_NAMES[i] = DateTimeSelector_Months[i];
                ++i;
            }
        }
        this.setLayout((Layout)new FillLayout());
        this.createControls(this);
    }

    private void createControls(Composite parent) {
        Composite composite = this.wf.createComposite(parent);
        FlatFormLayout layout = new FlatFormLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        FlatFormAttachment monthLeft = new FlatFormAttachment(0, 0);
        FlatFormAttachment monthRight = new FlatFormAttachment(30, 0);
        FlatFormAttachment dayLeft = new FlatFormAttachment(35, 0);
        FlatFormAttachment dayRight = new FlatFormAttachment(65, 0);
        FlatFormAttachment yearLeft = new FlatFormAttachment(70, 0);
        FlatFormAttachment yearRight = new FlatFormAttachment(100, 0);
        FlatFormAttachment hourLeft = new FlatFormAttachment(0, 0);
        FlatFormAttachment hourRight = new FlatFormAttachment(30, 0);
        FlatFormAttachment minuteLeft = new FlatFormAttachment(35, 0);
        FlatFormAttachment minuteRight = new FlatFormAttachment(65, 0);
        FlatFormAttachment secondLeft = new FlatFormAttachment(70, 0);
        FlatFormAttachment secondRight = new FlatFormAttachment(100, 0);
        int i = 0;
        while (i < this.combo.length) {
            this.combo[i] = new Combo(composite, 8);
            this.combo[i].setData(ID, (Object)i);
            ++i;
        }
        this.dateSep = this.wf.createLabel(composite, this.dateSepText, 0x1000000);
        this.dateSep2 = this.wf.createLabel(composite, this.dateSepText, 0x1000000);
        this.timeSep = this.wf.createLabel(composite, this.timeSepText, 0x1000000);
        this.timeSep2 = this.wf.createLabel(composite, this.timeSepText, 0x1000000);
        FlatFormData data = new FlatFormData();
        data.left = monthLeft;
        data.right = monthRight;
        data.top = new FlatFormAttachment(0, 0);
        this.combo[1].setLayoutData((Object)data);
        data = new FlatFormData();
        data.left = dayLeft;
        data.right = dayRight;
        data.top = new FlatFormAttachment(0, 0);
        this.combo[2].setLayoutData((Object)data);
        data = new FlatFormData();
        data.left = yearLeft;
        data.right = yearRight;
        data.top = new FlatFormAttachment(0, 0);
        this.combo[0].setLayoutData((Object)data);
        data = new FlatFormData();
        data.left = hourLeft;
        data.right = hourRight;
        data.top = new FlatFormAttachment((Control)this.combo[0], 4);
        this.combo[3].setLayoutData((Object)data);
        data = new FlatFormData();
        data.left = minuteLeft;
        data.right = minuteRight;
        data.top = new FlatFormAttachment((Control)this.combo[0], 4);
        this.combo[4].setLayoutData((Object)data);
        data = new FlatFormData();
        data.left = secondLeft;
        data.right = secondRight;
        data.top = new FlatFormAttachment((Control)this.combo[0], 4);
        this.combo[5].setLayoutData((Object)data);
        data = new FlatFormData();
        data.left = new FlatFormAttachment((Control)this.combo[1], 0);
        data.right = new FlatFormAttachment((Control)this.combo[2], 0);
        data.top = new FlatFormAttachment((Control)this.combo[1], 0, 0x1000000);
        this.dateSep.setLayoutData((Object)data);
        data = new FlatFormData();
        data.left = new FlatFormAttachment((Control)this.combo[2], 0);
        data.right = new FlatFormAttachment((Control)this.combo[0], 0);
        data.top = new FlatFormAttachment((Control)this.combo[1], 0, 0x1000000);
        this.dateSep2.setLayoutData((Object)data);
        data = new FlatFormData();
        data.left = new FlatFormAttachment((Control)this.combo[3], 0);
        data.right = new FlatFormAttachment((Control)this.combo[4], 0);
        data.top = new FlatFormAttachment((Control)this.combo[3], 0, 0x1000000);
        this.timeSep.setLayoutData((Object)data);
        data = new FlatFormData();
        data.left = new FlatFormAttachment((Control)this.combo[4], 0);
        data.right = new FlatFormAttachment((Control)this.combo[5], 0);
        data.top = new FlatFormAttachment((Control)this.combo[3], 0, 0x1000000);
        this.timeSep2.setLayoutData((Object)data);
        this.reorderDateWidgetsForLocale();
        this.init();
        this.layout(true);
    }

    private void reorderDateWidgetsForLocale() {
        DateFormat dateFlatFormat = DateFormat.getDateInstance();
        Date date = new Date();
        StringBuffer junkBuffer = new StringBuffer();
        FieldPosition pos = new FieldPosition(3);
        dateFlatFormat.format(date, junkBuffer, pos);
        int dayPos = pos.getBeginIndex();
        if (Policy.DEBUG) {
            System.out.println(junkBuffer);
        }
        junkBuffer.setLength(0);
        pos = new FieldPosition(2);
        dateFlatFormat.format(date, junkBuffer, pos);
        int monthPos = pos.getBeginIndex();
        junkBuffer.setLength(0);
        pos = new FieldPosition(1);
        dateFlatFormat.format(date, junkBuffer, pos);
        int yearPos = pos.getBeginIndex();
        Combo left = this.combo[1];
        Combo middle = this.combo[2];
        Combo right = this.combo[0];
        if (dayPos < monthPos) {
            if (monthPos < yearPos) {
                this.combo[2] = left;
                this.combo[1] = middle;
                this.combo[0] = right;
            } else if (dayPos < yearPos) {
                this.combo[2] = left;
                this.combo[0] = middle;
                this.combo[1] = right;
            } else {
                this.combo[0] = left;
                this.combo[2] = middle;
                this.combo[1] = right;
            }
        } else if (dayPos < yearPos) {
            this.combo[1] = left;
            this.combo[2] = middle;
            this.combo[0] = right;
        } else if (monthPos < yearPos) {
            this.combo[1] = left;
            this.combo[0] = middle;
            this.combo[2] = right;
        } else {
            this.combo[0] = left;
            this.combo[1] = middle;
            this.combo[2] = right;
        }
    }

    private void init() {
        this.populateCombos();
        this.setInitialSelections();
        this.addListeners();
    }

    private void populateComboWithInts(Combo combo, int start, int length) {
        combo.removeAll();
        int i = start;
        while (i < start + length) {
            combo.add(String.valueOf(i < 10 ? "0" : "") + String.valueOf(i));
            ++i;
        }
    }

    private void updateDaysCombo() {
        int sel = this.combo[2].getSelectionIndex();
        int days = DateTimeSelector.daysInMonth(this.combo[1].getSelectionIndex(), Integer.parseInt(this.combo[0].getText()));
        this.populateComboWithInts(this.combo[2], 1, days);
        this.combo[2].select(Math.min(sel, days - 1));
    }

    private void populateCombos() {
        this.populateComboWithInts(this.combo[0], this.yearMin, Math.max(0, this.yearMax - this.yearMin));
        this.combo[1].setItems(MONTH_NAMES);
        this.populateComboWithInts(this.combo[2], 1, 31);
        this.populateComboWithInts(this.combo[3], 0, 24);
        this.populateComboWithInts(this.combo[4], 0, 60);
        this.populateComboWithInts(this.combo[5], 0, 60);
    }

    private void setInitialSelections() {
        this.combo[0].select(0);
        this.combo[1].select(0);
        this.updateDaysCombo();
        this.combo[2].select(0);
        this.combo[3].select(12);
        this.combo[4].select(0);
        this.combo[5].select(0);
    }

    private void addListeners() {
        SelectionListener commonListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Combo cw = (Combo)e.widget;
                DateTimeSelector.this.lastChangeContext = cw.getData(DateTimeSelector.ID);
                if (cw == DateTimeSelector.this.combo[0] || cw == DateTimeSelector.this.combo[1]) {
                    DateTimeSelector.this.updateDaysCombo();
                }
                DateTimeSelector.this.selectionChanged();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        };
        int i = 0;
        while (i < 6) {
            this.combo[i].addSelectionListener(commonListener);
            ++i;
        }
    }

    public int[] getValues() {
        int[] v = new int[]{this.combo[0].getSelectionIndex() + this.yearMin, this.combo[1].getSelectionIndex() + 1, this.combo[2].getSelectionIndex() + 1, this.combo[3].getSelectionIndex(), this.combo[4].getSelectionIndex(), this.combo[5].getSelectionIndex()};
        return v;
    }

    public boolean setValues(int[] v) {
        if (!this.checkValues(v)) {
            return false;
        }
        this.combo[0].select(v[0] - this.yearMin);
        this.combo[1].select(v[1] - 1);
        this.updateDaysCombo();
        this.combo[2].select(v[2] - 1);
        this.combo[3].select(v[3]);
        this.combo[4].select(v[4]);
        this.combo[5].select(v[5]);
        return true;
    }

    protected boolean checkValues(int[] v) {
        if (v == null) {
            return false;
        }
        if (v[0] < this.yearMin || v[0] > this.yearMax) {
            return false;
        }
        if (v[1] < 1 || v[1] > 12) {
            return false;
        }
        if (v[2] < 1 || v[2] > DateTimeSelector.daysInMonth(v[1] - 1, v[0])) {
            return false;
        }
        if (v[3] < 0 || v[3] > 23) {
            return false;
        }
        if (v[4] < 0 || v[4] > 59) {
            return false;
        }
        return v[5] >= 0 && v[5] <= 59;
    }

    void selectionChanged() {
        Event e = new Event();
        e.type = 13;
        e.widget = this;
        e.widget.notifyListeners(e.type, e);
    }

    public void addSelectionListener(SelectionListener listener) {
        TypedListener typedListener = new TypedListener((SWTEventListener)listener);
        this.addListener(13, (Listener)typedListener);
    }

    public Object getUserContext() {
        return this.lastChangeContext;
    }

    public void restoreUserContext(Object userContext) {
        int i = (Integer)userContext;
        switch (i) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                this.combo[i].setFocus();
                return;
            }
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        int i = 0;
        while (i < this.combo.length) {
            this.combo[i].setEnabled(enabled);
            ++i;
        }
    }
}

