/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.properties;

import org.eclipse.bpel.common.ui.details.IValue;
import org.eclipse.bpel.common.ui.details.TextIValue;
import org.eclipse.bpel.common.ui.details.widgets.DecoratedLabel;
import org.eclipse.bpel.common.ui.details.widgets.StatusLabel2;
import org.eclipse.bpel.common.ui.flatui.FlatFormAttachment;
import org.eclipse.bpel.common.ui.flatui.FlatFormData;
import org.eclipse.bpel.model.BPELPackage;
import org.eclipse.bpel.ui.Messages;
import org.eclipse.bpel.ui.adapters.INamedElement;
import org.eclipse.bpel.ui.properties.BPELPropertySection;
import org.eclipse.bpel.ui.properties.EditController;
import org.eclipse.bpel.ui.util.BPELUtil;
import org.eclipse.bpel.ui.util.MultiObjectAdapter;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.commands.Command;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class NameSection
extends BPELPropertySection {
    protected Text fNameText;
    protected StatusLabel2 statusLabel;
    protected EditController fNameEditController;
    INamedElement fNamedElement;

    @Override
    protected MultiObjectAdapter[] createAdapters() {
        return new MultiObjectAdapter[]{new MultiObjectAdapter(){

            @Override
            public void notify(Notification n) {
                if (NameSection.this.markersHaveChanged(n)) {
                    NameSection.this.updateMarkers();
                    return;
                }
            }
        }};
    }

    @Override
    protected void basicSetInput(EObject input) {
        super.basicSetInput(input);
        this.fNamedElement = BPELUtil.adapt((Object)input, INamedElement.class);
        this.fNameEditController.setInput(input);
    }

    protected void createNameWidgets(Composite composite) {
        DecoratedLabel nameLabel = new DecoratedLabel(composite, 16384);
        this.fWidgetFactory.adapt((Composite)nameLabel);
        nameLabel.setText(Messages.NameDetails_BPEL_Name__3);
        this.statusLabel = new StatusLabel2(nameLabel);
        this.fNameText = this.fWidgetFactory.createText(composite, "");
        FlatFormData data = new FlatFormData();
        data.left = new FlatFormAttachment(0, BPELUtil.calculateLabelWidth((Widget)nameLabel, 131));
        data.right = new FlatFormAttachment(100, -10);
        data.top = new FlatFormAttachment(0, 4);
        this.fNameText.setLayoutData((Object)data);
        data = new FlatFormData();
        data.left = new FlatFormAttachment(0, 0);
        data.right = new FlatFormAttachment((Control)this.fNameText, -5);
        data.top = new FlatFormAttachment((Control)this.fNameText, 0, 0x1000000);
        nameLabel.setLayoutData((Object)data);
    }

    protected void createChangeTrackers() {
        this.fNameEditController = new EditController(this.getCommandFramework()){

            @Override
            public boolean checkNotification(Notification notification) {
                return NameSection.this.fNamedElement != null && NameSection.this.fNamedElement.isNameAffected(NameSection.this.fNameEditController.getInput(), notification);
            }

            @Override
            public Command createApplyCommand() {
                return NameSection.this.wrapInShowContextCommand(super.createApplyCommand());
            }
        };
        this.fNameEditController.setLabel(BPELPackage.eINSTANCE.getActivity_Name().getName());
        this.fNameEditController.setViewIValue((IValue)new TextIValue(this.fNameText));
        this.fNameEditController.setModeIValue(new IValue(){

            public Object get() {
                return NameSection.this.fNamedElement != null ? NameSection.this.fNamedElement.getName(NameSection.this.fNameEditController.getInput()) : null;
            }

            public void set(Object object) {
                if (NameSection.this.fNamedElement != null) {
                    NameSection.this.fNamedElement.setName(NameSection.this.fNameEditController.getInput(), object.toString());
                }
            }
        });
        this.fNameEditController.startListeningTo(new Control[]{this.fNameText});
    }

    @Override
    protected void createClient(Composite parent) {
        Composite composite = this.createFlatFormComposite(parent);
        this.createNameWidgets(composite);
        this.createChangeTrackers();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.bpel.ui.property_name");
    }

    @Override
    protected void updateMarkers() {
        this.statusLabel.clear();
        IMarker[] iMarkerArray = this.getMarkers(this.getInput());
        int n = iMarkerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker m = iMarkerArray[n2];
            this.statusLabel.addStatus(BPELUtil.adapt((Object)m, IStatus.class));
            ++n2;
        }
    }

    protected IStatus validate() {
        return this.validate(this.getInput());
    }

    protected IStatus validate(Object currentElement) {
        EObject elm;
        EObject elmContainer;
        if (currentElement instanceof EObject && (elmContainer = (elm = (EObject)currentElement).eContainer()) != null) {
            EList el = elmContainer.eContents();
            int i = 0;
            int j = el.size();
            while (i < j) {
                Object name;
                EObject loopElement;
                EAttribute eAttribute;
                Object next = el.get(i);
                if (next instanceof EObject && (eAttribute = this.getNAMEAttribute((loopElement = (EObject)next).eClass().getEAllAttributes())) != null && (name = loopElement.eGet((EStructuralFeature)eAttribute)) != null && name.equals(this.fNameText.getText()) && !loopElement.equals(currentElement)) {
                    String message = NLS.bind((String)Messages.NameDetails_RenameErrorMessage, (Object[])new Object[]{this.fNameText.getText()});
                    return new Status(4, "org.eclipse.bpel.ui", 4, message, null);
                }
                ++i;
            }
        }
        return new Status(0, "org.eclipse.bpel.ui", 0, "Hi There", null);
    }

    protected EAttribute getNAMEAttribute(EList list) {
        if (list != null) {
            int i = 0;
            while (i < list.size()) {
                EAttribute ea;
                EObject eo = (EObject)list.get(i);
                if (eo instanceof EAttribute && (ea = (EAttribute)eo).getName().equalsIgnoreCase("name")) {
                    return (EAttribute)eo;
                }
                ++i;
            }
        }
        return null;
    }

    @Override
    public Object getUserContext() {
        return null;
    }

    @Override
    public void restoreUserContext(Object userContext) {
        this.fNameText.setFocus();
    }

    @Override
    public void gotoMarker(IMarker marker) {
        this.fNameText.setFocus();
    }

    @Override
    public boolean isValidMarker(IMarker marker) {
        String context = null;
        try {
            context = (String)marker.getAttribute("href.context");
        }
        catch (Exception exception) {
            return false;
        }
        return "name".equals(context);
    }
}

