/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.validator.model;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.bpel.validator.model.ARule;
import org.eclipse.bpel.validator.model.IModelQuery;
import org.eclipse.bpel.validator.model.INode;
import org.eclipse.bpel.validator.model.IProblem;
import org.eclipse.bpel.validator.model.Validator;

public class Runner {
    INode fRoot;
    IModelQuery fModelQuery;
    IProblem[] fProblems = new IProblem[0];
    List<Validator> fValidators = new ArrayList<Validator>(256);
    Set<ARule> fSAChecks = new HashSet<ARule>();

    public Runner(IModelQuery query, INode root) {
        this.fRoot = root;
        this.fModelQuery = query;
    }

    void init() {
        this.fValidators.clear();
        ArrayList<INode> iteratorList = new ArrayList<INode>(32);
        iteratorList.add(this.fRoot);
        while (iteratorList.size() > 0) {
            List<INode> children;
            INode nextNode = (INode)iteratorList.remove(0);
            Validator validator = nextNode.nodeValidator();
            if (validator != null) {
                validator.setModelQuery(this.fModelQuery);
                validator.setSAChecks(this.fSAChecks);
                this.fValidators.add(validator);
            }
            if ((children = nextNode.children()).size() <= 0) continue;
            iteratorList.addAll(0, children);
        }
    }

    public IProblem[] run() {
        this.fSAChecks.clear();
        if (this.fValidators.size() < 1) {
            this.init();
        }
        for (Validator validator : this.fValidators) {
            validator.validate("pass1");
        }
        ArrayList<IProblem> problems = new ArrayList<IProblem>(64);
        for (Validator validator : this.fValidators) {
            validator.validate("pass2");
            IProblem[] iProblemArray = validator.getProblems();
            int n = iProblemArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProblem problem = iProblemArray[n2];
                problems.add(problem);
                ++n2;
            }
        }
        return problems.toArray(this.fProblems);
    }

    public Set<ARule> getSAChecks() {
        return this.fSAChecks;
    }
}

