/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.validator.rules;

import java.util.List;
import org.eclipse.bpel.validator.model.ARule;
import org.eclipse.bpel.validator.model.Filters;
import org.eclipse.bpel.validator.model.IFilter;
import org.eclipse.bpel.validator.model.INode;
import org.eclipse.bpel.validator.model.IProblem;
import org.eclipse.bpel.validator.model.NodeNameFilter;
import org.eclipse.bpel.validator.rules.CValidator;

public class CorrelationValidator
extends CValidator {
    public static IFilter<INode> PARENTS = new NodeNameFilter(ND_CORRELATIONS);
    protected String fSetName;
    protected String fInitiate;
    protected String fPattern;
    protected INode fActivityNode;
    protected INode fCorrelationSet;

    @Override
    protected void start() {
        super.start();
        this.fActivityNode = this.fParentNode.parentNode();
    }

    @ARule(sa=0, desc="Check the NCName of the correlation", author="michal.chmielewski@oracle.com", date="01/20/2007", errors="BPELC__UNSET_ATTRIBUTE,BPELC__INVALID_ATTRIBUTE_VALUE")
    public void rule_CheckName_1() {
        this.fSetName = this.getAttribute(this.mNode, AT_SET, 0, Filters.NC_NAME, true);
    }

    @ARule(sa=1010, desc="Check the initiate attribute values", author="michal.chmielewski@oracle.com", date="01/20/2007", errors="BPELC__UNSET_ATTRIBUTE,BPELC__INVALID_ATTRIBUTE_VALUE")
    public void rule_CheckInitiate_2() {
        this.fInitiate = this.getAttribute(this.mNode, AT_INITIATE, 0, Filters.INITIATE_FILTER, false);
        if (CorrelationValidator.isEmpty(this.fInitiate)) {
            this.fInitiate = "no";
        }
    }

    @ARule(sa=46, desc="Check the pattern attribute values of correlation", author="michal.chmielewski@oracle.com", date="02/20/2007", errors="BPELC__UNSET_ATTRIBUTE,BPELC__SET_ATTRIBUTE,BPELC__INVALID_ATTRIBUTE_VALUE")
    public void rule_CheckPatternValues_5() {
        this.fPattern = this.getAttribute(this.mNode, AT_PATTERN, 0, Filters.PATTERN_FILTER, false);
        if (CorrelationValidator.isEmpty(this.fPattern)) {
            this.fPattern = null;
        }
        boolean is2Way = this.getValue(this.fActivityNode, "2way", false);
        if (ND_INVOKE.equals(this.fActivityNode.nodeName())) {
            IProblem problem;
            if (is2Way && CorrelationValidator.isEmpty(this.fPattern)) {
                problem = this.createError();
                problem.fill("BPELC__UNSET_ATTRIBUTE", this.toString(this.mNode.nodeName()), AT_PATTERN, 0);
            }
            if (!is2Way && !CorrelationValidator.isEmpty(this.fPattern)) {
                problem = this.createError();
                problem.fill("BPELC__SET_ATTRIBUTE", AT_PATTERN, this.toString(this.mNode.nodeName()), 0);
            }
        } else if (!CorrelationValidator.isEmpty(this.fPattern)) {
            IProblem problem = this.createError();
            problem.fill("BPELC__SET_ATTRIBUTE", AT_PATTERN, this.toString(this.mNode.nodeName()), 0);
        }
    }

    @ARule(sa=0, desc="Check to see if the correlation is already specified", author="michal.chmielewski@oracle.com", date="01/20/2007", errors="BPELC_CORRELATION__EXIST")
    public void rule_CheckDuplicateCorrelation_10() {
        if (this.fSetName == null) {
            return;
        }
        String key = "set." + this.fSetName;
        if (this.containsValueKey(this.fParentNode, key)) {
            IProblem problem = this.createError();
            problem.fill("BPELC_CORRELATION__EXIST", this.toString(this.mNode.nodeName()), this.fSetName);
            return;
        }
        this.setValue(this.fParentNode, key, Boolean.TRUE);
    }

    @ARule(sa=0, desc="Check to see if the correlation set exists", author="michal.chmielewski@oracle.com", date="01/20/2007", errors="BPELC_CORRELATION__EXIST,BPELC__UNRESOLVED_ATTRIBUTE")
    public void rule_ExistCorrelationSet_12() {
        if (CorrelationValidator.isEmpty(this.fSetName) || ND_ON_EVENT.equals(this.fActivityNode.nodeName())) {
            return;
        }
        this.fCorrelationSet = this.mModelQuery.lookup(this.mNode, 4, this.fSetName);
        if (!this.checkAttributeNode(this.mNode, this.fCorrelationSet, AT_SET, 0)) {
            return;
        }
        List sets = this.getValue(this.fActivityNode, "correlation.sets", null);
        if (sets != null) {
            sets.add(this.fCorrelationSet);
        }
    }

    @ARule(sa=88, desc="Correlation set lookup, first associated scope, then ancestor scopes", author="michal.chmielewski@oracle.com", date="03/15/2007", errors="BPELC__UNSET_ATTRIBUTE,BPELC__UNRESOLVED_ATTRIBUTE")
    public void rule_ExistCorrelationSet_13() {
        if (CorrelationValidator.isEmpty(this.fSetName) || !ND_ON_EVENT.equals(this.fActivityNode.nodeName())) {
            return;
        }
        INode associatedScope = this.getValue(this.fActivityNode, "associated.scope", this.mNode);
        this.fCorrelationSet = this.mModelQuery.lookup(associatedScope, 4, this.fSetName);
        this.markSAExecution(null);
        if (!this.checkAttributeNode(this.mNode, this.fCorrelationSet, AT_SET, 0)) {
            return;
        }
        List sets = this.getValue(this.fActivityNode, "correlation.sets", null);
        if (sets != null) {
            sets.add(this.fCorrelationSet);
        }
    }
}

